#ifndef FORM_H
#define FORM_H

#include <fstream.h>

#include "QScanner.h"
#include "qlist.h"
#include "qstring.h"
#include "FormItem.h"
#include "FormItemText.h"
#include "FormItemCombo.h"
#include "ISqlServer.h"
#include "utils.h"


class Form
  {
  public:
    Form(void);
    ~Form(void);
    void clear(void);
    void addItem(FormItem *);
    void removeItem(QString);
    bool itemExists(QString, FormItem * = 0);
    void setName(QString);
    void setQuery(QString);
    QString getName(void);
    QString getQuery(void);
    bool writeFile(const char *);
    int readFile(const char *);
    bool writeDatabase(ISqlServer *);
    bool readDatabase(ISqlServer *, QString);
    int findItemFromName(QString, FormItem * = 0);
    static bool removeFromDatabase(ISqlServer *, QString);
    QList<FormItem> items;
  private:
    Form(const Form &);
    QString name;
    QString query;
  };

#endif




