#include "FormItemCombo.h"
#include "utils.h"

FormItemCombo::FormItemCombo(void)
  {
  }

FormItemCombo::~FormItemCombo(void)
	{
	}

bool FormItemCombo::writeFile(ofstream &out)
  {
  out << "  combo " << name << endl
      << "    {" << endl;
  for(unsigned int i=0; i<choices.count(); i++)
    out << "    option=" << choices.at(i) << ";" << endl;
  out << "    }" << endl;
  return true;
  }

int FormItemCombo::getType(void)
  {
  return TypeCombo;
  }

void FormItemCombo::addChoice(QString str)
  {
  choices.append(str);
  }

bool FormItemCombo::writeDatabase(ISqlServer *sql, QString formId)
	{
	QString query = "INSERT INTO __KmysqlFields (FormRef, Name, Type, Extra) VALUES (";
	query += formId + ", ";
	query += "'" + name + "', ";
	query += "'combo', ";
	query += "'choices(";
	for(unsigned int i=0; i<choices.count(); i++)
		{
    query += choices.at(i);
    if(i != choices.count()-1)
    	query += ",";
    }
  query += ")')";
  QueryResult res = sql->query(query);
  if(res.type == QueryResult::Error)
  	return false;
  return true;
	}

bool FormItemCombo::setOptions(QString str)
	{
	Utils::Option option;
	if(!option.fromString(str))
		return false;
	if(option.getName() == "choices")
		{
		for(unsigned int i = 0; i < option.getParamCount(); i++)
			addChoice(option.getParam(i));
		}
	else
		{
		warning("unknown combo option: '%s'", (const char *)option.getName());
		return false;
		}
	return true;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	







