#ifndef ISQLSERVER_H
#define ISQLSERVER_H

#include <kmysql/IObject.h>
#include <kmysql/QueryResult.h>

interface ISqlServer : IObject
	{
	virtual QueryResult connect(QString, QString, QString) = 0;
  virtual void close(void) = 0;
  virtual QueryResult selectBase(QString) = 0;
  virtual QueryResult getBases(void) = 0;
  virtual QueryResult getTables(QString, QString = 0) = 0;
  virtual QueryResult query(QString) = 0;
  virtual QueryResult createBase(QString) = 0;
  virtual QueryResult dropBase(QString) = 0;
  virtual QueryResult shutdown(void) = 0;
  virtual QueryResult reload(void) = 0;
  virtual QString serverInfo(void) = 0;
  virtual bool isConnected(void) = 0;
	};

#define UIID_SQLSERVER 0xa156cd01

#endif // ISQLSERVER_H

