
#include "pluginmanager.h"

PluginManager::PluginManager(void)
	{
	for(int i=0; i<MAX_PLUGINS; i++)
		plugins[i] = 0;
	}
	
PluginManager::~PluginManager(void)
	{
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i])
			unregisterPlugin(i);
	}
	
int PluginManager::registerPlugin(QString path)
	{
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i] == 0)
			{
			Plugin *plugin = new Plugin;
			if(!plugin->load(path))
				return plugin->getErrorCode();
			if(getPluginByName(plugin->getPluginName()) >= 0)
				{
				plugin->unload();
				return -10;
				}
			plugins[i] = plugin;
			warning("Register plugin: %s -> id %d", (const char *)path, i);
			return i;
			}
	return -11;
	}

int PluginManager::unregisterPlugin(int id)
	{
	if(id >= MAX_PLUGINS)
		return -1;
	if(!plugins[id])
		return -2;
	if(!plugins[id]->unload())
		return -3;
	delete plugins[id];
	plugins[id] = 0;
  warning("Unregister plugin: %d", id);
	return 0;
	}
	
ISqlServer *PluginManager::createInstance(int id)
	{
	if(id >= MAX_PLUGINS)
		return 0;
	Plugin *plugin = plugins[id];
	if(!plugin)
		return 0;
	IObject *instance = plugin->createInstance();
	if(!instance)
		return 0;
	ISqlServer *iSql = (ISqlServer *)(instance->queryInterface(UIID_SQLSERVER));
	if(!iSql)
		return 0;
	return iSql;
	}
		
const char *PluginManager::getPluginName(int id)
	{
	if(id >= MAX_PLUGINS)
		return 0;
	Plugin *plugin = plugins[id];
	if(!plugin)
		return 0;
	return plugin->getPluginName();
	}
	
const char *PluginManager::getPluginInfo(int id)
	{
	if(id >= MAX_PLUGINS)
		return 0;
	Plugin *plugin = plugins[id];
	if(!plugin)
		return 0;
	return plugin->getPluginInfo();
	}

const char *PluginManager::getPluginPath(int id)
	{
	if(id >= MAX_PLUGINS)
		return 0;
	Plugin *plugin = plugins[id];
	if(!plugin)
		return 0;
	return plugin->getPluginPath();
	}
	
int PluginManager::getPluginByName(QString name)
	{
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i] && name == plugins[i]->getPluginName())
			return i;
	return -1;
	}


QStrList *PluginManager::getPluginNames(void)
	{
	QStrList *res = new QStrList;
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i])
			res->append(plugins[i]->getPluginName());
	return res;
	}


void PluginManager::savePref(KConfig *config)
	{
	// Save all modules
	config->setGroup("Modules");
	int count = 0;
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i])
			count++;
	config->writeEntry("Count", count);
	int j = 0;
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i])
			{
			QString nr;
			nr.sprintf("%d", j);
			config->writeEntry(nr, plugins[i]->getPluginPath());
			j++;
			}	
	}



void PluginManager::readPref(KConfig *config)
	{
	config->setGroup("Modules");
	int count = config->readNumEntry("Count", 0);
	for(int i=0; i<count; i++)
		{
		QString nr;
		nr.sprintf("%d", i);
		QString pluginPath = config->readEntry(nr);
		registerPlugin(pluginPath);
		}
	}

int PluginManager::count(void)
	{
	int res = 0;
	for(int i=0; i<MAX_PLUGINS; i++)
		if(plugins[i])
			res++;
	return res;
	}
