#ifndef _UDM_SERVER_H
#define _UDM_SERVER_H


/* Spider follow types */
#define UDM_FOLLOW_UNKNOWN	-1

#define UDM_FOLLOW_NO		0
#define UDM_FOLLOW_PATH		1
#define UDM_FOLLOW_SITE		2
#define UDM_FOLLOW_WORLD	3

/* Server match types */
#define UDM_SERVER_SUBSTR 	0x01
#define UDM_SERVER_STRING	0x02
#define UDM_SERVER_REGEX	0x04

/* Server match flags */
#define UDM_SERVER_MATCH	0x10
#define UDM_SERVER_CS		0x20

#define UDM_SRV_TYPE(x)		((x)&(0x0F))
#define UDM_SET_SRV_TYPE(x,t)	((x)=(((x)&(0xFFFFFFF0))+(t)))

extern __INDLIB__ int	UdmInitServer(UDM_SERVER * srv);
extern __INDLIB__ int	UdmAddServer(UDM_ENV * Conf,UDM_SERVER * srv, int load_flags, int match_type);
extern UDM_SERVER *	UdmFindServer(UDM_ENV *,char * url,char * alias);
extern void		UdmFreeServers(UDM_ENV * Conf);
extern void		UdmSortServers(UDM_ENV * Conf);

#endif
