# copyright (C) 1997-2002 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu
proc echo {args} {foreach argument $args {puts -nonewline "$argument "}; puts {}}

set rcsId {$Id: threads.tcl,v 1.4 2001/12/30 17:23:02 jfontain Exp $}


package provide threads [lindex {$Revision: 1.4 $} 1]


namespace eval threads {

    variable available [expr {![catch {package require Thread 2}]}]

    proc error {thread information} {
        variable errorScript

        if {[info exists errorScript($thread)]} {
            uplevel #0 $errorScript($thread) [list $information]                                    ;# always invoke at global level
        } else {
            puts stderr $information
        }
    }

    if $available {
        thread::errorproc ::threads::error
    }

    proc catchError {thread script} {
        variable errorScript

        if {[string length $script]==0} {
            catch {unset errorScript($thread)}
        } else {
            set errorScript($thread) $script
        }
    }

}


class worker {

    proc worker {this} {
        set ($this,thread) [thread::create]
        threads::catchError $($this,thread) "worker::error $this"
    }

    proc ~worker {this} {
        thread::send -async $($this,thread) thread::unwind
        threads::catchError $($this,thread) {}
    }

    proc error {this information} {
        set ($this,return) {}
        ::error $information
    }

    proc evaluate {this script} {             ;# public procedure: evaluate script in background (unblocks) and wait till completion
#        thread::send -async $($this,thread)\
#            "thread::send [thread::id] \"set ::worker::($this,return) \{\[eval [list $script]\]\}\""
set ($this,return) {}
echo    [thread::id]    thread::send -notify "set ::worker::($this,continue) {}" $($this,thread)
        thread::send -notify "set ::worker::($this,continue) {}" $($this,thread)\
            "thread::send [thread::id] \"set ::worker::($this,return) \{\[eval [list $script]\]\}\""
        vwait ::worker::($this,continue)
echo    [thread::id] $($this,thread)
        set return $($this,return)
echo        unset ($this,return) ($this,continue)
#        unset ($this,return) ($this,continue)
        return $return
    }

}
