// msql2mysqlWrapper - Version 1.0
// USE @ YOUR OWN RISK
// alfred@sb.net  1999-06-10

#include <stdio.h>
#include <stdlib.h>
#include <mysql.h>
#include "msql2mysqlWrapper.h"


#if defined(__STDC__) || defined(__cplusplus)
#  define __ANSI_PROTO(x)	x
#else
#  define __ANSI_PROTO(x)	()
#endif

#ifdef __cplusplus
extern "C" {
#endif


#define MAX_FAKE_CONNECTIONS 10
/*
** API msql library functions
*/
char msqlErrMsg[1000];

MYSQL * fakeMySQL[MAX_FAKE_CONNECTIONS];
MYSQL * lastQuery = NULL;  // to hold the last MYSQL * query for msql's lame storeResult

int msqlConnect (char * host) {
// search for socket
  int sock=0;
  for (sock=0; fakeMySQL[sock] != NULL && sock < MAX_FAKE_CONNECTIONS; sock++);
  if (sock == MAX_FAKE_CONNECTIONS) {
    sprintf(msqlErrMsg , "wrapper: reached max connections");
    return -1;
  }
// init
  fakeMySQL[sock] = mysql_init(NULL);
  if (fakeMySQL[sock] == NULL) {
    sprintf(msqlErrMsg, "wrapper: could not init MySQL_init");
    return -1;
  }
// connect
  //SAL change, change host to
  if (mysql_real_connect(fakeMySQL[sock],"mysql.server.com","username","password",NULL,0,NULL,0) == NULL) {
    sprintf(msqlErrMsg, "%s", mysql_error(fakeMySQL[sock]));
    mysql_close(fakeMySQL[sock]);
    return -1;
  }
return sock;
}

int msqlSelectDB (int sock, char* query) {
  if (mysql_select_db(fakeMySQL[sock], query) != 0) {
    sprintf(msqlErrMsg , "%s", mysql_error(fakeMySQL[sock]) );
    return -1;
  }
return 0;
}

int msqlQuery (int sock, char* query) {
  if (mysql_query(fakeMySQL[sock], query) != 0) {
    sprintf(msqlErrMsg , "%s", mysql_error(fakeMySQL[sock]) );
    return -1;
  }
  lastQuery = fakeMySQL[sock];
return 0;
}

int msqlCreateDB (int inum, char* str) {
  sprintf(msqlErrMsg , "wrapper: Use CREATE DATABASE query instead");
return -1;
}

int msqlDropDB (int inum, char* str) {
  sprintf(msqlErrMsg , "wrapper: Use DROP DATABASE query instead");
return -1;
}

int msqlShutdown (int sock) {
  if (mysql_shutdown(fakeMySQL[sock]) != 0) {
    sprintf(msqlErrMsg , "%s", mysql_error(fakeMySQL[sock]) );
    return -1;
  }
return 0;
}

int msqlReloadAcls (int inum) {
  sprintf(msqlErrMsg , "wrapper: This function msqlReloadAcls not wrapped");
return -1;
}

int msqlGetProtoInfo() {
  sprintf(msqlErrMsg , "wrapper: This function msqlGetProtoInfo not wrapped");
return -1;
}

char *msqlGetServerInfo() {
  sprintf(msqlErrMsg , "wrapper: This function msqlGetServerInfo not wrapped");
return NULL;
}

char *msqlGetHostInfo() {
  sprintf(msqlErrMsg , "wrapper: This function msqlGetHostInfo not wrapped");
return NULL;
}

void msqlClose (int sock) {
  mysql_close(fakeMySQL[sock]);
  fakeMySQL[sock] = NULL;
return;
}

void msqlDataSeek (m_result* result, int pos) {
  mysql_data_seek(result->mysql_res, pos);
return;
}

void msqlFieldSeek (m_result* result, int pos) {
  if(!result)
     return;
  mysql_field_seek(result->mysql_res, pos);
return;
}

void msqlFreeResult (m_result* result) {
  if (result != NULL) {
    mysql_free_result(result->mysql_res);
    free(result);
    result=NULL;
  return;
  }
  sprintf(msqlErrMsg , "wrapper: WARNING: Freeing NULL pointer");
return;
}

m_row msqlFetchRow (m_result* result) {
return (m_row)mysql_fetch_row(result->mysql_res);
}

m_field* msqlFetchField (m_result* result) {
  MYSQL_FIELD * field = NULL;
//init msql mfield
  result->lastField.name = NULL;
  result->lastField.table = NULL;
  result->lastField.type = 0;
  result->lastField.length = 0;
  result->lastField.flags = 0;
//get MYSQL field and set msql lastField
  field = mysql_fetch_field(result->mysql_res);
  if (field == NULL) {
    return NULL;
  }
  result->lastField.name = field->name;
  result->lastField.table = field->table;
  //types
   //int
  if (field->type == FIELD_TYPE_SHORT ||
      field->type == FIELD_TYPE_LONG ||
      field->type == FIELD_TYPE_INT24 ||
      field->type == FIELD_TYPE_LONGLONG
     ) result->lastField.type = INT_TYPE;
  else
   //char
  if (field->type == FIELD_TYPE_TINY ||
      field->type == FIELD_TYPE_CHAR ||
      field->type == FIELD_TYPE_STRING ||
      field->type == FIELD_TYPE_VAR_STRING || 
      field->type == FIELD_TYPE_BLOB
     ) result->lastField.type = CHAR_TYPE;
  else
   //real
  if (field->type == FIELD_TYPE_DECIMAL ||
      field->type == FIELD_TYPE_FLOAT ||
      field->type == FIELD_TYPE_DOUBLE
     ) result->lastField.type = REAL_TYPE;
  else
   //null
  if (field->type == FIELD_TYPE_NULL) result->lastField.type = NULL_TYPE;
   //else set field to  -1 (soft error)
  else {
    result->lastField.type = -1;
    sprintf(msqlErrMsg, "wrapper: field not recognized, probably an unrecognized MYSQL FIELD_TYPE");
  }
  //length
  result->lastField.length = field->length;
  //flags
  if (IS_NOT_NULL(field->flags)) result->lastField.flags |= NOT_NULL_FLAG;
  if (IS_PRI_KEY (field->flags)) result->lastField.flags |= PRI_KEY_FLAG;
return &(result->lastField);
}

m_result* msqlListDBs (int sock) {
// malloc msql m_result mres
  m_result *mres = (m_result*)malloc(sizeof(m_result));
  if (mres == NULL) {
    sprintf(msqlErrMsg, "wrapper: out of memory");
    return NULL;
  }
// allocate MYSQL_RES
  mres->mysql_res = mysql_list_dbs(fakeMySQL[sock], NULL);
  if (mres->mysql_res == NULL) {
    sprintf(msqlErrMsg, "%s", mysql_error(fakeMySQL[sock]));
    free(mres);
    return NULL;
  }
  mres->numRows   = (int)mysql_num_rows(mres->mysql_res);
  mres->numFields = (int)mysql_num_fields(mres->mysql_res);
return mres;
}

m_result* msqlListTables (int sock) {
// malloc msql m_result
  m_result *mres = (m_result*)malloc(sizeof(m_result));
  if (mres == NULL) {
    sprintf(msqlErrMsg, "wrapper: out of memory");
    return NULL;
  }
  mres->mysql_res = mysql_list_tables(fakeMySQL[sock], NULL);
  if (mres->mysql_res == NULL) {
    sprintf(msqlErrMsg, "%s", mysql_error(fakeMySQL[sock]));
    free(mres);
    return NULL;
  }
  mres->numRows   = (int)mysql_num_rows(mres->mysql_res);
  mres->numFields = (int)mysql_num_fields(mres->mysql_res);
return mres;
}

m_result* msqlListFields (int sock, char* tableName) {
// malloc msql m_result
  m_result *mres = (m_result*)malloc(sizeof(m_result));
  if (mres == NULL) {
    sprintf(msqlErrMsg, "wrapper: out of memory");
    return NULL;
  }
  mres->mysql_res = mysql_list_fields(fakeMySQL[sock], tableName, NULL);
  if (mres->mysql_res == NULL) {
    sprintf(msqlErrMsg, "%s", mysql_error(fakeMySQL[sock]));
    free(mres);
    return NULL;
  }
  mres->numRows   = (int)mysql_num_rows(mres->mysql_res);
  mres->numFields = (int)mysql_num_fields(mres->mysql_res);
return mres;
}

m_result* msqlStoreResult() {
// malloc msql m_result
  m_result *mres = (m_result*)malloc(sizeof(m_result));
  if (mres == NULL) {
    sprintf(msqlErrMsg, "wrapper: out of memory");
    return NULL;
  }
// malloc MYSQL res
  if ((mres->mysql_res = mysql_store_result(lastQuery)) == NULL) {
    sprintf(msqlErrMsg, "%s", mysql_error(lastQuery));
    free(mres);
    return NULL;
  }
  mres->numRows   = (int)mysql_num_rows(mres->mysql_res);
  mres->numFields = (int)mysql_num_fields(mres->mysql_res);
return mres;
}

int msqlNumFields(m_result* res)
{
   if(!res)
   {
      return 0;
   }
   else
   {
      return res->numFields;
   }
}

int msqlNumRows(m_result* res)
{
   if(!res)
      return 0;
   else
      return res->numRows;
}

void Debug(char *msg)
{
   FILE* fp;
   fp = fopen("/tmp/mysqlwrapper.log", "a");
   if(!fp)
      return;
   fprintf(fp, "MYSQLDEBUG: %s\n", msg);
   fflush(fp);
   fclose(fp);

   return;
}

#ifdef __cplusplus
}
#endif

