package mysqladmin;

/** Create Index: Create Index as a part of Admin
 *  Version 1.01 25. May 1999
 *  Fredy Fischer
 *
 *  this has been created to Create Indices on mySQL-Databases
 *  it only returns a JPanel, so it can easily been 
 *  used in different kind of windows
 */

/** Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JPanel; 
import javax.swing.JFrame;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;

public class CreateIndex extends JPanel {
    private boolean connected=false;
    private TableRows tableRows;
    private JTextArea query;
    private JTextField index;
    private JCheckBox unique;
    private JButton create,add;
    private Tables table;
    private JPanel workPanel,mainPanel;
    private t_connect connection;
    public String getTable() { return table.getSelectedValue().toString(); }
    public String getIndex() { return index.getText(); }

    /** to find out, when the user wants to close
     *  this application, set a listener onto (JButton)CreateIndex.cancel 
     **/
    public JButton cancel;

    public String getQuery() { return query.getText(); }
    
    /**
       * Get the value of host.
       * @return Value of host.
       */

    private String host;
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    



    private String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    

    private String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}


    private String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}


    String dbTable;
    
    /**
       * Get the value of the Table.
       * @return Value of the Table.
       */
    public String getDbTable() {return dbTable;}
    
    /**
       * Set the value of dbTable.
       * @param v  Value to assign to dbTable.
       */
    public void setDbTable(String  v) {this.dbTable = v;}
    
    private String uni() {
	if ( unique.isSelected() ) {
	    return "UNIQUE";
	} else {
	    return " ";
	}
    }

    private JPanel mainPanel() {

	mainPanel = new JPanel();
	mainPanel.setLayout(new BorderLayout());

	mainPanel.add("West",tables());

	workPanel = rows();
	mainPanel.add("Center",workPanel);
	mainPanel.add("South",buttons());

	return mainPanel;
    }


    private void doUpdate() {

	mainPanel.remove(workPanel);
	workPanel = rows();
	mainPanel.add("Center",workPanel);
	mainPanel.updateUI();

    }



    private JPanel tables() {
	
	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());
	
	table = new Tables(getHost(),getUser(),getPassword(),getDatabase());
        // set the Listener onto the table-List
        MouseListener mouseListener = new MouseAdapter() {
        public void mouseClicked(MouseEvent e) {
         if (e.getClickCount() == 1) {
	     doUpdate();
	 }
         if (e.getClickCount() == 2) {
	     doUpdate();
	 }
        }};
        table.addMouseListener(mouseListener);        


	JScrollPane scp = new JScrollPane(table);
        panel.setBorder(BorderFactory.createEtchedBorder());
	panel.add(scp);
	return panel;
    }

    private JPanel buttons() {
	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());
	
	create = new JButton("Create Index");
	create.setToolTipText("Create this index");
	create.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		execQuery();
		}});
	

	cancel = new JButton("Cancel");
	cancel.setToolTipText("Oh, that is not what I wanted to do");
	cancel.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		connection.close();
		}});
	

	panel.add(create);
	panel.add(cancel);

	return panel;
    }
	

    private JPanel rows() {

	JPanel panel = new JPanel();
	panel.setLayout(new BorderLayout());

	JPanel panel3 = new JPanel();
	panel3.setLayout(new FlowLayout());
        panel3.setBorder(BorderFactory.createEtchedBorder());


	add = new JButton(">");
	add.setToolTipText("adds this row to the index");
	add.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String s = getQuery();
		if (s.charAt(s.length()-2) != '(' ) query.append(",");
		query.append(tableRows.getSelectedValue().toString() + " ");
		tableRows.removeElement(tableRows.getSelectedIndex());
		query.updateUI();
		}});


	tableRows = new TableRows(connection,getTable());
	tableRows.setEnabled(false);
	JScrollPane scp = new JScrollPane(tableRows);
	
	query = new JTextArea(5,20);
	query.setWrapStyleWord(true);
	query.setLineWrap(true);
	query.setEditable(true);

	JScrollPane queryPane = new JScrollPane(query);

	JPanel panel2 = new JPanel();
	panel2.setLayout(new FlowLayout());
	
	panel2.add(new JLabel("Indexname: "));
	index = new JTextField(20);
	index.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		if (getIndex().length() > 1) {
		    tableRows.setEnabled(true);
		    //query.setText("alter table " + getTable() + " add index ");
		    query.setText("create " + uni() + " index " + getIndex() + " on " + getTable() + " ( ");
		    // query.append(getIndex() + " ( ");
		    
		}
		}});
	

	panel2.add(index);

	unique = new JCheckBox("Unique");
	unique.setSelected(false);
	panel2.add(unique);


	panel3.add(scp);
	panel3.add(add);
	panel3.add(queryPane);

	panel.add("North",panel2);
	panel.add("Center",panel3);

	return panel;
    }
	
    private void message(String msg) {
    JOptionPane.showMessageDialog(null, msg,"Message",JOptionPane.WARNING_MESSAGE);
    }


    private void execQuery() {

	if ( ! getQuery().endsWith(")") )query.append(")");
        query.updateUI();
	try {
	    int records = connection.stmt.executeUpdate(getQuery());
	    message("mmmhhh, looks like index has been successfully created");
	} catch (Exception excpt) {
		     message("mmmhhh, looks like it did not work..\n"+excpt.getMessage().toString());
	}
    }



    public CreateIndex (String host,String user, String password, String database) {

	setHost(host);
	setUser(user);
	setPassword(password);
	setDatabase(database);

	workPanel = new JPanel();

	connection = new t_connect(getHost(), getUser(), getPassword(),getDatabase());
	if (connection.getError() != null) { message(connection.getError()); }

	this.setLayout(new BorderLayout());
	this.add("Center",mainPanel());


    }

    public static void main(String args[]) {

	if (args.length == 4) {
	JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {System.exit(0);}
        });
	CreateIndex panel = new CreateIndex(args[0],args[1],args[2],args[3]);
	panel.cancel.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		System.exit(0);
		}});
	
        frame.getContentPane().add("Center", panel);
	frame.pack();
        frame.setVisible(true);

	} else {
	    System.out.println("Syntax: java CreateIndex host user password database");
	    System.exit(0);
	}


    }
}
           
