package mysqladmin;

/** GenerateCode, generates Java-Code out of a table and is a part of Admin...
 *  Version 1.1 01. June 1999
 *  Fredy Fischer 
 *
 *  this has been created to query mySQL-Databases
 *  it only returns a JPanel, so it can easily been 
 *  used in different kind of windows
 */


/** Admin is a Tool around mySQL to do basic jobs
    for DB-Administrations, like:
    - create/ drop tables
    - create  indices
    - perform sql-statements
    - simple form
    - a guided query
    and a other usefull things in DB-arena

    Admin V1.0 
    Copyright (c) 1999 Fredy Fischer
                       se-afs@dial.eunet.ch

		       Fredy Fischer
		       Hulmenweg 36
		       8405 Winterthur
		       Switzerland

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**/


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.sql.*;
import java.io.*;
import javax.swing.*;
import javax.swing.BorderFactory; 
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.JLabel;
import javax.swing.JPanel; 
import javax.swing.JFrame;
import javax.swing.event.*;
import javax.swing.text.*;
import javax.swing.border.*;
import java.awt.datatransfer.*;
import java.lang.reflect.*;

public class GenerateCode extends JPanel {

    String host;
    
    /**
       * Get the value of host.
       * @return Value of host.
       */
    public String getHost() {return host;}
    
    /**
       * Set the value of host.
       * @param v  Value to assign to host.
       */
    public void setHost(String  v) {this.host = v;}
    
    
    String user;
    
    /**
       * Get the value of user.
       * @return Value of user.
       */
    public String getUser() {return user;}
    
    /**
       * Set the value of user.
       * @param v  Value to assign to user.
       */
    public void setUser(String  v) {this.user = v;}
    
    
    
    String password;
    
    /**
       * Get the value of password.
       * @return Value of password.
       */
    public String getPassword() {return password;}
    
    /**
       * Set the value of password.
       * @param v  Value to assign to password.
       */
    public void setPassword(String  v) {this.password = v;}
    
    
    String database;
    
    /**
       * Get the value of database.
       * @return Value of database.
       */
    public String getDatabase() {return database;}
    
    /**
       * Set the value of database.
       * @param v  Value to assign to database.
       */
    public void setDatabase(String  v) {this.database = v;}
    
    private JButton save, copy, copySwing, copyAWT;
    private JSlider slW, slH;
    public JButton cancel;
    private JButton generate;
    private JList columns;
    private Tables table;
    private JTextArea code,codeSwing, codeAWT, messageBoard;
    private TableColumns colu;
    private Vector v;
    private JTabbedPane jtp;
 

   
    
    String activeClass;
    
    /**
       * Get the value of activeClass.
       * @return Value of activeClass.
       */
    public String getActiveClass() {return activeClass;}
    
    /**
       * Set the value of activeClass.
       * @param v  Value to assign to activeClass.
       */
    public void setActiveClass(String  v) {this.activeClass = v;}
    
    
    private String swingFile;
    
    /**
       * Get the value of swingFile.
       * @return Value of swingFile.
       */
    public String getSwingFile() {return swingFile;}
    
    /**
       * Set the value of swingFile.
       * @param v  Value to assign to swingFile.
       */
    public void setSwingFile(String  v) {this.swingFile = v;}
    
    
    private String codeFile;
    
    /**
       * Get the value of codeFile.
       * @return Value of codeFile.
       */
    public String getCodeFile() {return codeFile;}
    
    /**
       * Set the value of codeFile.
       * @param v  Value to assign to codeFile.
       */
    public void setCodeFile(String  v) {this.codeFile = v;}
    

    public GenerateCode(String host, String user, String password, String database) {

	setHost(host);
	setUser(user);
	setPassword(password);
	setDatabase(database);

	this.setLayout(new BorderLayout());
	this.add("Center",infoPanel());
	this.add("South",buttonPanel());

    }

    private JPanel infoPanel() {


	FfAlignerLayoutPanel panel = new FfAlignerLayoutPanel();
	panel.setBorder(BorderFactory.createEtchedBorder());
	panel.setNumberOfRows(2);
	panel.addComponent(new JLabel("Table"));
	JLabel l = new JLabel("Primary Key(s)");
	l.setToolTipText("you have to select the primary key to define the unique identifier for a row");
	panel.addComponent(l);

	table = new Tables(getHost(),getUser(),getPassword(),getDatabase());

        // set the Listener onto the table-List
        MouseListener mouseListener = new MouseAdapter() {
        public void mouseClicked(MouseEvent e) {
         if (e.getClickCount() == 1) {
	     setTable();
	 }
         if (e.getClickCount() == 2) {
	     setTable();
	 }
        }};
        table.addMouseListener(mouseListener);        


	JScrollPane scp = new JScrollPane(table);
	panel.addComponent(scp);


	final Toolkit tk = this.getToolkit();
	copy = new JButton(loadImage("copy.gif"));
	copy.setToolTipText("Copies the wrapper-code to the clipboard");
	copy.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String s = code.getText();
		StringSelection ss = new StringSelection(s);
		tk.getSystemClipboard().setContents(ss,ss);
		}});
	copy.setEnabled(false);

	columns = new JList();
	ListSelectionModel lsm = columns.getSelectionModel();
	columns.setSelectionMode(lsm.MULTIPLE_INTERVAL_SELECTION);
	JScrollPane scp1 = new JScrollPane(columns);
	panel.addComponent(scp1);
	
	code = new JTextArea(10,40);
        java.awt.Font f = new  java.awt.Font("Monospaced", Font.PLAIN, 12);
	code.setFont(f);
	code.setEditable(false);
	JScrollPane scp2 = new JScrollPane(code);
	JPanel cButtonPanel = new JPanel();
	cButtonPanel.setLayout(new FlowLayout());
	cButtonPanel.add(copy);
	JPanel wrapperPanel = new JPanel();
	wrapperPanel.setLayout(new BorderLayout());
	wrapperPanel.setBorder(BorderFactory.createEtchedBorder());
	wrapperPanel.add("Center",scp2);
	wrapperPanel.add("South",cButtonPanel);



	codeSwing = new JTextArea(4,40);
	codeSwing.setFont(f);
	codeSwing.setEditable(false);
	JScrollPane scpS = new JScrollPane(codeSwing);
	copySwing = new JButton(loadImage("copy.gif"));
	copySwing.setToolTipText("Copies the code to the clipboard");
	copySwing.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String s = codeSwing.getText();
		StringSelection ss = new StringSelection(s);
		tk.getSystemClipboard().setContents(ss,ss);
		}});
	copySwing.setEnabled(false);
	JPanel sButtonPanel = new JPanel();
	sButtonPanel.setLayout(new FlowLayout());
	sButtonPanel.add(copySwing);

	JPanel swingPanel = new JPanel();
	swingPanel.setLayout(new BorderLayout());
	swingPanel.setBorder(BorderFactory.createEtchedBorder());
	swingPanel.add("Center",scpS);
	swingPanel.add("South",sButtonPanel);

	slW = new JSlider(JSlider.HORIZONTAL,5,50,25);
	slW.setToolTipText("Selects the width of max. JTextField,\nthen changes to JTextArea");
	slW.createStandardLabels(1,5);
	slW.setPaintTicks(true);
        slW.setMajorTickSpacing(5);
        slW.setMinorTickSpacing(1);
        slW.setPaintLabels( true );
        slW.setSnapToTicks( true );

	swingPanel.add("North",slW);

	slH = new JSlider(JSlider.VERTICAL,2,50,10);
	slH.setToolTipText("Selects the max. heigth of a JTextArea");
	slH.createStandardLabels(1,5);
	slH.setPaintTicks(true);
        slH.setMajorTickSpacing(5);
        slH.setMinorTickSpacing(1);
        slH.setPaintLabels( true );
        slH.setSnapToTicks( true );

	swingPanel.add("East",slH);
		


 
	codeAWT = new JTextArea(6,40);
	codeAWT.setFont(f);
	codeAWT.setEditable(false);
	JScrollPane scpA = new JScrollPane(codeAWT);
	copyAWT = new JButton(loadImage("copy.gif"));
	copyAWT.setToolTipText("Copies the code to the clipboard");
	copyAWT.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String s = codeAWT.getText();
		StringSelection ss = new StringSelection(s);
		tk.getSystemClipboard().setContents(ss,ss);
		}});
	copyAWT.setEnabled(false);
	JPanel aButtonPanel = new JPanel();
	aButtonPanel.setLayout(new FlowLayout());
	aButtonPanel.add(copyAWT);

	JPanel awtPanel = new JPanel();
	awtPanel.setLayout(new BorderLayout());
	awtPanel.setBorder(BorderFactory.createEtchedBorder());
	awtPanel.add("Center",scpA);
	awtPanel.add("South",aButtonPanel);

	JPanel msgPanel = new JPanel();
	msgPanel.setLayout(new BorderLayout());
	msgPanel.setBorder(BorderFactory.createEtchedBorder());
	messageBoard = new JTextArea(10,40);
	messageBoard.setEditable(false);
	messageBoard.setBackground(Color.red);
	messageBoard.setForeground(Color.yellow);
	JScrollPane msgScrollPane = new JScrollPane(messageBoard);
	msgPanel.add("Center",msgScrollPane);

	JPanel msgButtonPanel = new JPanel();
	msgButtonPanel.setLayout(new FlowLayout());
	JButton msgClear = new JButton("Clear");
	msgClear.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		messageBoard.setText("");
		}});
	msgButtonPanel.add(msgClear);
	msgPanel.add("South",msgButtonPanel);



	jtp = new JTabbedPane();
	jtp.add("SQL-Wrapper",wrapperPanel);
	jtp.add("Swing-Code",swingPanel);
	jtp.add("Messages",msgPanel);
	//jtp.add("AWT-Code",awtPanel);


	JPanel panel2 = new JPanel();
	panel2.setLayout(new BorderLayout());
	panel2.add("Center",panel);

	JPanel panel3 = new JPanel();
	panel3.setLayout(new FlowLayout());
	panel3.add(jtp);

	panel2.add("South",panel3);

	return panel2;
    }


    private void setTable() {

	colu = new TableColumns(getHost(), getUser(), getPassword(), getDatabase(), table.getSelectedValue().toString());
	
	v = colu.getAllCols();
	String[] s;
        s = new String[v.size()];
	for (int i = 0; i < v.size(); i++) {
	    Columns c = new Columns();
	    c = (Columns) v.elementAt(i);
	    s[i] = c.getName();
	}
	columns.setListData(s);
	columns.updateUI();
    }

    private JPanel buttonPanel() {

	JPanel panel = new JPanel();
	panel.setLayout(new FlowLayout());
        panel.setBorder(BorderFactory.createEtchedBorder());	

	generate = new JButton(loadImage("gencode.gif"));
	generate.setToolTipText("Generates the Java-Code");
	generate.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		if (columns.getSelectedIndices().length > 0 ) {
		    generate();
		    save.setEnabled(true);
		    copy.setEnabled(true);
		    copySwing.setEnabled(true);
		} else { 
		    message("you need to selected a table and Primary-Key(s)");
		}
		}});
	

	JButton compile = new JButton(loadImage("build.gif"));
	compile.setToolTipText("compile");
	compile.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		setActiveClass("applications."+ getDatabase() + "." + firstUpper(table.getSelectedValue().toString()+"Grid"));
		 execCMD("javac "+ getCodeFile());
		 execCMD("javac "+ getSwingFile());
		}});
	JButton runit = new JButton(loadImage("run.gif"));
	runit.setToolTipText("Run it in a Frame");
	runit.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		runJava();
		}});
	


	cancel   = new JButton(loadImage("exit.gif"));
	cancel.setToolTipText("Exit");

	save = new JButton(loadImage("save.gif"));
	save.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		saveCode();
		save.setEnabled(false);
		}});
	save.setToolTipText("Stores the Code in the directory [dir]/applications/"+getDatabase());
	save.setEnabled(false);

	/**
	final Toolkit tk = this.getToolkit();
	copy = new JButton(loadImage("copy.gif"));
	copy.setToolTipText("Copies the code to the clipboard");
	copy.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		String s = code.getText();
		StringSelection ss = new StringSelection(s);
		tk.getSystemClipboard().setContents(ss,ss);
		}});
	copy.setEnabled(false);
	**/



	panel.add(generate);
	panel.add(cancel);
	panel.add(save);
	//panel.add(copy);
	panel.add(compile);
	panel.add(runit);
	return panel;

    }

    private void saveCode() {
	JFileChooser chooser = new JFileChooser(); 
	chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
	String dir = "";
	chooser.setDialogTitle("Choose Directory");
	
	int returnVal = chooser.showOpenDialog(this);
	if(returnVal == JFileChooser.APPROVE_OPTION) {
	    dir=chooser.getCurrentDirectory() + File.separator + chooser.getSelectedFile().getName();

	    FileInfo fi = new FileInfo(dir, null);
	    if (fi.getTyp() == 1) { 
		reallySave(dir);
	    } else {
		message("This is not a directory");
	    }
	} else {
	    message("Did not save");
	}
    }
	
    private void reallySave(String dir) {


	setCodeFile(dir + File.separator + "applications"+ File.separator + getDatabase() + File.separator + firstUpper(table.getSelectedValue().toString()+"Row.java"));

	setSwingFile (dir + File.separator + "applications"+ File.separator + getDatabase() + File.separator + firstUpper(table.getSelectedValue().toString()+"Grid.java")); 
	

	// create directory if not existing
	    File f = new File(dir + File.separator + "applications" + File.separator + getDatabase());
	   f.mkdir();

	try {
	      	DataOutputStream outptstr = new DataOutputStream(
		     new BufferedOutputStream(
		     new FileOutputStream(codeFile)));
			 outptstr.writeBytes(code.getText());
			 outptstr.flush();
			 outptstr.close();

	      	 outptstr = new DataOutputStream(
		     new BufferedOutputStream(
		     new FileOutputStream(swingFile)));
			 outptstr.writeBytes(codeSwing.getText());
			 outptstr.flush();
			 outptstr.close();


			 message("Created: " + codeFile + " \n         " + swingFile);
			 setActiveClass("applications."+getDatabase() + "." +  firstUpper(table.getSelectedValue().toString()+"Grid.java")); 
			}
	catch(IOException execp) { message(execp.toString()); }





    }

    private void execCMD(String cmdx) {

	final String cmd = cmdx;
	Thread t = new Thread() {
	    public void run() {

		Cursor cu = new Cursor(Cursor.WAIT_CURSOR);
		jtp.setCursor(cu);

		message(cmd + "\n");
		try {
		    Runtime rt = Runtime.getRuntime();
		    Process prcs = rt.exec(cmd);
		    DataInputStream d = new DataInputStream(
							    prcs.getInputStream());
		    String line;
		    while ( (line=d.readLine() ) != null )
			message(line);
		    message("Done: " + cmd + "\n");
		    Cursor cu1 = new Cursor(Cursor.DEFAULT_CURSOR);
		    jtp.setCursor(cu1);
		}
		catch (IOException ioe) {
		    message("IO-Exception: " + ioe);
		}
	    }
	};
	t.start();
    }

    private void runJava() {
	Thread t = new Thread() {
	    public void run() {

		try {
		    Class ca = Class.forName(getActiveClass());
		    Constructor cons[] = ca.getConstructors();
		    String params[] = { getHost(), getUser(), getPassword()};
		    cons[0].newInstance(params);
		    final JFrame frame = new JFrame(firstUpper(table.getSelectedValue().toString()+"Grid.java"));
		    frame.getContentPane().add((JTabbedPane)cons[0].newInstance(params));
		    frame.addWindowListener(new WindowAdapter() {
			public void windowActivated(WindowEvent e) {}
			public void windowClosed(WindowEvent e) {}
			public void windowClosing(WindowEvent e) {frame.dispose();}
			public void windowDeactivated(WindowEvent e) {}
			public void windowDeiconified(WindowEvent e) {}
			public void windowIconified(WindowEvent e) {}
			public void windowOpened(WindowEvent e) {}});
	    
		    frame.pack();
		    frame.setVisible(true);
		} catch (Exception cne) { message(cne.toString()); }
	    }
	};
	t.start();
    }



    private void message(String msg) {
 
	messageBoard.append("\n" + msg);
	messageBoard.updateUI();
	jtp.setSelectedIndex(2);

    }

    private String firstUpper(String s) {
	s = s.substring(0,1).toUpperCase() + s.substring(1);
	return s;
    }

    private String getDBMS() {

       t_connect con = new t_connect(getHost(), getUser(), getPassword(), getDatabase());
       try {
           DatabaseMetaData md = con.con.getMetaData();
	   return md.getDatabaseProductName();
       } catch (Exception exception) { return "not applicable"; }

    }

    private ImageIcon loadImage(String image) {

        ImageIcon img = new ImageIcon(Admin.class.getResource("images"+ File.separator + image));
        return img;
    }


    private String toDay() {

	Calendar c = Calendar.getInstance();
   
	return  Integer.toString(c.get(Calendar.YEAR)) + "-" + 
	        Integer.toString(c.get(Calendar.MONTH)+1)+ "-" + 
                Integer.toString(c.get(Calendar.DATE));

    }

    private String getPrimaryKey() {

	String pk = " (";
	int p[] = columns.getSelectedIndices();
	    
	for (int i = 0; i < p.length; i++) {
	    Columns c = new Columns();
	     c = (Columns) v.elementAt(p[i]);

            if ( i > 0 ) pk = pk + " + \" and ";
	    pk = pk + c.getName() + " = " ;
	    if ( getType(c.getType()).startsWith("int"))     pk = pk + " \" + Integer.toString(get" + firstUpper(c.getName()) + "()) ";
	    if ( getType(c.getType()).startsWith("String"))  pk = pk + " \" + \"'\" + get" + firstUpper(c.getName()) + "() + \"'\" ";
	    if ( getType(c.getType()).startsWith("java.sql.Date"))    pk = pk + " \" + \"'\" + get" + firstUpper(c.getName()) + "() + \"'\" ";
	    if ( getType(c.getType()).startsWith("float"))   pk = pk + " \" + Float.toString(get" + firstUpper(c.getName()) + "()) ";
	    if ( getType(c.getType()).startsWith("double"))  pk = pk + " \" + Double.toString(get" + firstUpper(c.getName()) + "()) ";	   
	}
	pk = pk + " + \")\"";
	return pk;

    }


    private String getType(String s) {
	String t="String";

       if ( Integer.parseInt(s) ==  java.sql.Types.CHAR )          t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.VARCHAR )       t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.LONGVARCHAR )   t = "String";;
       if ( Integer.parseInt(s) ==  java.sql.Types.BINARY )        t = "String";;
       if ( Integer.parseInt(s) ==  java.sql.Types.LONGVARBINARY ) t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.VARBINARY )     t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.DATE )          t = "java.sql.Date";
       if ( Integer.parseInt(s) ==  java.sql.Types.TIME )          t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.TIMESTAMP )     t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.OTHER )         t = "String";
       if ( Integer.parseInt(s) ==  java.sql.Types.INTEGER )       t = "int";
       if ( Integer.parseInt(s) ==  java.sql.Types.DOUBLE )        t = "double";
       if ( Integer.parseInt(s) ==  java.sql.Types.FLOAT )         t = "float";

       return t;
    }

    private String getInitValue(String s) {
	String t = "\"\"";
	if (s.startsWith("int"))    t = "0";
	if (s.startsWith("double")) t = "0";
	if (s.startsWith("float"))  t = "0";
	if (s.startsWith("java.sql.Date"))   t = "java.sql.Date.valueOf(toDay())";

	return t;
    }

    private void generate() {
      
  
	  final Thread generateThread = new Thread() {
	  public void run() {

	  Cursor cu = new Cursor(Cursor.WAIT_CURSOR);
	  jtp.setCursor(cu);
	  String theCode;
	  theCode = "package applications." + getDatabase() + ";\n\n" +
	      "/** this has been generated by Fredy's Admin-Tool for SQL-Databases\n" +
	      " *  Date: " + toDay() + "\n" +
	      " * \n" +
	      " *  RDBMS:    " + getDBMS() + " \n"+
	      " *  Table:    " + table.getSelectedValue().toString() + "\n" +
	      " *  Database: " + getDatabase() + "\n" +
	      " *\n" +
	      " *  Admin is under GPL\n" +
	      " *\n" +
	      " *  Fredy Fischer\n" +
	      " *  Hulmenweg 36\n" +
	      " *  8405 Winterthur\n" +
	      " *  Switzerland\n" +
	      " *\n" +
	      " * se-afs@dial.eunet.ch\n" +
	      " *\n" +
	      " **/\n" +
	      "\n" +
	      "import java.sql.*;\n" +
	      "import java.util.Calendar;\n" +
	      "import applications.basics.t_connect;\n" +
	      "\n" +
	      "public class " + firstUpper(table.getSelectedValue().toString()) + "Row { \n" +
	      "    private  ResultSet sqlresult;\n" +
	      "    private  t_connect con;\n" +
	      "    \n" +
	      "    String host;\n" +
	      "  \n" +  
	      "    /**\n" +
	      "       * Get the value of host.\n" +
	      "       * @return Value of host.\n" +
	      "       */\n" +
	      "    public String getHost() {return host;}\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Set the value of host.\n" +
	      "       * @param v  Value to assign to host\n" +
	      "       */\n" +
	      "    public void setHost(String  v) {this.host = v;}\n" +
	      "    \n" +
	      "    String user;\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Get the value of user.\n" +
	      "       * @return Value of user.\n" +
	      "       */\n" +
	      "    public String getUser() {return user;}\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Set the value of user.\n" +
	      "       * @param v  Value to assign to user.\n" +
	      "       */\n" +
	      "    public void setUser(String  v) {this.user = v;}\n" +
	      "    \n" +
	      "    String password;\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Get the value of password.\n" +
	      "       * @return Value of password.\n" +
	      "       */\n" +
	      "    public String getPassword() {return password;}\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Set the value of password.\n" +
	      "       * @param v  Value to assign to password.\n" +
	      "       */\n" +
	      "    public void setPassword(String  v) {this.password = v;}\n\n" +
	      "\n" +
	      "    String database;\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Get the value of database.\n" +
	      "       * @return Value of database.\n" +
	      "       */\n" +
	      "    public String getDatabase() {return database;}\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Set the value of database.\n" +
	      "       * @param v  Value to assign to database.\n" +
	      "       */\n" +
	      "    public void setDatabase(String  v) {this.database = v;}\n\n";
    
	  // now we are creating the get and set Methods for each column
	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	      
	      theCode = theCode +		
		  "       " + getType(c.getType()) + " " + c.getName() + ";\n\n" +
		  "    /**\n" +
		  "       * Set the value of " + c.getName() + ".\n" +
		  "       * @param v  Value to assign to " + c.getName() + " .\n" +
		  "       */\n" +	
		  "       public void set" + firstUpper(c.getName()) + "(" + getType(c.getType()) + "  v) { this." + c.getName() + " = v;}\n\n" +
		  "    /**\n" +
		  "       * Get the value of " + c.getName() + ".\n" +
		  "       * @return  Value of " + c.getName() + " .\n" +
		  "       */\n" +	
		  "       public " + getType(c.getType()) +" get" + firstUpper(c.getName()) + "() {return " + c.getName() + ";} \n\n";
	  }

	  // now we generate the query-Methodes

	  theCode = theCode + 
	      "    String query;\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Get the value of query.\n" +
	      "       * @return Value of query.\n" +
	      "       */\n" +
	      "    public String getQuery() {return query;}\n" +
	      "    \n" +
	      "    /**\n" +
	      "       * Set the value of query.\n" +
	      "       * @param v  Value to assign to query.\n" +
	      "       */\n" +
	      "    public void setQuery(String  v) {this.query = v;}\n\n" +
	      "    private String toDay() {\n\n" +
	      "	        Calendar c = Calendar.getInstance();\n\n" +
	      "    	return  Integer.toString(c.get(Calendar.YEAR)) + \"-\" + \n" +
	      "                 Integer.toString(c.get(Calendar.MONTH)+1)+ \"-\" + \n" +
              "                 Integer.toString(c.get(Calendar.DATE));\n" +
              "     }\n";


	  // this is constructor 1

	  theCode = theCode +
	      "    public " + firstUpper(table.getSelectedValue().toString()) + "Row(String host, String user, String password) {\n" +
	      "\n" +	
	      "	setDatabase(\"" + getDatabase() + "\");\n" +
	      "\n" +
	      "	setHost(host);\n" +
	      "	setUser(user);\n" +
	      "	setPassword(password);\n\n";


	  // now there is to generate the inits
	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	      
	      theCode = theCode +		
		  "	set" + firstUpper(c.getName()) + "(" + getInitValue(getType(c.getType())) + ");\n";
	  }
	  theCode = theCode + "\n\n    }\n\n";
    


	  // this is constructor 2
	  theCode = theCode +
	      "    public " + firstUpper(table.getSelectedValue().toString()) + "Row(String host, String user, String password";
	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	      if (getType(c.getType()).startsWith("java.sql.Date")) {
		   theCode = theCode +	",String " + c.getName();
	      } else {
		  theCode = theCode +	"," + getType(c.getType()) + " " + c.getName();
	      }
	  }
	  theCode = theCode + ") {\n" +
	      "\n" +	
	      "	setDatabase(\"" + getDatabase() + "\");\n" +
	      "\n" +
	      "	setHost(host);\n" +
	      "	setUser(user);\n" +
	      "	setPassword(password);\n\n";

	  // now there is to generate the inits
	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	    
	      if (getType(c.getType()).startsWith("java.sql.Date")) {
		         theCode = theCode + 
			     "        set" + firstUpper(c.getName()) + "(java.sql.Date.valueOf(" + c.getName() +  "));\n";
		      } else {
			  theCode = theCode +		
			      "	set" + firstUpper(c.getName()) + "(" + c.getName() + ");\n";
		      }
	  }
	  theCode = theCode + "\n\n    }" + 
	      "    private String execQuery() {\n" +
	      "\n" +
	      "	t_connect c = new t_connect(getHost(), getUser(), getPassword(), getDatabase());\n" +
	      "	if (c.getError() != null) {\n" +
	      "	    return \"Connection Error: \"+ c.getError();\n" +
	      "	}	\n" +
	      "\n" +
	      "\n" +
	      "        try {\n" +
	      "	    int records = c.stmt.executeUpdate(getQuery());\n" +
	      "	    c.close(); 	\n" +
	      "	} catch (Exception e) {\n" +
	      "	    return e.getMessage().toString();\n" +
	      "	}\n" +
	      "	return \"ok\";\n" +
	      "    }\n" +
	      "\n" +
	      "    private String selectQuery() {\n" +
	      "\n" +
	      "	con = new t_connect(getHost(), getUser(), getPassword(), getDatabase());\n" +
	      "	if (con.getError() != null) {\n" +
	      "	    return \"Connection Error: \"+ con.getError();\n" +
	      "	}\n" +	
	      "\n" +
	      "	try {\n" +
	      "          sqlresult = con.stmt.executeQuery(getQuery());\n" +
	      "\n" +
	      "	} catch (Exception e) {\n" +
	      "	    return e.getMessage().toString();\n" +
	      "	}\n" +
	      "	return \"ok\";\n" +
	      "    }\n" +
	      "\n" +
	      "\n" +
	      "    public " + firstUpper(table.getSelectedValue().toString()) + "Row next() {\n" +
	      "\n" +
	      "	" +  firstUpper(table.getSelectedValue().toString()) + "Row k = new " + firstUpper(table.getSelectedValue().toString()) + "Row(getHost(),getUser(),getPassword());\n" +
	      "	try {\n" +
	      "	    if (sqlresult.next()) {\n"; 

	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	      if (getType(c.getType()).startsWith("java.sql.Date") ) {
		  theCode = theCode +	"               k.set" + firstUpper(c.getName()) + "(sqlresult.getDate(\"" + c.getName() + "\"));\n";  
	      } else {
	      theCode = theCode +	"               k.set" + firstUpper(c.getName()) + "(sqlresult.get" + firstUpper(getType(c.getType())) + "(\"" + c.getName() + "\"));\n";
	      }
	  }
	  theCode = theCode +
	      "		return k;\n" +
	      "	    } else \n" +
	      "		{ con.close();\n" +
	      "		  return null; \n" +
	      "		}\n" +
	      "	} catch  (Exception e) {\n" +
	      "          return null;\n" +
	      "	}\n" +
	      "    }\n";

	  // now we are implementing the data manipulation methods
	  // INSERT
	  theCode = theCode +
	      "    public String insert() {\n" +
	      "\n" +
	      "      setQuery (\"insert into " + table.getSelectedValue().toString() +" (";
	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	    
	      if (i == 0) {
		  theCode = theCode + c.getName();
	      } else {
		  theCode = theCode + ", " + c.getName();
	      }
	  }
	  theCode = theCode + ") values (\" +";
	  for (int i = 0; i < v.size(); i++) {
	      Columns c = new Columns();
	      c = (Columns) v.elementAt(i);
	      if (i > 0) theCode = theCode + " + \", \" + ";
	      if ( getType(c.getType()).startsWith("int"))     theCode = theCode + "Integer.toString(get" + firstUpper(c.getName()) + "())";
	      if ( getType(c.getType()).startsWith("String"))  theCode = theCode + "\"'\" + get" + firstUpper(c.getName()) + "() +\"'\"";
	      if ( getType(c.getType()).startsWith("java.sql.Date"))    theCode = theCode + "\"'\" + get" + firstUpper(c.getName()) + "() +\"'\"";
	      if ( getType(c.getType()).startsWith("float"))   theCode = theCode + "Float.toString(get" + firstUpper(c.getName()) + "())";
	      if ( getType(c.getType()).startsWith("double"))  theCode = theCode + "Double.toString(get" + firstUpper(c.getName()) + "())";
	  }
	  theCode = theCode + " + \")\");" +
	      "  \n" +     
	      "       return execQuery();\n" +
	      " \n" +      
	      "    }\n";


	  // UPDATE
	  
	  theCode = theCode + "\n\n" +
	      "    public String update() {\n" +
	      "\n" +
	      "	setQuery(\"update " + table.getSelectedValue().toString() +" set " ;
	  for (int i = 0; i < v.size(); i++) {
	    Columns c = new Columns();
	    c = (Columns) v.elementAt(i);
	    if (i > 0) theCode = theCode + " + \", ";
	    theCode = theCode + c.getName() + " = \" + ";
	    if ( getType(c.getType()).startsWith("int"))     theCode = theCode + "Integer.toString(get" + firstUpper(c.getName()) + "())";
	    if ( getType(c.getType()).startsWith("String"))  theCode = theCode + "\"'\" + get" + firstUpper(c.getName()) + "() + \"'\"";
	    if ( getType(c.getType()).startsWith("java.sql.Date"))    theCode = theCode + "\"'\" + get" + firstUpper(c.getName()) + "() + \"'\"";
	    if ( getType(c.getType()).startsWith("float"))   theCode = theCode + "Float.toString(get" + firstUpper(c.getName()) + "())";
	    if ( getType(c.getType()).startsWith("double"))  theCode = theCode + "Double.toString(get" + firstUpper(c.getName()) + "()) ";
	}
	  theCode = theCode + " + \" where " + getPrimaryKey() + " );\n";
	  theCode = theCode +
	      "        return execQuery();\n" +
	      "    }\n";

	  // DELETE
	  theCode = theCode + "\n\n    public String delete() {\n\n";
	  theCode = theCode + " 	setQuery(\"delete from " + table.getSelectedValue().toString() + " where " + getPrimaryKey() + ");\n";
	  theCode = theCode + "        return execQuery();\n    }";


	  // let's generate a searchAll-Methode
	  theCode = theCode +"\n\n    public String searchAll() {\n\n";
	  theCode = theCode + " 	setQuery(\"select * from " + table.getSelectedValue().toString() +  "\");\n";
	  theCode = theCode + "        return selectQuery();\n    }";



	// now we generate the Code to find a row by all of its columns

	for (int i = 0; i < v.size(); i++) {
	    Columns c = new Columns();
	    c = (Columns) v.elementAt(i);

	    theCode = theCode + "\n\n    // if you set exact to true, it will return exact the corresponding row\n";
	    theCode = theCode + "    // if you set exact to false,all rows corresponding  like-Statement will be returned";
	    theCode = theCode + "\n\n    public String searchBy" +  firstUpper(c.getName()) + "(" + getType(c.getType()) + " " + c.getName() + ", boolean exact) {\n\n";
	    theCode = theCode + "	String e;\n";
	    theCode = theCode + "	if ( exact ) { \n";
	    theCode = theCode + "	   e = \"=\"; } else {\n";
	    theCode = theCode + "	   e = \"like\"; }\n ";

	    theCode = theCode + "	setQuery(\"select * from " + table.getSelectedValue().toString() + " where " + c.getName() + " \" + e + \" \" + ";
	    if ( getType(c.getType()).startsWith("int"))     theCode = theCode + "Integer.toString(" + c.getName() + ") ";
	    if ( getType(c.getType()).startsWith("String"))  theCode = theCode + "\"'\" + " + c.getName() + " + \"'\"";
	    if ( getType(c.getType()).startsWith("java.sql.Date"))    theCode = theCode + "\"'\" + " + c.getName() + " + \"'\"";
	    if ( getType(c.getType()).startsWith("float"))   theCode = theCode + "Float.toString(" + c.getName() + ") ";
	    if ( getType(c.getType()).startsWith("double"))  theCode = theCode + "Double.toString(" + c.getName() + ") ";
	    theCode = theCode + " + \" order by " + c.getName() + "\");\n";
	    theCode = theCode + 
		"	return selectQuery();\n" +
                "    }\n";
	}

	theCode = theCode + "\n\n}\n";
	code.setText(theCode);
	code.updateUI();

	GenerateSwing gs = new GenerateSwing(v,getDatabase());
	gs.setLng(slW.getValue());
	gs.setNoRows(slH.getValue());
	codeSwing.setText(gs.getSwingCode());
	codeSwing.updateUI();

	Cursor cu1 = new Cursor(Cursor.DEFAULT_CURSOR);
	jtp.setCursor(cu1);


	  }
	  };
	generateThread.start();
      
    }
 
   



    public static void main(String args[]) {

	System.out.println("Fredy's GenerateCode\n" +
			   "-------------------- Version 1.1\n" +
                           "is a part of Admin and under GPL");
	if ( args.length != 4) {
	    System.out.println("Syntax: java GenerateCode host user password database");
	    System.exit(0);
	}
	JFrame f = new JFrame("Generate Code");
	f.getContentPane().setLayout(new FlowLayout());
	GenerateCode g = new GenerateCode(args[0], args[1], args[2], args[3]);
	f.getContentPane().add(g);
	f.pack();
	f.addWindowListener(new WindowAdapter() {
	    public void windowActivated(WindowEvent e) {}
	    public void windowClosed(WindowEvent e) {}
	    public void windowClosing(WindowEvent e) {System.exit(0);}
            public void windowDeactivated(WindowEvent e) {}
            public void windowDeiconified(WindowEvent e) {}
            public void windowIconified(WindowEvent e) {}
            public void windowOpened(WindowEvent e) {}});
	g.cancel.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
		System.exit(0);
		}});
	f.setVisible(true);
    }
}
