#include <unistd.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qfont.h>
#include <qwindowsstyle.h>
#include <qplatinumstyle.h> 
#include <qmotifstyle.h>
#include <qcdestyle.h>
#include <qtranslator.h>
#include <qobject.h>

#include <stdlib.h>
#include "mainwindow.h"
#include "resource.h"
#include "mdiwindow.h"

#define TARGET	"/usr/local/share/mysql_navigator/po"

int main(int argc,char **argv)
{
	QApplication app(argc,argv);

	QTranslator translator(0);
	
	QString l;
	
	l.sprintf("%s", getenv("LANG"));

	if(l.isEmpty())
	{
	}
	else
	{
		if(l== QString("ko_KR.EUC"))
		{
			translator.load("mysql_navigator_ko.qm", TARGET);
			app.installTranslator(&translator);
		}
		else
		{
			translator.load(QString("mysql_navigator_") + l+ QString(".qm"), TARGET); 
			app.installTranslator(&translator);
		}
	}

	app.setStyle(new QWindowsStyle());

	MainWindow *mysql = new MainWindow(&app);

	mysql->setCaption(QObject::tr("MySQL Navigator 0.9.0"));
 	
	mysql->resize(800,600);
	
	app.setMainWidget(mysql);
	
	mysql->show();
	
	return  app.exec();
}
