#include "edit.h"
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>

void Edit::slot_new()
{
	File *window = new File(work_space,0,WDestructiveClose);

	window->flag = TRUE;

	connect(window, SIGNAL(signal_message(const QString &, int)), this, SLOT(slot_message(const QString &, int)));
	
	window->resize(400,350);
	
	window->setCaption("Noname");

	window->show();
}

void Edit::slot_open()
{
	QString si = QFileDialog::getOpenFileName(QString::null, QString::null, this);

	if(!si.isEmpty())
	{
		File *window= new File(work_space,0,WDestructiveClose);
		connect(window, SIGNAL(signal_message(const QString &, int)), this, SLOT(slot_message(const QString &, int)));
		window->resize(400,350);
		window->setCaption(si);
		window->load(si);

		window->flag = TRUE;

		window->show();
	}
	else
	{
		statusBar()->message("Loading aborted", 2000);
	}
}

void Edit::slot_save()
{
	((File *)work_space->activeWindow())->save();
}

void Edit::slot_save_as()
{
	((File *)work_space->activeWindow())->save_as();
}

void Edit::slot_print()
{
}

void Edit::slot_close()
{
	if(((File *)work_space->activeWindow()))
	{
		((File *)work_space->activeWindow())->close();
	}
}

void Edit::slot_quit()
{
	while((File *)work_space->activeWindow())
	{
		((File *)work_space->activeWindow())->close();
	}
	
	close();
}

void Edit::slot_message(const QString &message, int time)
{
	statusBar()->message(message, time);
}

void Edit::slot_undo()
{
	((File *)work_space->activeWindow())->edit->undo();
}

void Edit::slot_redo()
{
	((File *)work_space->activeWindow())->edit->redo();
}

void Edit::slot_cut()
{
	((File *)work_space->activeWindow())->edit->cut();
}

void Edit::slot_copy()
{
	((File *)work_space->activeWindow())->edit->copy();
}

void Edit::slot_paste()
{
	((File *)work_space->activeWindow())->edit->paste();
}

void Edit::slot_paste_special()
{
}

void Edit::slot_clear()
{
	((File *)work_space->activeWindow())->edit->clear();
}

void Edit::slot_select_all()
{
	((File *)work_space->activeWindow())->edit->selectAll();
}

void Edit::slot_about()
{
	QMessageBox::information(this, tr("MySQL Navigator"), tr("This program is script editor version 0.0.1.\n"));	
}
