#include <qcombobox.h>

#include "table.h"

void Table::signal_connect()
{
	connect((const QObject *)_new, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_new()));
	connect((const QObject *)save, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_save()));
	connect((const QObject *)drop, SIGNAL(clicked()), (const QObject *)this, SLOT(slot_drop()));
	connect((const QObject *)close,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_close()));
	connect((const QObject *)fire,SIGNAL(clicked()),(const QObject *)this,SLOT(slot_fire()));
}

void Table::set_database()
{
	MYSQL_RES *result;
	MYSQL_ROW row;

	database->clear();

	result = mysql_list_dbs(mysql,NULL);

	if(result == NULL)
	{
		debug("mysql_list_dbs failed");
		return;
	}

	while((row = mysql_fetch_row(result)))
	{
		database->insertItem(row[0]);
	}

	mysql_free_result(result);
	
	return;
}


