#include "treelistview.h"

TreeListViewItem::TreeListViewItem(QListView *sise)
	: QListViewItem(sise)
{
}

TreeListViewItem::TreeListViewItem(QListView *sise, QString data1, QString data2)
	: QListViewItem(sise, data1, data2)
{
}

TreeListViewItem::~TreeListViewItem()
{
}

void TreeListViewItem::paintCell(QPainter *sise,const QColorGroup &color,int column,int width,int alignment)
{
	QListViewItem::paintCell(sise,color,column,width,alignment );

	 int x=width - 1;
	 int y=height() - 1;

	 sise->setPen(Qt::black);
	 sise->setPen(QPen(QColor(210,210,210),1));
	 sise->drawLine(0,0,0,height());          // draw vertical line on right
	 sise->drawLine(0,y,x,y);
}


TreeListView::TreeListView(QWidget *w,const char *name) : QListView(w,name)
{
	QPalette si= this->palette();
    si.setColor(QColorGroup::Highlight, QColor(210, 220, 240));
	si.setColor(QColorGroup::HighlightedText, QColor(0, 0, 0));
	si.setColor(QColorGroup::Button, QColor(159, 171, 190));
	si.setColor(QColorGroup::Base, QColor(238, 238, 224));
	setPalette(si);

	setAllColumnsShowFocus(TRUE);
}

TreeListView::~TreeListView()
{
}

/*
void TreeListView::contentsMousePressEvent(QMouseEvent *)
{
	if(sise->button() == RightButton)
	{
		QListViewItem *k=itemAt(sise->pos());

		if(k)
		{
			switch(get_level(k))
			{
				case 0:
				{
					// host	
					break;
				}
				case 1:
				{
					// database
					break;
				}
				case 2:
				{
					// table
					break;
				}
				case 3:
				{
					// field
					break;
				}
			}
		}
	}
}
*/

