/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.sql.SQLException;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlResult;

final class Row {
    byte[] data;
    Object[] bytes;
    String[] sData;
    int[] offsets;
    int[] lengths;
    int maxField;
    boolean fake;
    int columns;
    jdbcMysqlBag bag;
    static final String[] errs = new String[]{"E2100 Error in Row constructor.", "E2101 Error in Row initiation.", "E2102 Error in Row.getBytes().", "E2103 Error in Row.getString()."};

    Row(jdbcMysqlResult jdbcMysqlResult2) throws SQLException {
        try {
            this.columns = jdbcMysqlResult2.metadata.cc;
            this.fake = jdbcMysqlResult2.cacheMode == 3;
            this.offsets = new int[this.columns];
            this.lengths = new int[this.columns];
            this.bytes = new Object[this.columns];
            this.sData = new String[this.columns];
            this.maxField = jdbcMysqlResult2.statement.maxFieldSize;
            if (!this.fake) {
                this.bag = new jdbcMysqlBag(0);
                return;
            }
        }
        catch (Exception exception) {
            this.errhandler(0, exception);
        }
    }

    void init(Object object) throws SQLException {
        try {
            if (this.fake) {
                this.data = null;
                this.bytes = (Object[])object;
                int n = 0;
                while (n < this.columns) {
                    this.offsets[n] = -1;
                    this.sData[n] = null;
                    ++n;
                }
                return;
            }
            this.data = (byte[])object;
            this.bag.inside = this.data;
            this.bag.at = 4;
            this.bag.maxAt = this.data.length;
            int n = 0;
            while (n < this.columns) {
                int n2 = this.bag.xToI();
                this.offsets[n] = this.bag.at;
                int n3 = this.lengths[n] = n2 > this.maxField ? this.maxField : n2;
                if (n2 != -1) {
                    this.bag.at += n2;
                }
                this.bytes[n] = null;
                this.sData[n] = null;
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            this.errhandler(1, exception);
            return;
        }
    }

    byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        try {
            int n2 = this.offsets[n];
            if (n2 == -1) {
                return (byte[])this.bytes[n];
            }
            int n3 = this.lengths[n];
            if (n3 > -1) {
                byArray = new byte[n3];
                System.arraycopy(this.data, n2, byArray, 0, n3);
            }
            this.offsets[n] = -1;
            this.bytes[n] = byArray;
        }
        catch (Exception exception) {
            this.errhandler(2, exception);
        }
        return byArray;
    }

    String getString(int n) throws SQLException {
        String string = null;
        try {
            string = this.sData[n];
            if (string != null) {
                return string;
            }
            int n2 = this.offsets[n];
            if (n2 < 0) {
                if (this.bytes[n] != null) {
                    string = new String((byte[])this.bytes[n]);
                }
            } else {
                int n3 = this.lengths[n];
                if (n3 > -1) {
                    string = new String(this.data, n2, n3);
                }
            }
            this.sData[n] = string;
        }
        catch (Exception exception) {
            this.errhandler(3, exception);
        }
        return string;
    }

    private void errhandler(int n, Exception exception) throws SQLException {
        String string = exception.getMessage();
        if (string == null || string.length() == 0) {
            string = exception.toString();
        }
        string = "\n" + errs[n] + " " + string;
        jdbcMysqlBase.errMessage(string);
    }
}

