/*
 * Decompiled with CFR 0.152.
 */
package twz1.jdbc.mysql;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.Vector;
import twz1.jdbc.mysql.RSMd;
import twz1.jdbc.mysql.Row;
import twz1.jdbc.mysql.jdbcMysqlBag;
import twz1.jdbc.mysql.jdbcMysqlBase;
import twz1.jdbc.mysql.jdbcMysqlField;
import twz1.jdbc.mysql.jdbcMysqlResult;
import twz1.jdbc.mysql.jdbcMysqlStmt;
import twz1.jdbc.mysql.jdbcMysqlURL;

public final class jdbcMysqlRSet
implements ResultSet {
    int myOID = ++jdbcMysqlBase.xoid;
    jdbcMysqlResult result;
    jdbcMysqlStmt statement;
    boolean retrieved;
    jdbcMysqlBag inBag;
    RSMd metadata;
    int currentRow;
    boolean isClosed;
    boolean isDone;
    boolean isStarted;
    boolean noMoreData;
    boolean lastNull;
    boolean rsLock;
    boolean gettable;
    boolean rsDateXcept;
    int columnCount;
    boolean cached;
    int lTimeout;
    int maxRows;
    Row xRow;
    Vector mcache;
    int mcacheSize;
    static final int GETSTRING = 0;
    static final int GETBOOLEAN = 1;
    static final int GETBYTE = 2;
    static final int GETSHORT = 3;
    static final int GETINT = 4;
    static final int GETLONG = 5;
    static final int GETFLOAT = 6;
    static final int GETDOUBLE = 7;
    static final int GETBIGDECIMAL = 8;
    static final int GETBYTES = 9;
    static final int GETDATE = 10;
    static final int GETTIME = 11;
    static final int GETTIMESTAMP = 12;
    static final int GETASCIISTREAM = 13;
    static final int GETBINARYSTREAM = 14;
    static final int GETUNICODESTREAM = 15;
    static final int GETOBJECT = 16;
    static final int FINDCOLUMN = 17;
    static final int GETMETADATA = 18;
    static final int WASNULL = 19;
    static final String[] nameIt = new String[]{"getString", "getBoolean", "getByte", "getShort", "getInt", "getLong", "getFloat", "getDouble", "getBigDecimal", "getBytes", "getDate", "getTime", "getTimestamp", "getAsciiStream", "getBinaryStream", "getUnicodeStream", "getObject", "findColumn", "getMetaData", "wasNull"};
    static final String[] errs = new String[]{"E1400 Result set has been closed.", "E1401 Results exhausted.", "E1402 Error from next()", "E1403 A valid row has not been requested.", "E1404 Error in wasNull()", "E1405 Error recognizing data for API", "E1406 Data is not recognisable as numeric", "E1407 Value exceeds the range for this type.", "P1408 Program error", "E1409 getBigDecimal scaling error.", "E1410 Too many tokens!", "E1411 Error parsing date/time object.", "E1412 Status or synchronization error.", "E1413 Error in status retrieving metadata.", "E1414 Error retrieving column by name.", "E1415 Error in object conversion - ", "E1416 Error in getObject converting MySQL type ", "E1417 Error retrieving data - "};

    jdbcMysqlRSet(jdbcMysqlResult jdbcMysqlResult2) throws SQLException {
        this.result = jdbcMysqlResult2;
        this.statement = this.result.statement;
        this.inBag = this.result.inBag;
        this.metadata = this.result.metadata;
        this.currentRow = -1;
        this.isClosed = false;
        this.isDone = false;
        this.noMoreData = false;
        this.isStarted = false;
        this.retrieved = false;
        this.gettable = false;
        this.rsLock = this.statement.rsLock;
        Object object = this.result;
        if (((jdbcMysqlResult)object).rSets == null) {
            ((jdbcMysqlResult)object).rSets = new Vector();
        }
        ((jdbcMysqlResult)object).rSets.addElement(this);
        this.rsDateXcept = false;
        this.columnCount = this.metadata.cc;
        this.xRow = new Row(this.result);
        this.lTimeout = this.statement.lTimeout;
        this.maxRows = this.statement.maxRows;
        this.cached = this.result.cacheMode == 0 || this.result.cacheMode == 3;
        if (this.cached) {
            this.mcache = this.result.mcache;
            this.mcacheSize = this.mcache.size();
        } else {
            this.mcache = null;
            this.mcacheSize = -1;
        }
        if (this.statement.cx != null) {
            object = this.statement.cx.curl;
            object = (String)((jdbcMysqlURL)object).values.get("rsDateXcept");
            if (jdbcMysqlBase.boolValue((String)object, 0, 0) == 1) {
                this.rsDateXcept = true;
            }
        }
    }

    void iClose() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.result.cacheClose(this.noMoreData);
        this.result.doneRS(this.myOID);
        this.isClosed = true;
        this.gettable = false;
        this.result = null;
        this.statement = null;
        this.mcache = null;
        this.xRow = null;
        this.metadata = null;
        this.inBag = null;
    }

    int myID() {
        return this.myOID;
    }

    public boolean next() throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        try {
            bl = this.statement.lock(true, n, this.lTimeout);
            if (this.isClosed) {
                this.errHandlerM(0, " -- next()");
            }
            if (!this.isDone) {
                this.isStarted = true;
                this.gettable = true;
                ++this.currentRow;
                if (this.currentRow < this.maxRows) {
                    if (this.cached) {
                        if (this.currentRow < this.mcacheSize) {
                            this.xRow.init(this.mcache.elementAt(this.currentRow));
                        } else {
                            this.noMoreData = true;
                        }
                    } else if (!this.result.inEoD(this.inBag)) {
                        this.xRow.init(this.inBag.inside);
                    } else {
                        this.noMoreData = true;
                    }
                }
                if (this.noMoreData || this.currentRow >= this.maxRows) {
                    this.isDone = true;
                    this.gettable = false;
                    this.result.cacheClose(this.noMoreData);
                    this.noMoreData = true;
                }
                if (this.result.dataError) {
                    this.errHandlerNM(17, this.result.lastStatus, this.result.sMessage);
                }
            }
            bl = this.statement.lock(false, n, this.lTimeout);
        }
        catch (Exception exception) {
            this.isDone = true;
            this.gettable = false;
            this.result.cacheClose(this.noMoreData);
            if (bl) {
                this.statement.lock(false, n, this.lTimeout);
            }
            this.errHandlerE(2, exception);
        }
        return !this.isDone;
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        jdbcMysqlStmt jdbcMysqlStmt2 = this.statement;
        int n = ++jdbcMysqlBase.xoid;
        jdbcMysqlStmt2.lock(true, n, this.lTimeout);
        this.iClose();
        jdbcMysqlStmt2.lock(false, n, this.lTimeout);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.nopSynch("getWarnings()");
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.nopSynch("clearWarnings()");
    }

    public String getCursorName() throws SQLException {
        this.nopSynch("getCursorName()");
        this.errHandlerM(11, "");
        return null;
    }

    public boolean wasNull() throws SQLException {
        return (Integer)this.getIt(19, 0, null, 2) == 1;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return (ResultSetMetaData)this.getIt(18, 0, null, 2);
    }

    public int findColumn(String string) throws SQLException {
        Integer n = (Integer)this.getIt(17, 0, string, 2);
        return n;
    }

    public String getString(int n) throws SQLException {
        return (String)this.getIt(0, n, null, 45);
    }

    public String getString(String string) throws SQLException {
        return (String)this.getIt(0, 0, string, 53);
    }

    public boolean getBoolean(int n) throws SQLException {
        Boolean bl = (Boolean)this.getIt(1, n, null, 45);
        return bl.equals(Boolean.TRUE);
    }

    public boolean getBoolean(String string) throws SQLException {
        Boolean bl = (Boolean)this.getIt(1, 0, string, 53);
        return bl.equals(Boolean.TRUE);
    }

    public byte getByte(int n) throws SQLException {
        Byte by = (Byte)this.getIt(2, n, null, 45);
        return by;
    }

    public byte getByte(String string) throws SQLException {
        Byte by = (Byte)this.getIt(2, 0, string, 53);
        return by;
    }

    public short getShort(int n) throws SQLException {
        Short s = (Short)this.getIt(3, n, null, 45);
        return s;
    }

    public short getShort(String string) throws SQLException {
        Short s = (Short)this.getIt(3, 0, string, 53);
        return s;
    }

    public int getInt(int n) throws SQLException {
        Integer n2 = (Integer)this.getIt(4, n, null, 45);
        return n2;
    }

    public int getInt(String string) throws SQLException {
        Integer n = (Integer)this.getIt(4, 0, string, 53);
        return n;
    }

    public long getLong(int n) throws SQLException {
        Long l = (Long)this.getIt(5, n, null, 45);
        return l;
    }

    public long getLong(String string) throws SQLException {
        Long l = (Long)this.getIt(5, 0, string, 53);
        return l;
    }

    public float getFloat(int n) throws SQLException {
        Float f = (Float)this.getIt(6, n, null, 45);
        return f.floatValue();
    }

    public float getFloat(String string) throws SQLException {
        Float f = (Float)this.getIt(6, 0, string, 53);
        return f.floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Double d = (Double)this.getIt(7, n, null, 45);
        return d;
    }

    public double getDouble(String string) throws SQLException {
        Double d = (Double)this.getIt(7, 0, string, 53);
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getIt(8, n, null, 45);
        try {
            bigDecimal = bigDecimal.setScale(n2);
        }
        catch (Exception exception) {
            this.errHandlerE(9, exception);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getIt(8, 0, string, 53);
        try {
            bigDecimal = bigDecimal.setScale(n);
        }
        catch (Exception exception) {
            this.errHandlerE(9, exception);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        return (byte[])this.getIt(9, n, null, 77);
    }

    public byte[] getBytes(String string) throws SQLException {
        return (byte[])this.getIt(9, 0, string, 85);
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getIt(10, n, null, 45);
    }

    public Date getDate(String string) throws SQLException {
        return (Date)this.getIt(10, 0, string, 53);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getIt(11, n, null, 45);
    }

    public Time getTime(String string) throws SQLException {
        return (Time)this.getIt(11, 0, string, 53);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getIt(12, n, null, 45);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return (Timestamp)this.getIt(12, 0, string, 53);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return (InputStream)this.getIt(13, n, null, 77);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return (InputStream)this.getIt(13, 0, string, 85);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return (InputStream)this.getIt(14, n, null, 77);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return (InputStream)this.getIt(14, 0, string, 85);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return (InputStream)this.getIt(15, n, null, 45);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return (InputStream)this.getIt(15, 0, string, 53);
    }

    public Object getObject(int n) throws SQLException {
        return this.getIt(16, n, null, 45);
    }

    public Object getObject(String string) throws SQLException {
        return this.getIt(16, 0, string, 53);
    }

    private Object getIt(int n, int n2, String string, int n3) throws SQLException {
        int n4 = n3;
        int n5 = 0;
        boolean bl = false;
        Object object = null;
        byte[] byArray = null;
        String string2 = null;
        String string3 = "(not-determined yet)";
        int n6 = n;
        jdbcMysqlField jdbcMysqlField2 = null;
        int n7 = -1;
        try {
            if (this.rsLock) {
                n5 = ++jdbcMysqlBase.xoid;
                bl = this.statement.lock(true, n5, this.lTimeout);
            }
            if ((n4 & 1) > 0 && !this.gettable) {
                this.testStatus(nameIt[n6]);
            }
            if ((n4 & 2) > 0 && this.isClosed) {
                this.testStatus(nameIt[n6]);
            }
            if ((n4 & 4) > 0) {
                this.lastNull = false;
            }
            if ((n4 & 8) > 0 && string == null) {
                n7 = n2 - 1;
            }
            if ((n4 & 0x10) > 0) {
                jdbcMysqlField2 = this.fByName(string);
                n7 = jdbcMysqlField2.columnNumber;
            }
            if (n6 == 16) {
                if (jdbcMysqlField2 == null) {
                    jdbcMysqlField2 = this.metadata.getField(n7 + 1);
                }
                switch (jdbcMysqlField2.ctype) {
                    case 1: {
                        n6 = 2;
                        break;
                    }
                    case 2: {
                        n6 = 3;
                        break;
                    }
                    case 3: {
                        n6 = 4;
                        break;
                    }
                    case 4: {
                        n6 = 6;
                        break;
                    }
                    case 0: {
                        n6 = 8;
                        break;
                    }
                    case 5: {
                        n6 = 7;
                        break;
                    }
                    case 7: {
                        n6 = 12;
                        break;
                    }
                    case 8: 
                    case 9: {
                        n6 = 5;
                        break;
                    }
                    case 10: {
                        n6 = 10;
                        break;
                    }
                    case 11: {
                        n6 = 11;
                        break;
                    }
                    case 12: {
                        n6 = 12;
                        break;
                    }
                    case 247: 
                    case 248: {
                        n6 = 0;
                        break;
                    }
                    case 249: 
                    case 250: 
                    case 251: 
                    case 252: 
                    case 253: 
                    case 254: {
                        if ((jdbcMysqlField2.cflags & 0x80) > 0) {
                            n6 = 9;
                            n4 += 32;
                            break;
                        }
                        n6 = 0;
                        break;
                    }
                    default: {
                        this.errHandlerM(16, String.valueOf(n6));
                    }
                }
            }
            if ((n4 & 0x20) > 0) {
                string2 = this.xRow.getString(n7);
            }
            if ((n4 & 0x40) > 0) {
                byArray = this.xRow.getBytes(n7);
            }
            switch (n6) {
                case 13: 
                case 14: {
                    if (byArray == null) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    object = new ByteArrayInputStream(byArray);
                    break;
                }
                case 9: {
                    if (byArray == null) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    int n8 = byArray.length;
                    byte[] byArray2 = new byte[n8];
                    System.arraycopy(byArray, 0, byArray2, 0, n8);
                    object = byArray2;
                    break;
                }
                case 18: {
                    object = this.metadata;
                    break;
                }
                case 17: {
                    object = new Integer(n7 + 1);
                    break;
                }
                case 0: {
                    if (string2 == null) {
                        this.lastNull = true;
                        break;
                    }
                    object = string2;
                    break;
                }
                case 1: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "false";
                    }
                    object = new Boolean(this.testBool(string2));
                    break;
                }
                case 2: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new Byte(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 3: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new Short(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 4: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new Integer(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 5: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new Long(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 6: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new Float(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 7: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new Double(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 8: {
                    if (string2 == null) {
                        this.lastNull = true;
                        string2 = "0";
                    }
                    try {
                        object = new BigDecimal(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.errHandlerM(6, "");
                    }
                    break;
                }
                case 10: {
                    if (string2 == null) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    int[] nArray = this.nParse(string2, 3);
                    if (!this.rsDateXcept && nArray[0] < 1900) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    try {
                        object = new Date(nArray[0] - 1900, nArray[1] - 1, nArray[2]);
                    }
                    catch (Exception exception) {
                        this.errHandlerE2b(15, n6, string2, exception);
                    }
                    break;
                }
                case 11: {
                    if (string2 == null) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    try {
                        int[] nArray = this.nParse(string2, 3);
                        object = new Time(nArray[0], nArray[1], nArray[2]);
                    }
                    catch (Exception exception) {
                        this.errHandlerE2b(15, n6, string2, exception);
                    }
                    break;
                }
                case 12: {
                    if (string2 == null) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    try {
                        int n9;
                        int n10;
                        int n11;
                        int n12;
                        int n13;
                        int n14;
                        String string4 = string2;
                        if (string2.indexOf("-") < 0) {
                            int n15;
                            if (string4.length() < 14) {
                                string4 = new String("19" + string4);
                            }
                            if ((n15 = string4.length()) < 14) {
                                n15 = 14 - n15;
                            }
                            String string5 = "19000101000001".substring(n15);
                            string4 = new String(String.valueOf(string4) + string5);
                            n14 = Integer.parseInt(string4.substring(0, 4));
                            n13 = Integer.parseInt(string4.substring(4, 6));
                            n12 = Integer.parseInt(string4.substring(6, 8));
                            n11 = Integer.parseInt(string4.substring(8, 10));
                            n10 = Integer.parseInt(string4.substring(10, 12));
                            n9 = Integer.parseInt(string4.substring(12, 14));
                        } else {
                            int[] nArray = this.nParse(string2, 6);
                            n14 = nArray[0];
                            n13 = nArray[1];
                            n12 = nArray[2];
                            n11 = nArray[3];
                            n10 = nArray[4];
                            n9 = nArray[5];
                            if (n14 < 1900) {
                                n14 += 1900;
                            }
                            if (n13 < 1) {
                                n13 = 1;
                            }
                            if (n12 < 1) {
                                n12 = 1;
                            }
                        }
                        object = new Timestamp(n14 - 1900, n13 - 1, n12, n11, n10, n9, 0);
                    }
                    catch (Exception exception) {
                        this.errHandlerE2b(15, n6, string2, exception);
                    }
                    break;
                }
                case 15: {
                    if (string2 == null) {
                        this.lastNull = true;
                        object = null;
                        break;
                    }
                    byArray = string2.getBytes();
                    object = new ByteArrayInputStream(byArray);
                    break;
                }
                case 19: {
                    object = new Integer(this.lastNull ? 1 : 0);
                    break;
                }
                default: {
                    this.errHandlerM(8, "");
                }
            }
            if (this.rsLock) {
                bl = this.statement.lock(false, n5, this.lTimeout);
            }
        }
        catch (Exception exception) {
            if (bl) {
                this.statement.lock(false, n5, this.lTimeout);
            }
            string3 = string != null ? "(String)" : "(int)";
            this.errHandlerE2(5, n, string3, exception);
        }
        return object;
    }

    private int[] nParse(String string, int n) throws SQLException {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " -:.");
            n2 = 0;
            while (stringTokenizer.hasMoreTokens() && n2 < n) {
                if (n2 >= n) {
                    this.errHandlerM(10, string);
                }
                String string2 = stringTokenizer.nextToken();
                nArray[n2++] = Integer.parseInt(string2);
            }
        }
        catch (Exception exception) {
            this.errHandlerE(11, exception);
        }
        return nArray;
    }

    private boolean testBool(String string) throws SQLException {
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("y") || string.equals("1")) {
            return true;
        }
        if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("f") || string.equalsIgnoreCase("no") || string.equalsIgnoreCase("n") || string.equals("0")) {
            return false;
        }
        this.errHandlerM(5, "");
        return false;
    }

    private void nopSynch(String string) throws SQLException {
        int n = ++jdbcMysqlBase.xoid;
        boolean bl = false;
        try {
            bl = this.statement.lock(true, n, this.statement.lTimeout);
            this.testStatus(string);
            bl = this.statement.lock(false, n, this.statement.lTimeout);
            return;
        }
        catch (Exception exception) {
            if (bl) {
                this.statement.lock(false, n, this.statement.lTimeout);
            }
            this.errHandlerE(12, exception);
            return;
        }
    }

    private jdbcMysqlField fByName(String string) throws SQLException {
        jdbcMysqlField jdbcMysqlField2 = null;
        int n = string.indexOf(46);
        if (n > -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            jdbcMysqlField2 = this.metadata.getField(string2, string3);
        } else {
            jdbcMysqlField2 = this.metadata.getField(string);
        }
        return jdbcMysqlField2;
    }

    void retrieved(boolean bl) {
        this.retrieved = bl;
    }

    boolean isRetrieved() {
        return this.retrieved;
    }

    private void testStatus(String string) throws SQLException {
        if (this.isClosed) {
            this.errHandlerM(0, string);
        }
        if (this.isDone) {
            this.errHandlerM(1, string);
        }
        if (!this.isStarted) {
            this.errHandlerM(3, string);
        }
    }

    private void errHandlerE(int n, Exception exception) throws SQLException {
        String string = jdbcMysqlBase.eMessage(exception);
        this.errHandlerM(n, string);
    }

    private void errHandlerE2(int n, int n2, String string, Exception exception) throws SQLException {
        String string2 = " " + nameIt[n2] + string + jdbcMysqlBase.eMessage(exception);
        this.errHandlerM(n, string2);
    }

    private void errHandlerE2b(int n, int n2, String string, Exception exception) throws SQLException {
        String string2 = " " + nameIt[n2] + " " + string + jdbcMysqlBase.eMessage(exception);
        this.errHandlerM(n, string2);
    }

    private void errHandlerM(int n, String string) throws SQLException {
        String string2 = new String("\n" + errs[n] + " " + string);
        jdbcMysqlBase.errMessage(string2);
    }

    private void errHandlerNM(int n, int n2, String string) throws SQLException {
        String string2 = new String("\n" + errs[n] + n2 + " " + string);
        jdbcMysqlBase.errMessage(string2);
    }
}

