/**
*** Program DMTabCol.java     
***    in product twz1jdbcForMysql, 
***    Copyright 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;
import java.sql.*;
import java.util.Hashtable;
import java.util.StringTokenizer;

final class DMTabCol
{
static Hashtable typemap;
String colName;
byte[] bColName;
int pos;
byte[] bPos;
byte[] bSQLType;
byte[] typeName;
byte[] bLength;
byte[] bDigits;
byte[] bDefault;
byte[] bRemarks;
boolean nullable;
boolean autoinc;

DMTabCol(ResultSet rs, int i) throws SQLException 
    {
    if(typemap == null) buildmap();
    try {
        String s;
        Integer I;
        int t, u, v;
        pos = i;
        bPos = String.valueOf(i).getBytes();
        nullable = false;
        autoinc  = false;
        int digits = 0;
        bColName = rs.getBytes(1);
        colName = new String(bColName);
        s = rs.getString(2); 
        String[] p = tinyparse(s, 3);    
        bSQLType = (byte[]) typemap.get(p[0]);
        s = "." + p[0];
        I = (Integer) typemap.get(s);
        t = I.intValue();
        s = RSMd.sqlTypeNames(t);    
        typeName = s.getBytes();
        t = -1;
        if(p[1] != null)
            {
            try { t =  Integer.parseInt(p[1]); }
            catch(Exception e){}
            }
        if(t == -1) 
            {
            s = "$" + p[0];
            bLength = (byte[]) typemap.get(s);
            }
        else bLength = String.valueOf(t).getBytes();
        t = 0;
        if(p[2] != null)
            {
            try { t = Integer.parseInt(p[2]); }
            catch(Exception e){}
            }
        bDigits = String.valueOf(t).getBytes();    
        s = rs.getString(3);
        if(s != null) if(s.equals("YES")) nullable = true;
        s = rs.getString(5);
        if(s != null) 
            {
            if(nullable && s.equals("NULL")) bDefault = null;
            else bDefault = s.getBytes();
            }
        else bDefault = "".getBytes();
        bRemarks = rs.getBytes(6);
        s = new String(bRemarks);
        if(s.indexOf("auto_increment") > -1)autoinc = true;
        }     
    catch(Exception e)
        {
        String em = e.getMessage();
        if(em == null) em = e.toString();
        String o = "\nE2200 Error in DBMDtableColumn() constructor "
                 + em;
        jdbcMysqlBase.errMessage(o);
        }
    }   

private String[] tinyparse(String w, int max)
    {
    StringTokenizer st = new StringTokenizer(w, "(), ");
    String[] out = new String[max];
    for(int i = 0; i < max; i++) out[i] = null;
    int at = 0;
    String a;
    while(st.hasMoreTokens() && at < max) 
         {
         a = st.nextToken();
         out[at++] = a;
         }
    return out;
    }  

private void buildmap()
    {
    String s;
    int i;
    typemap = new Hashtable();

    i = java.sql.Types.TINYINT;
    typemap.put(".tinyint", new Integer(i));
    typemap.put("tinyint", String.valueOf(i).getBytes());
    s = "1"; typemap.put("$tinyint", s.getBytes());

    i = java.sql.Types.SMALLINT;
    typemap.put(".smallint", new Integer(i));
    typemap.put("smallint", String.valueOf(i).getBytes());
    s = "6"; typemap.put("$smallint", s.getBytes());

    i = java.sql.Types.SMALLINT;
    typemap.put(".mediumint", new Integer(i));
    typemap.put("mediumint", String.valueOf(i).getBytes());
    typemap.put("$mediumint", s.getBytes());

    i = java.sql.Types.INTEGER;
    typemap.put(".int", new Integer(i));
     typemap.put("int", String.valueOf(i).getBytes());
    s = "11"; typemap.put("$int", s.getBytes());

    i = java.sql.Types.INTEGER;
    typemap.put(".integer", new Integer(i));
    typemap.put("integer", String.valueOf(i).getBytes());
    s = "11"; typemap.put("$integer", s.getBytes());

    i = java.sql.Types.BIGINT;
    typemap.put(".bigint", new Integer(i));
    typemap.put("bigint", String.valueOf(i).getBytes());
    s = "25"; typemap.put("$bigint", s.getBytes());

    i = java.sql.Types.BIGINT;
    typemap.put(".int24", new Integer(i));
    typemap.put("int24", String.valueOf(i).getBytes());
    s = "25"; typemap.put("$int24", s.getBytes());

    i = java.sql.Types.REAL;
    typemap.put(".real", new Integer(i));
    typemap.put("real", String.valueOf(i).getBytes());
    s = "12"; typemap.put("$real", s.getBytes());

    i = java.sql.Types.FLOAT;
    typemap.put(".float", new Integer(i));
    typemap.put("float", String.valueOf(i).getBytes());
    s = "12"; typemap.put("$float", s.getBytes());

    i = java.sql.Types.DECIMAL;
    typemap.put(".decimal", new Integer(i));
    typemap.put("decimal", String.valueOf(i).getBytes());
    s = "12"; typemap.put("$decimal", s.getBytes());

    i = java.sql.Types.NUMERIC;
    typemap.put(".numeric", new Integer(i));
    typemap.put("numeric", String.valueOf(i).getBytes());
    s = "12"; typemap.put("$numeric", s.getBytes());

    i = java.sql.Types.DOUBLE;
    typemap.put(".double", new Integer(i));
    typemap.put("double", String.valueOf(i).getBytes());
    s = "22"; typemap.put("$double", s.getBytes());

    i = java.sql.Types.CHAR;
    typemap.put(".char", new Integer(i));
    typemap.put("char", String.valueOf(i).getBytes());
    s = "1"; typemap.put("$char", s.getBytes());

    i = java.sql.Types.VARCHAR;
    typemap.put(".varchar", new Integer(i));
    typemap.put("varchar", String.valueOf(i).getBytes());
    s = "255"; typemap.put("$varchar", s.getBytes());

    i = java.sql.Types.DATE;
    typemap.put(".date", new Integer(i));
    typemap.put("date", String.valueOf(i).getBytes());
    s = "10"; typemap.put("$date", s.getBytes());

    i = java.sql.Types.TIME;
    typemap.put(".time", new Integer(i));
    typemap.put("time", String.valueOf(i).getBytes());
    s = "8";  typemap.put("$time", s.getBytes());

    i = java.sql.Types.TIMESTAMP;
    typemap.put(".timestamp", new Integer(i));
    typemap.put("timestamp", String.valueOf(i).getBytes());
    s = "19";  typemap.put("$timestamp", s.getBytes());

    i = java.sql.Types.TIMESTAMP;
    typemap.put(".datetime", new Integer(i));
    typemap.put("datetime", String.valueOf(i).getBytes());
    s = "19";  typemap.put("$datetime", s.getBytes());

    i = java.sql.Types.VARBINARY;
    typemap.put(".tinyblob", new Integer(i));
    typemap.put("tinyblob", String.valueOf(i).getBytes());
    s = "255";  typemap.put("$tinyblob", s.getBytes());

    i = java.sql.Types.LONGVARBINARY;
    typemap.put(".blob", new Integer(i));
    typemap.put("blob", String.valueOf(i).getBytes());
    s = "65535";  typemap.put("$blob", s.getBytes());

    i = java.sql.Types.LONGVARBINARY;
    typemap.put(".mediumblob", new Integer(i));
    typemap.put("mediumblob", String.valueOf(i).getBytes());
    s = "16277215";  typemap.put("$mediumblob", s.getBytes());

    i = java.sql.Types.LONGVARBINARY;
    typemap.put(".longblob", new Integer(i));
    typemap.put("longblob", String.valueOf(i).getBytes());
    s = "2147483657";  typemap.put("$longblob", s.getBytes());

    i = java.sql.Types.VARCHAR;
    typemap.put(".tinytext", new Integer(i));
    typemap.put("tinytext", String.valueOf(i).getBytes());
    s = "255";  typemap.put("$tinytext", s.getBytes());

    i = java.sql.Types.LONGVARCHAR;
    typemap.put(".text", new Integer(i));
    typemap.put("text", String.valueOf(i).getBytes());
    s = "65535";  typemap.put("$text", s.getBytes());

    i = java.sql.Types.LONGVARCHAR;
    typemap.put(".mediumtext", new Integer(i));
    typemap.put("mediumtext", String.valueOf(i).getBytes());
    s = "16277215";  typemap.put("$mediumtext", s.getBytes());

    i = java.sql.Types.VARCHAR;
    typemap.put(".enum", new Integer(i));
    typemap.put("enum", String.valueOf(i).getBytes());
    s = "255";  typemap.put("$enum", s.getBytes());

    i = java.sql.Types.VARCHAR;
    typemap.put(".set", new Integer(i));
    typemap.put("set", String.valueOf(i).getBytes());
    s = "255";  typemap.put("$set", s.getBytes());
    }

}


