/**
*** Program jdbcMysqltable.java     
***    in product twz1jdbcForMysql, 
***    Copyright 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;
import java.sql.*;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class DMTable
{
String database;
String tableName;
byte[] bTableName;
Hashtable table;
DMTabCol[] columns;
Vector keys;

DMTable(Statement st, String db, String tname)
        throws SQLException
    {
    database = db;
    tableName = tname;
    bTableName = tableName.getBytes();
    table = new Hashtable();
    columns = null;
    DMTabCol col;
    keys = null;
    int cno = 0;
    try {
        String q = "show fields from " + tableName 
                 + " from " + database;
        ResultSet rs = st.executeQuery(q);
        while(rs.next())
            {
            cno++;
            col = new DMTabCol(rs, cno);
            table.put(col.colName, col);
            }
        rs.close();
        columns = new DMTabCol[cno];
        Enumeration en = table.elements();
        while(en.hasMoreElements())
            {
            col = (DMTabCol) en.nextElement();
            columns[col.pos-1] = col;
            }
        }        
    catch(Exception e)
        {
        String em = e.getMessage();
        if(em == null) em = e.toString();
        String o = "\nE2300 Error in DBMDtable() constructor " + em;
        jdbcMysqlBase.errMessage(o);
        }
    }

DMTabCol[] subColumns(Statement st, String qual)
        throws SQLException 
    {
    if(qual == null || qual.equals("")) return columns;

    DMTabCol[] out = 
        new DMTabCol[columns.length];
    DMTabCol col;
    DMTabCol[] x = null; 
    int o = -1;
    String s;
    try {
        String q = "show fields from " + tableName 
                 + " from " + database +  qual;
        ResultSet rs = st.executeQuery(q);
        while(rs.next())
            {
            o++;
            s = rs.getString(1);
            out[o] = (DMTabCol) table.get(s);
            }
        rs.close();
        o++;
        if(o > 0)
            {
            x = new DMTabCol[o];
            System.arraycopy(out, 0, x, 0, o);
            out = null;
            }
        }
    catch(Exception e)
        {
        String oe = "\nE2301 Error in DBMDtable.subTable()"
                 + e.getMessage();
        jdbcMysqlBase.errMessage(oe);
        }
    return x;
    }

int getKeys(Statement st) throws SQLException
    {
    int retnum = -1;
    try {
        keys = new Vector();
        DMKey key = null;
        DMKTine kt = null;
        String pkn = "";
        String kn;
        String q = "show keys from " + tableName + " from " + database;
        ResultSet rs = st.executeQuery(q);
        while(rs.next())
            {
            kn = rs.getString(3);
            if(!kn.equals(pkn))
                {
                if(kn.equals("PRIMARY")) retnum = keys.size();
                key = new DMKey(rs);
                keys.addElement(key);
                pkn = kn;
                }
            kt = new DMKTine(rs, this);
            key.tines.addElement(kt);
            if(kt.column.autoinc)key.autoinc = true;
            }
        }
    catch(Exception e)
        {
        String em = e.getMessage();
        if(em == null) em = "\n    " + e.toString();
        String oe = "\nE2301 Error in DBMDtable.getKeys()" + em;
        jdbcMysqlBase.errMessage(oe);
        }
    return retnum;
    }
}
