/**
*** Program jdbcMysqlConnex.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

package twz1.jdbc.mysql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.Math;
import java.net.*;
import java.sql.*;
import java.util.Vector; 

public final class jdbcMysqlConnex implements Connection
{
/** The url properties. */
jdbcMysqlURL curl;

/** Am I open?? */
boolean open;

/** The host */
String host;

/** The port. */
int port;

/** The "database" or catalog */
String catalog;

/** The user */
String user;

/** The password */
String password;

/** Our socket for connection. */
Socket socket;

/** The socket input stream */
BufferedInputStream socketInput;

/** The socket output stream; */
BufferedOutputStream socketOutput;

/** Do I allow multiple queries? */
boolean multipleQueries;

/** Input buffer for the socket */
jdbcMysqlBag inBag;

/** Output buffer. */
jdbcMysqlBag outBag;

/** The client protocol number */
int clientProtocol;

/** Can we send long passwords */
int clientCapabilities;

/** The server version name. */
String serverVersion;

/** The client threadid. */
int serverThreadID;

/** The password hash seed. */
String hashSeed;

/** My thread prophylactic */
jdbcMysqlMutex guard;

/** My object id */
int myOID;

/** Extra connection options */
int xOptions;

/** Socket parms */
int sockTCP_NODELAY;
int sockSO_LINGER;
int sockTimeout;

/** Connection wait timeout */
int connexTimeout;

/** Derived DatabaseMetaData connections */
Vector dbmdConnections;

/** boolean broken */
boolean broken;

String xversion;


final static String[] errs = {
   "E2000 Connection option choices are marked invalid.",
   "E2001 Property is invalid -",
   "E2002 Socket error",
   "P2003 ",
   "E2004 Error setting SO_LINGER",
   "E2005 Error setting socket timeout",
   "P2006",
   "P2007",
   "E2008 Error receiving initial from server.",
   "E2009 Error writing initial reply to server.",
   "E2010 Error receiving connect response.",
   "E2011 Access error ",
   "E2012 Unexpected result from connect: ",
   "E2013 Connection not open. ",
   "E2014 Error setCatalog() to ",
   "E2015 Error from setCatalog() for ",
   "E2016 Invalid result code from setCatalog() : ",
   "E2017 Error on initial set of database.",
   "P2018 Error setting catalog",
   "E2019 Connection lock() timeout",
   "E2020 Connection lock() unexpected return.",
   "E2021 Connection is in query with multiple turned off.",
   "S2022 PROG! attempt to decrement inQuery already at zero.",
   "E2023 Error in getCatalog()",
   "E2024 Invoking properties are invalid. ",
   "E2025 Reflected error ",
   "E2026 Feature not supported.",
   "E2027 Error retrieving DBMD.",
   "E2028 Error in connection packet",
   "E2029 Invalid protocol specification.",
                 };

/*===================================================================+
||                    Connection construction                       ||
+===================================================================*/

/** The connection constructor.
*** @param jurl a URL/hashtable/properties list.
**/
jdbcMysqlConnex(jdbcMysqlURL jurl) throws SQLException
    {
    String test      = null;
    String etype     = "";
    int testint      = 0;
    int testint2     = 0;
    boolean testbool = false;

    this.curl = jurl;
    this.open = false;   // Not yet.
    this.multipleQueries = true;
    this.socket = null;
    this.socketInput = null;
    this.socketOutput = null;
    this.clientProtocol = -1;
    this.serverVersion = null;
    this.serverThreadID = 0;
    this.hashSeed = null;
    this.user = null;
    this.password = null;
    this.clientCapabilities = 0;
    this.guard = new jdbcMysqlMutex();
    this.myOID = jdbcMysqlBase.getOID();
    this.sockTCP_NODELAY = -1;
    this.sockSO_LINGER = -1;
    this.sockTimeout = -1;
    this.dbmdConnections = new Vector();
    this.xOptions = 0;
    this.broken  = false;
    this.xversion = null;

    /*---------------------------------------------------------------+
    |                     test connection properties                 |
    +---------------------------------------------------------------*/

    if(!curl.isValid()) errHandlerPS(24, "");

    this.inBag = new jdbcMysqlBag();
    this.outBag = new jdbcMysqlBag();
    inBag.connex = this;
    outBag.connex = this;
      
    test = curl.getProperty("multipleQuery");
    testint = jdbcMysqlBase.boolValue(test, 1, -1);
    if(testint == -1) errHandlerPS(1, "multipleQuery");
    this.multipleQueries = testint == 1;
     
    this.host = curl.getProperty("host");

    this.catalog = curl.getProperty("db"); 

    test = curl.getProperty("port");    
    this.port = jdbcMysqlBase.intValue(test, 3306, 0);
    if(this.port == 0) errHandlerPS(1, "port");   

    user = curl.getProperty("user");
    password = curl.getProperty("password"); 

    test = curl.getProperty("TCP_NODELAY");
    sockTCP_NODELAY = jdbcMysqlBase.boolValue(test, -1, -2);
    if(sockTCP_NODELAY == -2) errHandlerPS(1, "TCP_NODELAY");

    test = curl.getProperty("SO_LINGER");
    sockSO_LINGER = jdbcMysqlBase.intValue(test, -1, -2);
    if(sockSO_LINGER == -2) errHandlerPS(1, "SO_LINGER");

    test = curl.getProperty("socketTimeout");
    sockTimeout = jdbcMysqlBase.intValue(test, -1, -2);
    if(sockTimeout < -1) errHandlerPS(1, "socketTimeout");

    test = curl.getProperty("connectionTimeout");
    connexTimeout = jdbcMysqlBase.intValue(test, 120, -2);
    if(connexTimeout < 0) errHandlerPS(1, "connectionTimeout");

    test = curl.getProperty("debugRead");
    testint = jdbcMysqlBase.boolValue(test, 0, -1);
    if(testint < 0) errHandlerPS(1, "debugRead");
    inBag.setReadDump(testint == 1);
        
    test = curl.getProperty("debugWrite");
    testint = jdbcMysqlBase.boolValue(test, 0, -1);
    if(testint < 0) errHandlerPS(1, "debugWrite");
    outBag.setWriteDump(testint == 1);
   
    xOpen();
    }


void xOpen() throws SQLException
    {
    String test = null, etype = null;
    int testint = 0, testint2 = 0;
    if(socket != null)
        {
	try { inBag.bis.close(); } catch(Exception e) {}
        try { outBag.bos.close(); } catch(Exception e) {}
        try { socket.close(); } catch(Exception e) {}
        socket = null;
        inBag.bis = null;
        outBag.bos = null;
        }
 
    /*---------------------------------------------------------------+
    |                    create the socket                           |
    +---------------------------------------------------------------*/
    try { 
        etype = "creation";
        socket = new Socket(host, port); 
        boolean testbool = false;

        etype = "TCP_NODELAY";
        if(sockTCP_NODELAY == 1) socket.setTcpNoDelay(true);
        if(sockTCP_NODELAY == 0) socket.setTcpNoDelay(false);

        etype = "SO_LINGER";
        if(sockSO_LINGER > -1)
            {
            if(sockSO_LINGER == 0) testbool = false;
            else testbool = true; 
            socket.setSoLinger(testbool, sockSO_LINGER);
            }
 
        etype = "timeout";
        if(sockTimeout > -1) socket.setSoTimeout(sockTimeout * 1000);

        etype = "Set input buffer"; 
        this.socketInput = 
              new BufferedInputStream(socket.getInputStream());

        etype = "Set output buffer";
        this.socketOutput =
               new BufferedOutputStream(socket.getOutputStream());
        }
    catch(IOException e) { errHandlerM(2, etype,  e); }

    inBag.setInput(socketInput);
    outBag.setOutput(socketOutput);

    try {
        inBag.read();
        clientProtocol = inBag.bToI(1);
        if(clientProtocol == 255)
            {
            String s = new String(inBag.bToI(2) + " " 
                                 + inBag.getRstring() );
            errHandlerPS(28, s);
            }           
        if(clientProtocol < 9 || clientProtocol > 10)
            { errHandlerPS(29, String.valueOf(clientProtocol) ); }
        serverVersion  = inBag.getZTstring();
      
        /** Monty changed the protocol in mid stream.  Don't do that! */
        xsv();
        if(xversion.compareTo("032205") < 0) 
	    {
            inBag.teeny = true;
            outBag.teeny = true;
            }

        serverThreadID = inBag.bToI(4);
        hashSeed       = inBag.getZTstring();
        if(inBag.maxAt > inBag.at) xOptions = inBag.bToI(2);
        if(clientProtocol == 10) clientCapabilities = 1;
        }
    catch(Exception e) { errHandlerM(8, "", e); }

    try {
        outBag.newWrite(inBag.getSequence() + 1);
        outBag.iToB(clientCapabilities, 2);
        outBag.iToB(65536, 3);
        outBag.putZT(user);
        outBag.putZT(scramble()); 
        outBag.write();
        }
    catch(Exception e) { errHandlerM(9, "", e); }

    try { 
        inBag.read();
        testint  = inBag.bToI(1);
        testint2 = inBag.bToI(2);
        if(testint == 255) test = inBag.getZTstring();
        }
    catch(Exception e) { errHandlerM(10, "",  e); }       

    if(testint == 255) 
        { closeMe(); errHandlerPS(11, testint2 + " " + test); }
    if(testint != 0)   
        { closeMe(); errHandlerPS(12, String.valueOf(testint)); }

    open = true;
    broken = false;    

    iSetCat(catalog);
    }

void xsv()
    {
    StringBuffer vb[] = new StringBuffer[3];
    vb[0] = new StringBuffer();
    vb[1] = new StringBuffer();
    vb[2] = new StringBuffer();
    String s[] = new String[3];
    int c, a, i;
    a = 0;
    int svt = serverVersion.length();
    for(i = 0; i < svt; i++)
        {
	c = serverVersion.charAt(i);
	if(c >= '0' && c <= '9') vb[a].append((char)c);
	if(c == '.')
            {
            if(vb[a].length() < 2)vb[a].insert(0, '0');
            s[a] = new String(vb[a]);
            a++;
	    }
	}
    if(vb[a].length() < 2)vb[a].insert(0, '0');
    s[a] = new String(vb[a]);
    xversion = new String(s[0]+s[1]+s[2]);
    }

/*===================================================================+
||                    simple sets and gets                          ||
+===================================================================*/

/** Set a read dump */
void setReadDump(boolean t) throws SQLException 
    { testOpen("setReadDump()"); inBag.setReadDump(t); }

/** Set a write dump */
void setWriteDump(boolean t) throws SQLException 
    { testOpen("setWriteDump()"); outBag.setWriteDump(t); }

/** Set multiple queries */
void setMultipleQuery(boolean t) throws SQLException 
    { testOpen("setMultipleQueries()"); multipleQueries = t; }

/** is multiple query ? */
boolean isMultipleQuery() throws SQLException
    { testOpen("isMultipleQuery"); return multipleQueries; }

/** Get input bag */
jdbcMysqlBag getInBag() throws SQLException
    { testOpen("getInBag()"); return inBag; }

jdbcMysqlBag getOutBag() throws SQLException
    { testOpen("getOutBag()"); return outBag; }

private void testOpen(String s) throws SQLException
    { if(!open) errHandlerL(13, s); }

String getProperty(String name) { return curl.getProperty(name); }

void setProperty(String n, String v) { curl.setProperty(n, v); }

void addDBMDconnex(jdbcMysqlConnex dbcx) 
    { dbmdConnections.addElement(dbcx); }

/*-------------------------------------------------------------------+
|                   Safe threading.                                  |
+-------------------------------------------------------------------*/

/** Invoke a mutex to protect access to the connex after first 
*** checking whether multiple connections are allowed and throwing
*** a fit if not and already connected.
*** @param lockOnOff set or clear the mutex.
*** @param oid Object setting the lock.
*** @param timeout time (seconds) to wait before tossing cookies.
**/
boolean lock(boolean lockOnOff, int oid, int timeout)
         throws SQLException
     {
     int rc;
     int t = timeout;
     if(!multipleQueries) t = -1;
     rc = guard.synch(oid, lockOnOff, t);
     if(lockOnOff)
         {
         if(rc == guard.R_LOCKED) return true; 
         if(rc == guard.R_TIMEOUT) 
             {
             if(!multipleQueries) errHandlerL(21, "");
             errHandlerL(19, String.valueOf(oid)); 
             }
         }
     else
         {
         if(rc == guard.R_UNLOCKED) return false;
         }
     errHandlerL(20, String.valueOf(rc) + " " + String.valueOf(oid));  
     return false;        
     }


/*-------------------------------------------------------------------+
|                           closeMe                                  |
+-------------------------------------------------------------------*/

/** The close function to attempt to shutdown gracefully. */
void closeMe()
    {
    open = false;

    int i = 0, j = 0;
    String s = null;
    try { 
        lock(true, myOID, connexTimeout);
        outBag.newWrite(0);
        outBag.iToB(jdbcMysqlBase.COM_QUIT, 1);
        outBag.putZT("QUIT");
        outBag.write();
        inBag.read(); 

        j = dbmdConnections.size();
        Connection dcx;
        for(i = 0; i < j; i++)
            {
            dcx = (Connection) dbmdConnections.elementAt(i);
            try { dcx.close(); }
            catch(SQLException se)
                { /* will catch in warnings later. */ }
            }
 
        lock(false, myOID, 0);
        }
    catch(Exception e) {}
    outBag.connex = null;
    inBag.connex = null;

    if(socketInput != null) { try { socketInput.close(); }
                              catch(Exception e) {}      }

    if(socketOutput != null) { try { socketOutput.close(); }
                               catch(Exception e) {}       }

    if(socket != null) { try { socket.close(); }
                         catch(Exception e) {} }	
    }


/*===================================================================+
||                           API methods                            ||
+===================================================================*/


/** Close the connection. 
**/
public void close() throws SQLException 
    {  testOpen("close()"); closeMe(); }


/** API: return connection status. 
**/
public boolean isClosed() throws SQLException { return !open;}


/** Set the catalog, i.e "database" in MySQL talk. 
**/
public void setCatalog(String c) throws SQLException 
    {
    int i = 0, j = 0;
    String s = null;
    boolean lockset = false;
    try {
        lockset = lock(true, myOID, connexTimeout);
        testOpen("setCatalog()");  
        iSetCat(c);
        lockset = lock(false, myOID, 0);
        }
    catch(Exception e) 
       {
       if(lockset) lock(false, myOID, 0); 
       errHandlerL(18, e.getMessage()); 
       }
   
    catalog = c;
    }

private void iSetCat(String c) throws SQLException
    {
    int i = 0, j = 0;
    String s = null;
    outBag.newWrite(0);
    outBag.iToB(jdbcMysqlBase.COM_INIT_DB, 1);
    outBag.putZT(c); 
    outBag.write();
    inBag.read();  
    i  = inBag.bToI(1);
    j  = inBag.bToI(2);
    if(i == 255) 
       {
       s = inBag.getZTstring();
       errHandlerL(15, c + " " + j + " " + s); 
       }
    if(i != 0) { errHandlerL(16, String.valueOf(i)); }
    }

/** Create a statement to talk to the database.
**/
public Statement createStatement() throws SQLException 
    {
    testOpen("createStatement()");
    return new jdbcMysqlStmt(this);
    }


/** Get the current catalog, aka "database" in MySQL.
**/
public String getCatalog() throws SQLException 
    { testOpen("getCatalog()"); return catalog; }


/** Currently we return null, later I shall implement warnings to
*** pass back the error stack. 
**/
public void clearWarnings() throws SQLException 
    { testOpen("clearWarnings()"); return; }


/** Currently we return null, later I shall implement warnings to
*** pass back the error stack. 
**/
public SQLWarning getWarnings() throws SQLException 
    { testOpen("getWarnings()"); return null;}


/** Transactions are not supported in MySQL.
**/
public int  getTransactionIsolation() throws SQLException 
    {return TRANSACTION_NONE;}


/** Transactions are not supported in MySQL.
**/
public void setTransactionIsolation(int l) throws SQLException 
    { 
    if(l != TRANSACTION_NONE) 
             errHandlerL(26, "setTransactionIsolation()");
    }


/** Transactions are not supported in MySQL.
**/
public void rollback() throws SQLException 
    { errHandlerL(26, "rollback()"); }


/** Transactions are not supported in MySQL.<br>
*** Oops, in dbmd docs say commit should be a noop.
**/
public void commit() throws SQLException 
    { return; /* errHandlerL(26, "commit()"); */ }


/** Transactions are not supported in MySQL.
**/
public boolean getAutoCommit() throws SQLException 
    {  return true; }


/** Transactions are not supported in MySQL.
**/
public void setAutoCommit(boolean s) throws SQLException 
    { if(s == false)errHandlerL(26, "setAutoCommit()"); }

/** Read only connections are not supported by MySQL.  If there is
*** a call for it I may implement support through this driver in the
*** future.
**/
public void setReadOnly(boolean s) throws SQLException 
    { errHandlerL(26, "setReadOnly()"); }


/** Read only connections are not supported by MySQL.  If there is
*** a call for it I may implement support through this driver in the
*** future.
*** @return always false.
**/
public boolean isReadOnly() throws SQLException 
    { testOpen("isReadOnly()"); return false;}


/** DatabaseMetaData is not yet supported, but probably will be
*** fairly soon, though most of its methods will be exceptional.
**/
public DatabaseMetaData getMetaData() throws SQLException 
    {
    DatabaseMetaData dbmd = null;
    try{ dbmd = new DbMd(this);}
    catch(Exception e) { errHandlerE(27, e);}
    return dbmd;
    }


/** As we don't do any translation on the query this just bounces
*** back the parameter.
**/
public String nativeSQL(String s) throws SQLException 
    { testOpen("nativeSQL()"); return s; }


/** MySQL doesn't do callables.
**/
public CallableStatement prepareCall(String s) throws SQLException 
    { errHandlerL(26, "prepareCall()");  return null;}


/** Initiate prepared statement. 
**/
public PreparedStatement prepareStatement(String s) throws SQLException
    {
    testOpen("prepareStatement()");
    return new jdbcMysqlPStmt(this, s);
    }



/*===================================================================+
||                  Error handlers and debuggery                    ||
+===================================================================*/

private void errHandlerL(int n, String s) throws SQLException
    {
    String o = "\n" + errs[n] + " " + s;
    jdbcMysqlBase.errMessage(o);
    }

private void errHandlerPS(int n, String s) throws SQLException
    {
    curl.debugProperty("Properties ...");
    errHandlerL(n, s);
    }

private void errHandlerM(int n, String s, Exception e)
         throws SQLException
    {
    closeMe();
    String o = "\n" + errs[n] + " " + s + jdbcMysqlBase.eMessage(e); 
    jdbcMysqlBase.errMessage(o);
    }

private void errHandlerE(int n, Exception e) throws SQLException
    {
    String o = "\n" + errs[n] + jdbcMysqlBase.eMessage(e); 
    jdbcMysqlBase.errMessage(o);
    }



/*===================================================================+
||                     Monty's password functions                   ||
+===================================================================*/

/** Hash password, stolen almost verbatim from monty's code. */
private long[] hashPassword(String pass)
    {
    long result[] = new long[2];
    long nr  =1345345333;
    long add =7; 
    long nr2 =0x12345671;
    long tmp;
    int pwlen = pass.length();
    char c;
    for (int i = 0; i < pwlen; i++)
        {
        c = pass.charAt(i);
        if(c == ' ' || c == '\t') continue;
        tmp = c;
        nr^= (((nr & 63)+add)*tmp)+ (nr << 8);
        nr2+=(nr2 << 8) ^ nr;
        add+=tmp;
        }
    result[0]= nr  & 0x7fffffff;
    result[1]= nr2 & 0x7fffffff;
    return result;
    }

/** More of Monty's scrambled eggs encryption. */

private byte[] scramble()
    {
    if(password == null) return new byte[0];
    if(password.length() == 0) return new byte[0];
    int hsl = hashSeed.length();
    byte[] out = new byte[hsl];

    long hashPass[] = hashPassword(password);
    long hashMess[] = hashPassword(hashSeed);
    long maxValue, seed, seed2;
    double dRes, dSeed, dMax;

    if(clientCapabilities < 1)
        {
        maxValue= 0x01FFFFFF;
        seed = ( hashPass[0] ^ hashMess[0] ) % maxValue;
        seed2 = seed/2;
        }
    else
        {
        maxValue= 0x3FFFFFFF;
        seed  = ( hashPass[0] ^ hashMess[0] ) % maxValue ;
        seed2 = ( hashPass[1] ^ hashMess[1] ) % maxValue ;
        }

        // Damfino why we're using fp here.
        dMax = maxValue;

    for(int i = 0; i < hsl; i++)
        {
        seed  = ( seed * 3 + seed2  ) % maxValue;
        seed2 = ( seed + seed2 + 33 ) % maxValue;
        dSeed = seed;
        dRes = dSeed / dMax;
        out[i] = (byte)( ( java.lang.Math.floor( dRes * 31 ) + 64 ));
        }
     
    if(clientCapabilities == 1)
        {  /* Make it harder to break */
        seed  = ( seed * 3 + seed2  ) % maxValue;
        seed2 = ( seed + seed2 + 33 ) % maxValue;
        dSeed = seed;
        dRes = dSeed / dMax;
        byte e = (byte)( java.lang.Math.floor( dRes * 31 ) );
        for(int i = 0; i < hsl ; i++)
            {
            out[i] ^= e;
            }
        }
    return out;
    }
}

