/**
*** Program jdbcMysqlURL.java
***    in product twz1jdbcForMysql, 
***    Copyright 1997, 1998 by Terrence W. Zellers.
***   
***  All rights explicitly reserved.
***
***  See file "LICENSE" in this package for conditions of use.
**/

/**
*** Idiot class to parse a url.
**/

package twz1.jdbc.mysql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

final class jdbcMysqlURL
{

boolean valid;
Hashtable values;

private static final int sbsize = 128;  // arbitrary (large for host names).
private static final int sbmax =  127;  // sbsize - 1. 


/** This constructor builds the values hashtable based on the url
*** after initializing it with the base defaults.
*** @param url The url from which values are derived.
**/

jdbcMysqlURL(String url)
    {
    this.valid = true;
    this.values = jdbcMysqlBase.copyDefaults();
    parseURL( url);
    }

/** This constructor builds the properties (hashtable values based
*** on the url optionally depending on useDefaults the default 
*** values.
*** @param The url from which values are sourced.
*** @param useDefaults whether or not to use the base defaults.
**/

jdbcMysqlURL(String url, boolean useDefaults)
    {
    this.valid = true;
    this.values = useDefaults ? jdbcMysqlBase.copyDefaults()
                              : new Hashtable();
    parseURL(url);
    }

/** With no parameters jdbcMysqlURL is instantiated as a valid
*** copy of the defaults.
**/

jdbcMysqlURL()
    {
    this.valid = true;
    this.values = jdbcMysqlBase.copyDefaults();
    }


/** This method parses a url and puts the appropriate values
*** in the Hashtable.
*** @url  The url to be parsed.
*** @return the validity of the url as determined.
**/
 
private boolean parseURL(String url)
    {
    if(url == null) return valid;
    values.put("URL",url);
    int len = url.length(); 
    if(len < 13) valid = false;
    else 
        {
        String prefix = url.substring(0,13);
        values.put("prefix", prefix);
        if(!prefix.equals("jdbc:z1MySQL:")) valid = false;
        }

    int state = 0;
    int c;
    String tname = "";
    StringBuffer sb = new StringBuffer(sbsize);
    for(int i = 13; i <= len; i++)
        {
        c = i < len ? url.charAt(i) : 0;
        switch(state) //============================================
            {
            case 0: //----------------------------------------------
                if(c == '/'){state = 1; break; }
                state = 2;
                i--;
                break;
    
            case 1: //----------------------------------------------      
                if(c == '/') { state = 3; break; }
                valid = false;
                break;
 
            case 2:   //------------ Building db name.--------------
                if(c == '?' || c == 0)
                    {
                    if(sb.length() > 0)
                        {
                        values.put("db", new String(sb));
                        sb = new StringBuffer(sbsize);
                        }
                    state = 4;
                    break;
                    }
                sb.append((char)c);
                break;
              
            case 3: //------------- Building host. -----------------
                if(c == ':' || c == '/' || c == 0) 
                    {
                    if(sb.length() > 0)
                        {
                        values.put("host", new String(sb));
                        sb = new StringBuffer(sbsize);
                        }
                    if(c == ':') state = 5;
                    if(c == '/') state = 2;  
                    break; 
                    }
                sb.append((char)c);
                break;

            case 4: //-------------- Property name. -----------------
                if(c == '=')
                    {
                    if(sb.length() == 0) { valid = false; break; }
                    tname = new String(sb);
                    sb = new StringBuffer(sbsize);
                    state = 6;
                    break;
                    }
                if(c == 0) { valid = false; break; }
                sb.append((char)c);
                break;
        
            case 5: //---------------- Building port. ----------------
                if(c == '/' || c == 0 )
                    {
                    if(sb.length() > 0)
                        {
                        values.put("port", new String(sb));
                        sb = new StringBuffer(sbsize);
                        }
                    state = 2;
                    break;                     
                    }
                if(c < '0' || c > '9') { valid = false; break; }
                sb.append((char)c);
                break;

           case 6: //----------------- Property value. ----------------
               if(c == '&' || c == ';' || c == 0)
                   {
                   values.put(tname, new String(sb));
                   sb = new StringBuffer(sbsize);
                   state = 4;
                   break;
                   }
               sb.append((char)c);
               break;
          
           default: valid = false; break;
           } // End switch. ============================================

       if(sb.length() >= sbmax) valid = false;
       if(c == 0 || valid == false) i = len;
       }
    tname = valid ? "true" : "false";
    values.put("valid", tname);
    return valid;
    } // End of parseURL.

/** Include the values from a properties list where those
*** preoperties do not conflict with the values already
*** defined for the hashtable.
*** @param p The included properties.
**/

void include(Properties p)
    {
    if(p == null) return;
    String name;
    Enumeration en = p.propertyNames();
    while(en.hasMoreElements())
        {
        name = (String) en.nextElement();
        if(values.get(name) == null)
              values.put(name, p.getProperty(name));
        }
    }


/** Include the values from another hashtable where those
*** preoperties do not conflict with the values already
*** defined for the hashtable.
*** @param p The included Hashtable.
**/

void include(Hashtable p)
    {
    if(p == null) return;
    String name;
    Enumeration en = p.keys();
    while(en.hasMoreElements())
        {
        name = (String) en.nextElement();
        if(values.get(name) == null)
              values.put(name, (String) p.get(name));
        }
    }

/** include from another of our own kind. */
void include(jdbcMysqlURL jurl)
    {
    include(jurl.values);
    }

/** Innovate methods overlay the values in the URL hashtable
*** with all the entries from the Properties parameter.
*** @param p The imported properties.
**/
void innovate(Properties p)
    {
    if(p == null) return;
    String name;
    Enumeration en = p.propertyNames();
    while(en.hasMoreElements())
        {
        name = (String) en.nextElement();
        values.put(name, p.getProperty(name));
        }
    }

/** Innovate methods overlay the values in the URL hashtable
*** with all the entries from the Properties parameter.
*** @param p The imported properties.
**/

void innovate(Hashtable p)
    {
    if(p == null) return;
    String name;
    Enumeration en = p.keys();
    while(en.hasMoreElements())
        {
        name = (String) en.nextElement();
        values.put(name, p.get(name));
        }
    }

/** Innovate from another of our own kind. */
void innovate(jdbcMysqlURL jurl)
    {
    innovate(jurl.values);
    if(!jurl.isValid()) valid = false;
    }

/** Retrieve a named property from the values.
*** @param name the name of the property.
**/
public String getProperty(String name)
    { return (String) values.get(name); }

/** Return the size of the properties hashtable */
int getSize() { return values.size(); }

/** Return the validity of the url properties. */
boolean isValid() { return valid; }

/** Set a property */
void setProperty(String name, String value)
    {
    if(value == null) values.remove(name);
    else values.put(name, value);
    }

/** Return an array of the names in the properties Hashtable. */
String[] getNames()
    {
    int size = values.size();
    String table[] = new String[size];
    Enumeration en = values.keys();
    int i = 0;
    while (en.hasMoreElements())
        {
        table[i++] = (String) en.nextElement();
        }
    return table;
    }

void debugProperty(String s)
    {
    jdbcMysqlDebug DEBUG = jdbcMysqlBase.getDebug();
    if(DEBUG == null) return;
    jdbcMysqlDumpBuffer jmdb = new jdbcMysqlDumpBuffer();

    jmdb.put(" ");
    jmdb.put(s);
    jmdb.put("validity is " + valid);   
    String t[] = getNames();
    for(int i = 0; i < t.length; i++)
        {
        jmdb.put(t[i] + " = " + getProperty(t[i]));
        }
    DEBUG.put(jmdb);
    }
   
}
