#ifndef DICTIONARY_H
#define DICTIONARY_H

#include <string>
#include <vector>
#include  <time.h>
#include  <stdlib.h>

extern const char* datadir;


class Dictionary
{
protected:
  vector<string> words;
public:
  string name;
  int max_field_size;
  int min_field_size;
  char delim;
  int file_size_equiv;
  
  Dictionary();
  virtual ~Dictionary(){}
  int load_file(const char* file);
  void load_list(const char* list_str);
  virtual const char* next_word() = 0;
  virtual void print() = 0;
};

class Rand_dictionary: public Dictionary
{
public:
  Rand_dictionary(): Dictionary()
   {
    srand(time(NULL));
   }
  
  const char* next_word();
  void print();
};

class Seq_dictionary: public Dictionary
{
protected:
 int cur_word_ind;
public:
 Seq_dictionary(): Dictionary(),cur_word_ind(0)
  {
  }
  const char* next_word();
  void print();
};

class Unique_dictionary: public Dictionary
{
protected:
 int id;
 string templ;
 int buf_size;

 void fix_template();
  
public:
 Unique_dictionary(): Dictionary(),id(0),templ("%d")
  {
    buf_size = 512;
  }
  void set_template(const char * templ)
   {
    this->templ = templ;
    fix_template();
    buf_size = strlen(templ) + 512;
   }
  const char* next_word();
  void print();
};

#endif

