/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

class FixedByteBufferPoolImpl {
    static final I18NHelper local = I18NHelper.getInstance(FixedByteBufferPoolImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(FixedByteBufferPoolImpl.class);
    static byte[] guard = new byte[0];
    ConcurrentLinkedQueue<ByteBuffer> pool;
    String name;
    int bufferSize;
    int highWaterMark = 0;

    void initializeGuard(ByteBuffer byteBuffer) {
        byteBuffer.position(byteBuffer.capacity() - guard.length);
        byteBuffer.put(guard);
        byteBuffer.clear();
    }

    void checkGuard(ByteBuffer byteBuffer, String string) {
        byteBuffer.clear();
        boolean bl = false;
        byteBuffer.position(byteBuffer.capacity() - guard.length);
        for (int i = 0; i < guard.length; ++i) {
            byte by = guard[i];
            byte by2 = byteBuffer.get();
            if (by == by2) continue;
            bl = true;
            logger.warn(local.message("WARN_Buffer_Pool_Guard_Check_Failed", string, byteBuffer.capacity() - guard.length, by, by2, byteBuffer.toString()));
        }
        this.initializeGuard(byteBuffer);
    }

    public FixedByteBufferPoolImpl(int n, String string) {
        this.bufferSize = n;
        this.name = string;
        this.pool = new ConcurrentLinkedQueue();
        logger.info("FixedByteBufferPoolImpl<init> for " + string + " bufferSize " + n);
    }

    public ByteBuffer borrowBuffer() {
        ByteBuffer byteBuffer = this.pool.poll();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocateDirect(this.bufferSize + guard.length);
            this.initializeGuard(byteBuffer);
            if (logger.isDetailEnabled()) {
                logger.detail("FixedByteBufferPoolImpl for " + this.name + " got new  buffer: position " + byteBuffer.position() + " capacity " + byteBuffer.capacity() + " limit " + byteBuffer.limit());
            }
        } else if (logger.isDetailEnabled()) {
            logger.detail("FixedByteBufferPoolImpl for " + this.name + " got used buffer: position " + byteBuffer.position() + " capacity " + byteBuffer.capacity() + " limit " + byteBuffer.limit());
        }
        byteBuffer.clear();
        return byteBuffer;
    }

    public void returnBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer.capacity() != this.bufferSize + guard.length) {
            String string = local.message("ERR_Wrong_Buffer_Size_Returned_To_Pool", this.name, this.bufferSize, byteBuffer.capacity());
            throw new ClusterJFatalInternalException(string);
        }
        this.pool.add(byteBuffer);
    }

    static {
        for (int i = 0; i < guard.length; ++i) {
            FixedByteBufferPoolImpl.guard[i] = 10;
        }
    }
}

