/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DictionaryImpl;
import com.mysql.clusterj.tie.KeyPart;
import com.mysql.clusterj.tie.NdbRecordOperationImpl;
import com.mysql.clusterj.tie.TableImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.clusterj.tie.VariableByteBufferPoolImpl;
import com.mysql.ndbjtie.ndbapi.Ndb;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbInterpretedCode;
import com.mysql.ndbjtie.ndbapi.NdbScanFilter;
import com.mysql.ndbjtie.ndbapi.NdbScanOperation;
import com.mysql.ndbjtie.ndbapi.NdbTransaction;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.List;

class DbImpl
implements Db {
    static final I18NHelper local = I18NHelper.getInstance(DbImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DbImpl.class);
    private Ndb ndb;
    private ByteBuffer errorBuffer;
    private ByteBuffer coordinatedTransactionIdBuffer;
    private ByteBuffer partitionKeyScratchBuffer;
    private BufferManager bufferManager;
    private NdbDictionary.Dictionary ndbDictionary;
    private DictionaryImpl dictionary;
    private ClusterConnectionImpl clusterConnection;
    private boolean closing = false;
    private ClusterTransaction clusterTransaction;
    private int numberOfIndexBoundCreated;
    private int numberOfIndexBoundDeleted;
    private int numberOfNdbInterpretedCodeCreated;
    private int numberOfNdbInterpretedCodeDeleted;
    private int numberOfNdbScanFilterCreated;
    private int numberOfNdbScanFilterDeleted;
    private int numberOfScanOptionsCreated;
    private int numberOfScanOptionsDeleted;
    private int autoIncrementBatchSize;
    private long autoIncrementStep;
    private long autoIncrementStart;

    public DbImpl(ClusterConnectionImpl clusterConnectionImpl, Ndb ndb, int n) {
        this.clusterConnection = clusterConnectionImpl;
        this.ndb = ndb;
        this.errorBuffer = this.clusterConnection.byteBufferPoolForDBImplError.borrowBuffer();
        this.partitionKeyScratchBuffer = this.clusterConnection.byteBufferPoolForPartitionKey.borrowBuffer();
        this.coordinatedTransactionIdBuffer = this.clusterConnection.byteBufferPoolForCoordinatedTransactionId.borrowBuffer();
        this.bufferManager = new BufferManager(this.clusterConnection.byteBufferPool);
        int n2 = ndb.init(n);
        this.handleError(n2, ndb);
        this.ndbDictionary = ndb.getDictionary();
        this.handleError((Object)this.ndbDictionary, ndb);
        this.dictionary = new DictionaryImpl(this.ndbDictionary, clusterConnectionImpl);
    }

    @Override
    public void assertNotClosed(String string) {
        if (this.closing || this.ndb == null) {
            throw new ClusterJUserException(local.message("ERR_Db_Is_Closing", (Object)string));
        }
    }

    protected void closing() {
        this.closing = true;
    }

    @Override
    public void close() {
        if (this.numberOfIndexBoundCreated != this.numberOfIndexBoundDeleted) {
            logger.warn("numberOfIndexBoundCreated " + this.numberOfIndexBoundCreated + " != numberOfIndexBoundDeleted " + this.numberOfIndexBoundDeleted);
        }
        if (this.numberOfNdbInterpretedCodeCreated != this.numberOfNdbInterpretedCodeDeleted) {
            logger.warn("numberOfNdbInterpretedCodeCreated " + this.numberOfNdbInterpretedCodeCreated + " != numberOfNdbInterpretedCodeDeleted " + this.numberOfNdbInterpretedCodeDeleted);
        }
        if (this.numberOfNdbScanFilterCreated != this.numberOfNdbScanFilterDeleted) {
            logger.warn("numberOfNdbScanFilterCreated " + this.numberOfNdbScanFilterCreated + " != numberOfNdbScanFilterDeleted " + this.numberOfNdbScanFilterDeleted);
        }
        if (this.numberOfScanOptionsCreated != this.numberOfScanOptionsDeleted) {
            logger.warn("numberOfScanOptionsCreated " + this.numberOfScanOptionsCreated + " != numberOfScanOptionsDeleted " + this.numberOfScanOptionsDeleted);
        }
        if (this.clusterTransaction != null) {
            this.clusterTransaction.close();
            this.clusterTransaction = null;
        }
        if (this.ndb != null) {
            Ndb.delete(this.ndb);
            this.ndb = null;
        }
        this.clusterConnection.byteBufferPoolForDBImplError.returnBuffer(this.errorBuffer);
        this.clusterConnection.byteBufferPoolForPartitionKey.returnBuffer(this.partitionKeyScratchBuffer);
        this.clusterConnection.byteBufferPoolForCoordinatedTransactionId.returnBuffer(this.coordinatedTransactionIdBuffer);
        this.bufferManager.release();
        this.clusterConnection.close(this);
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }

    @Override
    public ClusterTransaction startTransaction(String string) {
        this.assertNotClosed("DbImpl.startTransaction()");
        this.clusterTransaction = new ClusterTransactionImpl(this.clusterConnection, this, this.ndbDictionary, string);
        return this.clusterTransaction;
    }

    protected void handleError(int n, Ndb ndb) {
        if (n == 0) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(n, ndbErrorConst, string);
    }

    protected void handleError(Object object, Ndb ndb) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = ndb.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    protected void handleError(Object object, NdbDictionary.Dictionary dictionary) {
        if (object != null) {
            return;
        }
        NdbErrorConst ndbErrorConst = dictionary.getNdbError();
        String string = this.getNdbErrorDetail(ndbErrorConst);
        Utility.throwError(null, ndbErrorConst, string);
    }

    @Override
    public boolean isRetriable(ClusterJDatastoreException clusterJDatastoreException) {
        return Utility.isRetriable(clusterJDatastoreException);
    }

    public String getNdbErrorDetail(NdbErrorConst ndbErrorConst) {
        return this.ndb.getNdbErrorDetail(ndbErrorConst, this.errorBuffer, this.errorBuffer.capacity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbTransaction enlist(String string, List<KeyPart> list) {
        NdbTransaction ndbTransaction;
        if (list == null || list.size() <= 0) {
            throw new ClusterJFatalInternalException(local.message("ERR_Key_Parts_Must_Not_Be_Null_Or_Zero_Length", (Object)string));
        }
        int n = list.size();
        NdbTransaction ndbTransaction2 = null;
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string);
        this.handleError((Object)tableConst, this.ndbDictionary);
        Ndb.Key_part_ptrArray key_part_ptrArray = null;
        if (n == 1) {
            KeyPart keyPart = list.get(0);
            ByteBuffer byteBuffer = keyPart.buffer;
            int n2 = keyPart.length;
            ndbTransaction2 = this.ndb.startTransaction(tableConst, byteBuffer, n2);
            if (ndbTransaction2 == null) {
                logger.warn(local.message("ERR_Transaction_Start_Failed", string, byteBuffer.position(), byteBuffer.limit(), byteBuffer.capacity(), n2));
            }
            this.bufferManager.returnPartitionKeyPartBuffer(n2, byteBuffer);
            this.handleError((Object)ndbTransaction2, this.ndb);
            return ndbTransaction2;
        }
        key_part_ptrArray = Ndb.Key_part_ptrArray.create(n + 1);
        try {
            Ndb.Key_part_ptr key_part_ptr;
            for (int i = 0; i < n; ++i) {
                key_part_ptr = key_part_ptrArray.at(i);
                key_part_ptr.ptr(list.get((int)i).buffer);
                key_part_ptr.len(list.get((int)i).length);
            }
            key_part_ptr = key_part_ptrArray.at(n);
            key_part_ptr.ptr(null);
            key_part_ptr.len(0);
            ndbTransaction2 = this.ndb.startTransaction(tableConst, key_part_ptrArray, this.partitionKeyScratchBuffer, this.partitionKeyScratchBuffer.capacity());
            this.handleError((Object)ndbTransaction2, this.ndb);
            ndbTransaction = ndbTransaction2;
        }
        catch (Throwable throwable) {
            Ndb.Key_part_ptrArray.delete(key_part_ptrArray);
            for (int i = 0; i < n; ++i) {
                KeyPart keyPart = list.get(i);
                this.bufferManager.returnPartitionKeyPartBuffer(keyPart.length, keyPart.buffer);
            }
            throw throwable;
        }
        Ndb.Key_part_ptrArray.delete(key_part_ptrArray);
        for (int i = 0; i < n; ++i) {
            KeyPart keyPart = list.get(i);
            this.bufferManager.returnPartitionKeyPartBuffer(keyPart.length, keyPart.buffer);
        }
        return ndbTransaction;
    }

    public NdbTransaction enlist(String string, int n) {
        NdbTransaction ndbTransaction = null;
        if (string == null) {
            ndbTransaction = this.ndb.startTransaction(null, null, 0);
        } else {
            NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string);
            ndbTransaction = this.ndb.startTransaction(tableConst, n);
        }
        this.handleError((Object)ndbTransaction, this.ndb);
        return ndbTransaction;
    }

    public ByteBuffer getCoordinatedTransactionIdBuffer() {
        return this.coordinatedTransactionIdBuffer;
    }

    public NdbTransaction joinTransaction(String string) {
        if (logger.isDetailEnabled()) {
            logger.detail("CoordinatedTransactionId: " + string);
        }
        throw new ClusterJFatalInternalException("Not Implemented");
    }

    public BufferManager getBufferManager() {
        return this.bufferManager;
    }

    public NdbRecordOperationImpl newNdbRecordOperationImpl(Table table) {
        return this.clusterConnection.newNdbRecordOperationImpl(this, table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbIndexScanOperation.IndexBound createIndexBound() {
        NdbIndexScanOperation.IndexBound indexBound = null;
        int n = 0;
        Object var3_3 = null;
        if (var3_3 != null) {
            ++n;
            Object var4_4 = var3_3;
            synchronized (var4_4) {
                indexBound = NdbIndexScanOperation.IndexBound.create();
            }
        } else {
            while (indexBound == null && n++ < 10) {
                indexBound = NdbIndexScanOperation.IndexBound.create();
            }
        }
        if (indexBound == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Constructor", "IndexBound", "failed", n));
        }
        if (n != 1) {
            logger.warn(local.message("ERR_Constructor", "IndexBound", "succeeded", n));
        }
        ++this.numberOfIndexBoundCreated;
        return indexBound;
    }

    public void delete(NdbIndexScanOperation.IndexBound indexBound) {
        ++this.numberOfIndexBoundDeleted;
        NdbIndexScanOperation.IndexBound.delete(indexBound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbInterpretedCode createInterpretedCode(NdbDictionary.TableConst tableConst, int n) {
        NdbInterpretedCode ndbInterpretedCode = null;
        int n2 = 0;
        Object var5_5 = null;
        if (var5_5 != null) {
            ++n2;
            Object var6_6 = var5_5;
            synchronized (var6_6) {
                ndbInterpretedCode = NdbInterpretedCode.create(tableConst, null, n);
            }
        } else {
            while (ndbInterpretedCode == null && n2++ < 10) {
                ndbInterpretedCode = NdbInterpretedCode.create(tableConst, null, n);
            }
        }
        if (ndbInterpretedCode == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_NdbInterpretedCode_Constructor", (Object)"failed", (Object)n2));
        }
        if (n2 != 1) {
            logger.warn(local.message("ERR_Constructor", "NdbInterpretedCode", "succeeded", n2));
        }
        ++this.numberOfNdbInterpretedCodeCreated;
        return ndbInterpretedCode;
    }

    public void delete(NdbInterpretedCode ndbInterpretedCode) {
        ++this.numberOfNdbInterpretedCodeDeleted;
        NdbInterpretedCode.delete(ndbInterpretedCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbScanFilter createScanFilter(NdbInterpretedCode ndbInterpretedCode) {
        NdbScanFilter ndbScanFilter = null;
        int n = 0;
        Object var4_4 = null;
        if (var4_4 != null) {
            ++n;
            Object var5_5 = var4_4;
            synchronized (var5_5) {
                ndbScanFilter = NdbScanFilter.create(ndbInterpretedCode);
            }
        } else {
            while (ndbScanFilter == null && n++ < 10) {
                ndbScanFilter = NdbScanFilter.create(ndbInterpretedCode);
            }
        }
        if (ndbScanFilter == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Constructor", "NdbScanFilter", "failed", n));
        }
        if (n != 1) {
            logger.warn(local.message("ERR_Constructor", "NdbScanFilter", "succeeded", n));
        }
        ++this.numberOfNdbScanFilterCreated;
        return ndbScanFilter;
    }

    public void delete(NdbScanFilter ndbScanFilter) {
        ++this.numberOfNdbScanFilterDeleted;
        NdbScanFilter.delete(ndbScanFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdbScanOperation.ScanOptions createScanOptions() {
        NdbScanOperation.ScanOptions scanOptions = null;
        int n = 0;
        Object var3_3 = null;
        if (var3_3 != null) {
            ++n;
            Object var4_4 = var3_3;
            synchronized (var4_4) {
                scanOptions = NdbScanOperation.ScanOptions.create();
            }
        } else {
            while (scanOptions == null && n++ < 10) {
                scanOptions = NdbScanOperation.ScanOptions.create();
            }
        }
        if (scanOptions == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Constructor", "ScanOptions", "failed", n));
        }
        if (n != 1) {
            logger.warn(local.message("ERR_Constructor", "ScanOptions", "succeeded", n));
        }
        ++this.numberOfScanOptionsCreated;
        return scanOptions;
    }

    public void delete(NdbScanOperation.ScanOptions scanOptions) {
        ++this.numberOfScanOptionsDeleted;
        NdbScanOperation.ScanOptions.delete(scanOptions);
    }

    public long getAutoincrementValue(Table table) {
        long[] lArray = new long[]{0L, this.autoIncrementBatchSize, this.autoIncrementStep, this.autoIncrementStart};
        int n = this.ndb.getAutoIncrementValue(((TableImpl)table).ndbTable, lArray, this.autoIncrementBatchSize, this.autoIncrementStep, this.autoIncrementStart);
        this.handleError(n, this.ndb);
        long l = lArray[0];
        if (logger.isDetailEnabled()) {
            logger.detail("getAutoIncrementValue(...batchSize: " + this.autoIncrementBatchSize + " step: " + this.autoIncrementStep + " start: " + this.autoIncrementStart + ") returned " + l);
        }
        return l;
    }

    public void initializeAutoIncrement(long[] lArray) {
        this.autoIncrementBatchSize = (int)lArray[0];
        this.autoIncrementStep = lArray[1];
        this.autoIncrementStart = lArray[2];
    }

    public class BufferManager {
        public static final int STRING_BYTE_BUFFER_INITIAL_SIZE = 1000;
        private int stringByteBufferCurrentSize = 1000;
        ByteBuffer stringByteBuffer = null;
        CharBuffer stringCharBuffer = null;
        public static final int STRING_STORAGE_BUFFER_INITIAL_SIZE = 500;
        private int stringStorageBufferCurrentSize = 1000;
        private ByteBuffer stringStorageBuffer;
        private int resultDataBufferCurrentSize = 0;
        private ByteBuffer resultDataBuffer;
        private VariableByteBufferPoolImpl pool;

        protected BufferManager(VariableByteBufferPoolImpl variableByteBufferPoolImpl) {
            this.pool = variableByteBufferPoolImpl;
            this.stringStorageBuffer = variableByteBufferPoolImpl.borrowBuffer(500);
            this.stringByteBuffer = variableByteBufferPoolImpl.borrowBuffer(1000);
            this.stringCharBuffer = this.stringByteBuffer.asCharBuffer();
        }

        protected void release() {
            if (this.resultDataBuffer != null) {
                this.pool.returnBuffer(this.resultDataBufferCurrentSize, this.resultDataBuffer);
            }
            this.pool.returnBuffer(this.stringStorageBufferCurrentSize, this.stringStorageBuffer);
            this.pool.returnBuffer(this.stringByteBufferCurrentSize, this.stringByteBuffer);
        }

        public void guaranteeStringStorageBufferSize(int n) {
            if (n > this.stringStorageBufferCurrentSize) {
                if (logger.isDebugEnabled()) {
                    logger.debug(local.message("MSG_Reallocated_Byte_Buffer", "string storage", this.stringStorageBufferCurrentSize, n));
                }
                this.pool.returnBuffer(this.stringStorageBufferCurrentSize, this.stringStorageBuffer);
                this.stringStorageBuffer = this.pool.borrowBuffer(n);
                this.stringStorageBufferCurrentSize = n;
            }
            this.stringStorageBuffer.limit(this.stringStorageBufferCurrentSize);
        }

        public ByteBuffer copyStringToByteBuffer(CharSequence charSequence) {
            if (charSequence == null) {
                this.stringByteBuffer.limit(0);
                return this.stringByteBuffer;
            }
            int n = charSequence.length() * 2;
            this.guaranteeStringByteBufferSize(n);
            this.stringCharBuffer.append(charSequence);
            this.stringByteBuffer.limit(this.stringCharBuffer.position() * 2);
            return this.stringByteBuffer;
        }

        public void clearStringStorageBuffer() {
            this.stringStorageBuffer.clear();
        }

        public ByteBuffer getStringStorageBuffer(int n) {
            this.guaranteeStringStorageBufferSize(n);
            return this.stringStorageBuffer;
        }

        public ByteBuffer getStringByteBuffer(int n) {
            this.guaranteeStringByteBufferSize(n);
            return this.stringByteBuffer;
        }

        public ByteBuffer borrowBuffer(int n) {
            return this.pool.borrowBuffer(n);
        }

        public void returnBuffer(int n, ByteBuffer byteBuffer) {
            this.pool.returnBuffer(n, byteBuffer);
        }

        protected void guaranteeStringByteBufferSize(int n) {
            if (n > this.stringByteBufferCurrentSize) {
                this.pool.returnBuffer(this.stringByteBufferCurrentSize, this.stringByteBuffer);
                this.stringByteBufferCurrentSize = n;
                this.stringByteBuffer = this.pool.borrowBuffer(n);
                this.stringCharBuffer = this.stringByteBuffer.asCharBuffer();
            }
            this.stringByteBuffer.limit(this.stringByteBufferCurrentSize);
            this.stringByteBuffer.position(0);
            this.stringCharBuffer.limit(this.stringByteBufferCurrentSize / 2);
            this.stringCharBuffer.position(0);
        }

        public CharBuffer getStringCharBuffer() {
            return this.stringCharBuffer;
        }

        public ByteBuffer getResultDataBuffer(int n) {
            if (n > this.resultDataBufferCurrentSize) {
                if (logger.isDebugEnabled()) {
                    logger.debug(local.message("MSG_Reallocated_Byte_Buffer", "result data", this.resultDataBufferCurrentSize, n));
                }
                if (this.resultDataBuffer != null) {
                    this.pool.returnBuffer(this.resultDataBufferCurrentSize, this.resultDataBuffer);
                }
                this.resultDataBuffer = this.pool.borrowBuffer(n);
                this.resultDataBufferCurrentSize = n;
            }
            this.resultDataBuffer.limit(this.resultDataBufferCurrentSize);
            this.resultDataBuffer.position(0);
            return this.resultDataBuffer;
        }

        public ByteBuffer borrowPartitionKeyPartBuffer(int n) {
            return this.pool.borrowBuffer(n);
        }

        public void returnPartitionKeyPartBuffer(int n, ByteBuffer byteBuffer) {
            this.pool.returnBuffer(n, byteBuffer);
        }
    }
}

