/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;

public abstract class TestCase
implements Test {
    public String name;
    public Method method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(TestResult testResult) {
        TestListener testListener = testResult.listener;
        testListener.startTest(this);
        try {
            this.setUp();
            try {
                this.method.invoke((Object)this, new Object[0]);
                testResult.successes.add(this.name);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof AssertionFailedError) {
                    testResult.failures.add(this.name);
                    testListener.addFailure(this, (AssertionFailedError)((Object)throwable));
                } else {
                    testResult.throwables.add(throwable);
                    testListener.addError(this, throwable);
                }
            }
            finally {
                this.tearDown();
            }
        }
        catch (Throwable throwable) {
            testResult.throwables.add(throwable);
            testListener.addError(this, throwable);
        }
        testListener.endTest(this);
    }

    public static void fail(String string) {
        throw new AssertionFailedError(string);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public int countTestCases() {
        return 0;
    }

    public String toString() {
        return this.method.getDeclaringClass().getPackage().getName() + "." + this.name;
    }
}

