/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Session;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.Employee;

public class AutoCloseableTest
extends AbstractClusterJTest {
    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.session.close();
        this.addTearDownClasses(Employee.class);
    }

    public void test() {
        this.testFind();
        this.testGoodPersistCommit();
        this.testBadPersistIllegalNullFlush();
        this.testBadPersistFlushNoCommit();
        this.testBadPersistIllegalNullCommit();
        this.testBadPersistDuplicateKeyCommit();
        this.testBadPersistDuplicateKeyFlush();
        this.testBadPersistAutoCommit();
        this.testBadDeleteFlush();
        this.testBadDeleteCommit();
        this.testBadDeleteAutoCommit();
        this.failOnError();
    }

    protected void testFind() {
        this.runTest(new RunWithSession("testFind", null){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                session.find(Employee.class, (Object)10000);
            }
        });
    }

    protected void testGoodPersistCommit() {
        this.runTest(new RunWithSession("testGoodPersistCommit", null){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)170);
                employee.setMagic(170);
                session.persist((Object)employee);
                session.currentTransaction().commit();
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)170);
                if (employee == null) {
                    this.errorMessage = "failed to find Employee 170";
                }
                session.deletePersistent(Employee.class, (Object)170);
            }
        });
    }

    protected void testBadPersistIllegalNullFlush() {
        this.runTest(new RunWithSession("testBadPersistIllegalNullFlush", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)171);
                session.persist((Object)employee);
                session.flush();
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)171);
                if (employee != null) {
                    this.errorMessage = "unexpected found Employee 171";
                }
            }
        });
    }

    protected void testBadPersistFlushNoCommit() {
        this.runTest(new RunWithSession("testBadPersistFlushNoCommit", null){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)172);
                employee.setMagic(172);
                session.persist((Object)employee);
                session.flush();
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)172);
                if (employee != null) {
                    this.errorMessage = "unexpected found Employee 172";
                }
            }
        });
    }

    protected void testBadPersistDuplicateKeyCommit() {
        this.runTest(new RunWithSession("testBadPersistDuplicateKeyCommit", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)173);
                employee.setMagic(173);
                Employee employee2 = (Employee)session.newInstance(Employee.class, (Object)173);
                employee2.setMagic(173);
                session.persist((Object)employee);
                session.persist((Object)employee2);
                session.currentTransaction().commit();
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)173);
                if (employee != null) {
                    this.errorMessage = "unexpected found Employee 173";
                }
            }
        });
    }

    protected void testBadPersistDuplicateKeyFlush() {
        this.runTest(new RunWithSession("testBadPersistDuplicateKeyFlush", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)174);
                employee.setMagic(174);
                Employee employee2 = (Employee)session.newInstance(Employee.class, (Object)174);
                employee2.setMagic(174);
                session.persist((Object)employee);
                session.persist((Object)employee2);
                session.flush();
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)174);
                if (employee != null) {
                    this.errorMessage = "unexpected found Employee 174";
                }
            }
        });
    }

    protected void testBadPersistIllegalNullCommit() {
        this.runTest(new RunWithSession("testBadPersistIllegalNullCommit", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)175);
                session.persist((Object)employee);
                session.currentTransaction().commit();
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)175);
                if (employee != null) {
                    this.errorMessage = "unexpected found Employee 175";
                }
            }
        });
    }

    protected void testBadPersistAutoCommit() {
        this.runTest(new RunWithSession("testBadPersistAutoCommit", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                Employee employee = (Employee)session.newInstance(Employee.class, (Object)176);
                session.persist((Object)employee);
            }

            @Override
            public void check(Session session) {
                Employee employee = (Employee)session.find(Employee.class, (Object)176);
                if (employee != null) {
                    this.errorMessage = "unexpected found Employee 176";
                }
            }
        });
    }

    protected void testBadDeleteFlush() {
        this.runTest(new RunWithSession("testBadDeleteFlush", null){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                session.deletePersistent(Employee.class, (Object)177);
                session.flush();
            }
        });
    }

    protected void testBadDeleteCommit() {
        this.runTest(new RunWithSession("testBadDeleteCommit", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                session.currentTransaction().begin();
                session.deletePersistent(Employee.class, (Object)178);
                session.currentTransaction().commit();
            }
        });
    }

    protected void testBadDeleteAutoCommit() {
        this.runTest(new RunWithSession("testBadDeleteAutoCommit", "ClusterJDatastoreException"){

            @Override
            public void run(Session session) {
                session.deletePersistent(Employee.class, (Object)179);
            }
        });
    }

    protected void checkException(Exception exception, RunWithSession runWithSession) {
        if (runWithSession.expectedException == null) {
            this.error(runWithSession.where + " caught unexpected exception: " + exception.getClass().getName() + " " + exception.getMessage());
        }
        if (runWithSession.expectedException != null && !exception.getClass().getName().contains(runWithSession.expectedException)) {
            this.error(runWithSession.where + " caught wrong exception in run: " + exception.getClass().getName() + " " + exception.getMessage());
        }
    }

    protected void runTest(RunWithSession runWithSession) {
        Throwable throwable;
        Session session;
        try {
            session = this.sessionFactory.getSession();
            throwable = null;
            try {
                this.session = session;
                runWithSession.run(session);
                if (runWithSession.expectedException != null) {
                    this.error(runWithSession.where + " failed to throw exception " + runWithSession.expectedException);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session != null) {
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.checkException(exception, runWithSession);
        }
        if (!this.session.isClosed()) {
            this.error(runWithSession.where + " session was not closed in run");
        }
        try {
            session = this.sessionFactory.getSession();
            throwable = null;
            try {
                this.session = session;
                runWithSession.check(session);
                String string = runWithSession.errorMessage;
                if (string != null) {
                    this.error(runWithSession.where + " " + string);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (session != null) {
                    if (throwable != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        session.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            this.checkException(exception, runWithSession);
        }
        if (!this.session.isClosed()) {
            this.error(runWithSession.where + " session was not closed in check");
        }
        try {
            this.session.close();
            this.session = null;
        }
        catch (Exception exception) {
            this.error(runWithSession.where + " session.close threw exception: " + exception.getClass().getName() + " " + exception.getMessage());
        }
    }

    protected abstract class RunWithSession {
        String expectedException;
        String where;
        String errorMessage = null;

        RunWithSession(String string, String string2) {
            this.where = string;
            this.expectedException = string2;
        }

        void run(Session session) {
        }

        void check(Session session) {
        }
    }
}

