/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.Time;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.IdBase;
import testsuite.clusterj.model.TimeAsSqlTimeTypes;

public class QueryTimeAsSqlTimeTypesTest
extends AbstractQueryTest {
    public Class<TimeAsSqlTimeTypes> getInstanceType() {
        return TimeAsSqlTimeTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllTimeAsSqlTimeTypesInstances(n);
    }

    @Override
    protected void consistencyCheck(IdBase idBase) {
        TimeAsSqlTimeTypes timeAsSqlTimeTypes = (TimeAsSqlTimeTypes)idBase;
        Time time = this.getTimeFor(timeAsSqlTimeTypes.getId());
        String string = "Wrong values retrieved from ";
        this.errorIfNotEqual(string + "time_not_null_both", time, timeAsSqlTimeTypes.getTime_not_null_both());
        this.errorIfNotEqual(string + "time_not_null_btree", time, timeAsSqlTimeTypes.getTime_not_null_btree());
        this.errorIfNotEqual(string + "time_not_null_hash", time, timeAsSqlTimeTypes.getTime_not_null_hash());
        this.errorIfNotEqual(string + "time_not_null_none", time, timeAsSqlTimeTypes.getTime_not_null_none());
    }

    public void test() {
        this.btreeIndexScanTime();
        this.hashIndexScanTime();
        this.bothIndexScanTime();
        this.noneIndexScanTime();
        this.failOnError();
    }

    public void btreeIndexScanTime() {
        this.equalQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(8), 8);
        this.greaterEqualQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), this.getTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), this.getTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("time_not_null_btree", "idx_time_not_null_btree", this.getTimeFor(4), this.getTimeFor(6), 5);
    }

    public void hashIndexScanTime() {
        this.equalQuery("time_not_null_hash", "idx_time_not_null_hash", this.getTimeFor(8), 8);
        this.greaterEqualQuery("time_not_null_hash", "none", this.getTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("time_not_null_hash", "none", this.getTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("time_not_null_hash", "none", this.getTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("time_not_null_hash", "none", this.getTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("time_not_null_hash", "none", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("time_not_null_hash", "none", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("time_not_null_hash", "none", this.getTimeFor(4), this.getTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("time_not_null_hash", "none", this.getTimeFor(4), this.getTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("time_not_null_hash", "none", this.getTimeFor(4), this.getTimeFor(6), 5);
    }

    public void bothIndexScanTime() {
        this.equalQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(8), 8);
        this.greaterEqualQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), this.getTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), this.getTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("time_not_null_both", "idx_time_not_null_both", this.getTimeFor(4), this.getTimeFor(6), 5);
    }

    public void noneIndexScanTime() {
        this.equalQuery("time_not_null_none", "none", this.getTimeFor(8), 8);
        this.greaterEqualQuery("time_not_null_none", "none", this.getTimeFor(7), 7, 8, 9);
        this.greaterThanQuery("time_not_null_none", "none", this.getTimeFor(6), 7, 8, 9);
        this.lessEqualQuery("time_not_null_none", "none", this.getTimeFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("time_not_null_none", "none", this.getTimeFor(4), 3, 2, 1, 0);
        this.betweenQuery("time_not_null_none", "none", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("time_not_null_none", "none", this.getTimeFor(4), this.getTimeFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("time_not_null_none", "none", this.getTimeFor(4), this.getTimeFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("time_not_null_none", "none", this.getTimeFor(4), this.getTimeFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("time_not_null_none", "none", this.getTimeFor(4), this.getTimeFor(6), 5);
    }

    private void createAllTimeAsSqlTimeTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            TimeAsSqlTimeTypes timeAsSqlTimeTypes = (TimeAsSqlTimeTypes)this.session.newInstance(TimeAsSqlTimeTypes.class);
            timeAsSqlTimeTypes.setId(i);
            timeAsSqlTimeTypes.setTime_not_null_hash(this.getTimeFor(i));
            timeAsSqlTimeTypes.setTime_not_null_btree(this.getTimeFor(i));
            timeAsSqlTimeTypes.setTime_not_null_both(this.getTimeFor(i));
            timeAsSqlTimeTypes.setTime_not_null_none(this.getTimeFor(i));
            this.instances.add(timeAsSqlTimeTypes);
        }
    }

    protected Time getTimeFor(int n) {
        return new Time(QueryTimeAsSqlTimeTypesTest.getMillisFor(0, 0, n, 0));
    }

    public static String toString(IdBase idBase) {
        TimeAsSqlTimeTypes timeAsSqlTimeTypes = (TimeAsSqlTimeTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("TimeTypes id: ");
        stringBuffer.append(timeAsSqlTimeTypes.getId());
        stringBuffer.append("; time_not_null_both: ");
        stringBuffer.append(timeAsSqlTimeTypes.getTime_not_null_both().toString());
        stringBuffer.append("; time_not_null_btree: ");
        stringBuffer.append(timeAsSqlTimeTypes.getTime_not_null_btree().toString());
        stringBuffer.append("; time_not_null_hash: ");
        stringBuffer.append(timeAsSqlTimeTypes.getTime_not_null_hash().toString());
        stringBuffer.append("; time_not_null_none: ");
        stringBuffer.append(timeAsSqlTimeTypes.getTime_not_null_none().toString());
        return stringBuffer.toString();
    }
}

