/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class MgmClient
implements AutoCloseable {
    Socket mgmSocket;
    PrintWriter mgmSocketWriter;
    BufferedReader mgmSocketReader;
    List<Node> nodes;

    public MgmClient(Properties properties) throws IOException {
        String string = properties.getProperty("com.mysql.clusterj.connectstring");
        String[] stringArray = string.split(",");
        String string2 = stringArray[0].startsWith("nodeid") ? stringArray[1] : stringArray[0];
        String[] stringArray2 = string2.split(":");
        String string3 = stringArray2[0];
        int n = stringArray2.length > 0 ? Integer.parseInt(stringArray2[1]) : 1186;
        try {
            this.mgmSocket = new Socket(string3, n);
            this.mgmSocketWriter = new PrintWriter(this.mgmSocket.getOutputStream(), true);
            this.mgmSocketReader = new BufferedReader(new InputStreamReader(this.mgmSocket.getInputStream()));
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException("Failed to connect to the management node", unknownHostException);
        }
        this.retrieveNodeStatus();
    }

    @Override
    public void close() {
        try {
            if (this.mgmSocketReader != null) {
                this.mgmSocketReader.close();
            }
            if (this.mgmSocketWriter != null) {
                this.mgmSocketWriter.close();
            }
            if (this.mgmSocket != null) {
                this.mgmSocket.close();
            }
        }
        catch (IOException iOException) {
            System.err.println("Caught exception when closing the MgmClient : " + iOException.getMessage());
        }
    }

    private void verify(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException(string);
        }
    }

    private boolean retrieveNodeStatus() {
        this.nodes = new ArrayList<Node>();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.executeCommand("get status", null, arrayList)) {
            return false;
        }
        this.verify(((String)arrayList.get(0)).equals("node status"), "Unrecognized header in 'get status' reply");
        String string = (String)arrayList.get(1);
        this.verify(string.startsWith("nodes: "), "Unrecognized string in 'get status' reply");
        int n = string.indexOf(58) + 2;
        int n2 = Integer.parseInt(string.substring(n));
        for (String string2 : arrayList.subList(2, arrayList.size())) {
            if (!string2.contains("type")) continue;
            String[] stringArray = string2.split("\\.|=|: ");
            this.verify(stringArray[0].equals("node") && stringArray[2].equals("type"), "Unrecognized string in 'get status' reply");
            int n3 = Integer.parseInt(stringArray[1]);
            Node.NodeType nodeType = Node.NodeType.valueOf(stringArray[3]);
            this.nodes.add(new Node(n3, nodeType));
        }
        this.verify(this.nodes.size() == n2, "Incorrect number of nodes in 'get status' reply");
        return true;
    }

    private boolean executeCommand(String string, Map<String, Object> map, List<String> list) {
        try {
            this.mgmSocketWriter.println(string);
            if (map != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    this.mgmSocketWriter.println(entry.getKey() + ":" + entry.getValue());
                }
            }
            this.mgmSocketWriter.println();
            this.mgmSocket.setSoTimeout(60000);
            Object object = null;
            do {
                object = this.mgmSocketReader.readLine();
                list.add((String)object);
            } while (!((String)object).isEmpty());
            list.remove(list.size() - 1);
        }
        catch (IOException iOException) {
            System.err.println("Failed to read/write into the socket. Caught exception : " + iOException.getMessage());
            return false;
        }
        return true;
    }

    private boolean parseResult(String string, List<String> list) {
        this.verify(list.get(0).equals(string + " reply"), "Unrecognized header in '" + string + "' reply");
        String string2 = null;
        for (String string3 : list) {
            if (!string3.startsWith("result")) continue;
            int n = string3.indexOf(":");
            string2 = string3.substring(n + 2);
            if (!string2.equalsIgnoreCase("Ok")) {
                System.err.println("Command '" + string + "' failed with following error : " + string2);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean insertErrorOnNode(int n, int n2) {
        String string = "insert error";
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("node", n);
        linkedHashMap.put("error", n2);
        ArrayList<String> arrayList = new ArrayList<String>();
        return this.executeCommand(string, linkedHashMap, arrayList) && this.parseResult(string, arrayList);
    }

    public boolean insertErrorOnAllDataNodes(int n) {
        boolean bl = false;
        for (Node node : this.nodes) {
            if (node.type != Node.NodeType.NDB) continue;
            bl |= this.insertErrorOnNode(node.id, n);
        }
        return bl;
    }

    private static class Node {
        public final int id;
        public final NodeType type;

        Node(int n, NodeType nodeType) {
            this.id = n;
            this.type = nodeType;
        }

        public static enum NodeType {
            NDB,
            MGM,
            API;

        }
    }
}

