/*****************************************************************************

Copyright (c) 1996, 2021, Oracle and/or its affiliates.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License, version 2.0, as published by the
Free Software Foundation.

This program is also distributed with certain software (including but not
limited to OpenSSL) that is licensed under separate terms, as designated in a
particular file or component or in included license documentation. The authors
of MySQL hereby grant you an additional permission to link the program and
your derivative works with the separately licensed software that they have
included with MySQL.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0,
for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

*****************************************************************************/

/** @file include/btr0types.h
 The index tree general types

 Created 2/17/1996 Heikki Tuuri
 *************************************************************************/

#ifndef btr0types_h
#define btr0types_h

#include "univ.i"

#include "page0size.h"
#include "page0types.h"
#include "rem0types.h"
#include "sync0rw.h"

/** Persistent cursor */
struct btr_pcur_t;
/** B-tree cursor */
struct btr_cur_t;
/** B-tree search information for the adaptive hash index */
struct btr_search_t;

/** Is search system enabled.
Search system is protected by array of latches. */
extern bool btr_search_enabled;

/** Number of adaptive hash index partition. */
extern ulong btr_ahi_parts;

/** The size of a reference to data stored on a different page.
The reference is stored at the end of the prefix of the field
in the index record. */
constexpr uint32_t BTR_EXTERN_FIELD_REF_SIZE = FIELD_REF_SIZE;

/** If the data don't exceed the size, the data are stored locally. */
constexpr uint32_t BTR_EXTERN_LOCAL_STORED_MAX_SIZE =
    BTR_EXTERN_FIELD_REF_SIZE * 2;

#endif
