/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.HashMap;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class OrdinalEnumTemplate<T>
extends AbstractTemplate<T> {
    protected T[] entries;
    protected HashMap<T, Integer> reverse;

    public OrdinalEnumTemplate(Class<T> targetClass) {
        this.entries = targetClass.getEnumConstants();
        this.reverse = new HashMap();
        for (int i = 0; i < this.entries.length; ++i) {
            this.reverse.put(this.entries[i], i);
        }
    }

    @Override
    public void write(Packer pk, T target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        Integer ordinal = this.reverse.get(target);
        if (ordinal == null) {
            throw new MessageTypeException(new IllegalArgumentException("ordinal: " + ordinal));
        }
        pk.write((int)ordinal);
    }

    @Override
    public T read(Unpacker pac, T to, boolean required) throws IOException, MessageTypeException {
        if (!required && pac.trySkipNil()) {
            return null;
        }
        int ordinal = pac.readInt();
        if (this.entries.length <= ordinal) {
            throw new MessageTypeException(new IllegalArgumentException("ordinal: " + ordinal));
        }
        return this.entries[ordinal];
    }
}

