/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.beats;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.logstash.beats.AckEncoder;
import org.logstash.beats.BeatsHandler;
import org.logstash.beats.BeatsParser;
import org.logstash.beats.IMessageListener;
import org.logstash.beats.MessageListener;
import org.logstash.netty.SslSimpleBuilder;

public class Server {
    private static final Logger logger = Logger.getLogger(Server.class);
    static final long SHUTDOWN_TIMEOUT_SECONDS = 10L;
    private static final int DEFAULT_CLIENT_TIMEOUT_SECONDS = 15;
    private final int port;
    private final NioEventLoopGroup bossGroup;
    private final NioEventLoopGroup workGroup;
    private IMessageListener messageListener = new MessageListener();
    private SslSimpleBuilder sslBuilder;
    private final int clientInactivityTimeoutSeconds;

    public Server(int p) {
        this(p, 15);
    }

    public Server(int p, int timeout) {
        this.port = p;
        this.clientInactivityTimeoutSeconds = timeout;
        this.bossGroup = new NioEventLoopGroup();
        this.workGroup = new NioEventLoopGroup();
    }

    public void enableSSL(SslSimpleBuilder builder) {
        this.sslBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server listen() throws InterruptedException {
        BeatsInitializer beatsInitializer = null;
        try {
            logger.info((Object)("Starting server on port: " + this.port));
            beatsInitializer = new BeatsInitializer(this.isSslEnable(), this.messageListener, this.clientInactivityTimeoutSeconds);
            ServerBootstrap server = new ServerBootstrap();
            ((ServerBootstrap)server.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)beatsInitializer);
            Channel channel = server.bind(this.port).sync().channel();
            channel.closeFuture().sync();
        }
        finally {
            beatsInitializer.shutdownEventExecutor();
            this.bossGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
            this.workGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
        return this;
    }

    public void stop() throws InterruptedException {
        logger.debug((Object)"Server shutting down");
        Future bossWait = this.bossGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        Future workWait = this.workGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        logger.debug((Object)"Server stopped");
    }

    public void setMessageListener(IMessageListener listener) {
        this.messageListener = listener;
    }

    public boolean isSslEnable() {
        return this.sslBuilder != null;
    }

    private class BeatsInitializer
    extends ChannelInitializer<SocketChannel> {
        private final String LOGGER_HANDLER = "logger";
        private final String SSL_HANDLER = "ssl-handler";
        private final String KEEP_ALIVE_HANDLER = "keep-alive-handler";
        private final String BEATS_PARSER = "beats-parser";
        private final String BEATS_HANDLER = "beats-handler";
        private final String BEATS_ACKER = "beats-acker";
        private final int DEFAULT_IDLESTATEHANDLER_THREAD = 4;
        private final int IDLESTATE_WRITER_IDLE_TIME_SECONDS = 5;
        private final int IDLESTATE_ALL_IDLE_TIME_SECONDS = 0;
        private final EventExecutorGroup idleExecutorGroup;
        private final BeatsHandler beatsHandler;
        private final IMessageListener message;
        private int clientInactivityTimeoutSeconds;
        private final LoggingHandler loggingHandler = new LoggingHandler();
        private boolean enableSSL = false;

        public BeatsInitializer(Boolean secure, IMessageListener messageListener, int clientInactivityTimeoutSeconds) {
            this.enableSSL = secure;
            this.message = messageListener;
            this.beatsHandler = new BeatsHandler(this.message);
            this.clientInactivityTimeoutSeconds = clientInactivityTimeoutSeconds;
            this.idleExecutorGroup = new DefaultEventExecutorGroup(4);
        }

        public void initChannel(SocketChannel socket) throws IOException, NoSuchAlgorithmException, CertificateException {
            ChannelPipeline pipeline = socket.pipeline();
            pipeline.addLast("logger", (ChannelHandler)this.loggingHandler);
            if (this.enableSSL) {
                SslHandler sslHandler = Server.this.sslBuilder.build(socket.alloc());
                pipeline.addLast("ssl-handler", (ChannelHandler)sslHandler);
            }
            pipeline.addLast(this.idleExecutorGroup, "keep-alive-handler", (ChannelHandler)new IdleStateHandler(this.clientInactivityTimeoutSeconds, 5, 0));
            pipeline.addLast("beats-parser", (ChannelHandler)new BeatsParser());
            pipeline.addLast("beats-acker", (ChannelHandler)new AckEncoder());
            pipeline.addLast("beats-handler", (ChannelHandler)this.beatsHandler);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.message.onChannelInitializeException(ctx, cause);
        }

        public void shutdownEventExecutor() {
            this.idleExecutorGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        }
    }
}

