/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * fract(-2.0) => 0.0
 * fract(-0.66666669) => 0.33333331
 * fract(0.66666669) => 0.66666669
 * fract(2.0) => 0.0
 */
#version 120

void main()
{
  float[distance(fract(-2.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(fract(-0.66666669), 0.33333331) <= 3.3333331e-06 ? 1 : -1] array1;
  float[distance(fract(0.66666669), 0.66666669) <= 6.6666666e-06 ? 1 : -1] array2;
  float[distance(fract(2.0), 0.0) <= 0.0 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
