/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec2(38u, 35u) ^ (- 0u)) => uvec2(38u, 35u)
 * (uvec2(38u, 35u) ^ (- 6u)) => uvec2(4294967260u, 4294967257u)
 * (uvec2(38u, 35u) ^ (- 12u)) => uvec2(4294967250u, 4294967255u)
 * (uvec2(38u, 35u) ^ (- 32u)) => uvec2(4294967238u, 4294967235u)
 * (uvec2(38u, 35u) ^ (- 74u)) => uvec2(4294967184u, 4294967189u)
 * (uvec2(64u, 9u) ^ (- 0u)) => uvec2(64u, 9u)
 * (uvec2(64u, 9u) ^ (- 6u)) => uvec2(4294967226u, 4294967283u)
 * (uvec2(64u, 9u) ^ (- 12u)) => uvec2(4294967220u, 4294967293u)
 * (uvec2(64u, 9u) ^ (- 32u)) => uvec2(4294967200u, 4294967273u)
 * (uvec2(64u, 9u) ^ (- 74u)) => uvec2(4294967286u, 4294967231u)
 */
#version 130

void main()
{
  float[all(equal((uvec2(38u, 35u) ^ (- 0u)), uvec2(38u, 35u))) ? 1 : -1] array0;
  float[all(equal((uvec2(38u, 35u) ^ (- 6u)), uvec2(4294967260u, 4294967257u))) ? 1 : -1] array1;
  float[all(equal((uvec2(38u, 35u) ^ (- 12u)), uvec2(4294967250u, 4294967255u))) ? 1 : -1] array2;
  float[all(equal((uvec2(38u, 35u) ^ (- 32u)), uvec2(4294967238u, 4294967235u))) ? 1 : -1] array3;
  float[all(equal((uvec2(38u, 35u) ^ (- 74u)), uvec2(4294967184u, 4294967189u))) ? 1 : -1] array4;
  float[all(equal((uvec2(64u, 9u) ^ (- 0u)), uvec2(64u, 9u))) ? 1 : -1] array5;
  float[all(equal((uvec2(64u, 9u) ^ (- 6u)), uvec2(4294967226u, 4294967283u))) ? 1 : -1] array6;
  float[all(equal((uvec2(64u, 9u) ^ (- 12u)), uvec2(4294967220u, 4294967293u))) ? 1 : -1] array7;
  float[all(equal((uvec2(64u, 9u) ^ (- 32u)), uvec2(4294967200u, 4294967273u))) ? 1 : -1] array8;
  float[all(equal((uvec2(64u, 9u) ^ (- 74u)), uvec2(4294967286u, 4294967231u))) ? 1 : -1] array9;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length());
}
