/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(vec4(0.0, 1e-10, -1e-10, 0.1)) => vec4(0.0, 1e-10, -1e-10, 0.099668652)
 * atan(vec4(-0.1, 1.0, -1.0, 10.0)) => vec4(-0.099668652, 0.78539819, -0.78539819, 1.4711276)
 * atan(vec4(-10.0, 1e+10, -1e+10, 0.0)) => vec4(-1.4711276, 1.5707964, -1.5707964, 0.0)
 */
#version 150

void main()
{
  float[distance(atan(vec4(0.0, 1e-10, -1e-10, 0.1)), vec4(0.0, 1e-10, -1e-10, 0.099668652)) <= 0.00019999999 ? 1 : -1] array0;
  float[distance(atan(vec4(-0.1, 1.0, -1.0, 10.0)), vec4(-0.099668652, 0.78539819, -0.78539819, 1.4711276)) <= 0.0018460545 ? 1 : -1] array1;
  float[distance(atan(vec4(-10.0, 1e+10, -1e+10, 0.0)), vec4(-1.4711276, 1.5707964, -1.5707964, 0.0)) <= 0.0026662743 ? 1 : -1] array2;
  gl_Position = vec4(array0.length() + array1.length() + array2.length());
}
