/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf) => dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf) => dmat4(0.33333333333333326lf, 3.1033333333333335lf, 1.4233333333333333lf, 0.42333333333333323lf, 0.78333333333333321lf, 1.9533333333333331lf, 0.62333333333333329lf, -0.4866666666666668lf, 0.25333333333333319lf, 1.8133333333333332lf, -0.056666666666666643lf, -0.096666666666666679lf, 3.1233333333333331lf, -0.016666666666666829lf, 0.12333333333333329lf, 2.0533333333333332lf)
 * (dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf) => dmat4(-1.8500000000000001lf, 0.92000000000000004lf, -0.76000000000000001lf, -1.76lf, -1.3999999999999999lf, -0.22999999999999998lf, -1.5600000000000001lf, -2.6699999999999999lf, -1.9300000000000002lf, -0.37lf, -2.2399999999999998lf, -2.2799999999999998lf, 0.94000000000000006lf, -2.2000000000000002lf, -2.0600000000000001lf, -0.13lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf) => dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf) => dmat4(1.3933333333333333lf, 2.9333333333333336lf, 2.583333333333333lf, 1.1733333333333333lf, 2.6433333333333335lf, 1.0133333333333332lf, 1.7833333333333332lf, 1.7833333333333332lf, 2.8533333333333335lf, 1.8433333333333333lf, 3.2333333333333334lf, 0.45333333333333325lf, -0.62666666666666671lf, -0.50666666666666682lf, 0.61333333333333329lf, 1.7233333333333332lf)
 * (dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf) => dmat4(-0.79000000000000004lf, 0.75000000000000011lf, 0.40000000000000002lf, -1.01lf, 0.46000000000000008lf, -1.1699999999999999lf, -0.39999999999999997lf, -0.39999999999999997lf, 0.67000000000000004lf, -0.33999999999999997lf, 1.0499999999999998lf, -1.73lf, -2.8100000000000001lf, -2.6899999999999999lf, -1.5699999999999998lf, -0.45999999999999996lf)
 */
#version 400

void main()
{
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[0], dvec4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[0], dvec4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[1], dvec4(-0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[1], dvec4(-0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[2], dvec4(-1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[2], dvec4(-1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[3], dvec4(1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.0lf)[3], dvec4(1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf))) <= 2.1855399999999999e-09lf ? 1 : -1] array0;
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[0], dvec4(0.33333333333333326lf, 3.1033333333333335lf, 1.4233333333333333lf, 0.42333333333333323lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[0], dvec4(0.33333333333333326lf, 3.1033333333333335lf, 1.4233333333333333lf, 0.42333333333333323lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[1], dvec4(0.78333333333333321lf, 1.9533333333333331lf, 0.62333333333333329lf, -0.4866666666666668lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[1], dvec4(0.78333333333333321lf, 1.9533333333333331lf, 0.62333333333333329lf, -0.4866666666666668lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[2], dvec4(0.25333333333333319lf, 1.8133333333333332lf, -0.056666666666666643lf, -0.096666666666666679lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[2], dvec4(0.25333333333333319lf, 1.8133333333333332lf, -0.056666666666666643lf, -0.096666666666666679lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[3], dvec4(3.1233333333333331lf, -0.016666666666666829lf, 0.12333333333333329lf, 2.0533333333333332lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - -1.3333333333333333lf)[3], dvec4(3.1233333333333331lf, -0.016666666666666829lf, 0.12333333333333329lf, 2.0533333333333332lf))) <= 3.4353177777777786e-09lf ? 1 : -1] array1;
  double[(distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[0], dvec4(-1.8500000000000001lf, 0.92000000000000004lf, -0.76000000000000001lf, -1.76lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[0], dvec4(-1.8500000000000001lf, 0.92000000000000004lf, -0.76000000000000001lf, -1.76lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[1], dvec4(-1.3999999999999999lf, -0.22999999999999998lf, -1.5600000000000001lf, -2.6699999999999999lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[1], dvec4(-1.3999999999999999lf, -0.22999999999999998lf, -1.5600000000000001lf, -2.6699999999999999lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[2], dvec4(-1.9300000000000002lf, -0.37lf, -2.2399999999999998lf, -2.2799999999999998lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[2], dvec4(-1.9300000000000002lf, -0.37lf, -2.2399999999999998lf, -2.2799999999999998lf))) + (distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[3], dvec4(0.94000000000000006lf, -2.2000000000000002lf, -2.0600000000000001lf, -0.13lf)) * distance((dmat4(-1.0lf, 1.77lf, 0.089999999999999997lf, -0.91000000000000003lf, -0.55000000000000004lf, 0.62lf, -0.70999999999999996lf, -1.8200000000000001lf, -1.0800000000000001lf, 0.47999999999999998lf, -1.3899999999999999lf, -1.4299999999999999lf, 1.79lf, -1.3500000000000001lf, -1.21lf, 0.71999999999999997lf) - 0.84999999999999998lf)[3], dvec4(0.94000000000000006lf, -2.2000000000000002lf, -2.0600000000000001lf, -0.13lf))) <= 4.3581400000000008e-09lf ? 1 : -1] array2;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[0], dvec4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[0], dvec4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[1], dvec4(1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[1], dvec4(1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[2], dvec4(1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[2], dvec4(1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[3], dvec4(-1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.0lf)[3], dvec4(-1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf))) <= 2.1227800000000004e-09lf ? 1 : -1] array3;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[0], dvec4(1.3933333333333333lf, 2.9333333333333336lf, 2.583333333333333lf, 1.1733333333333333lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[0], dvec4(1.3933333333333333lf, 2.9333333333333336lf, 2.583333333333333lf, 1.1733333333333333lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[1], dvec4(2.6433333333333335lf, 1.0133333333333332lf, 1.7833333333333332lf, 1.7833333333333332lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[1], dvec4(2.6433333333333335lf, 1.0133333333333332lf, 1.7833333333333332lf, 1.7833333333333332lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[2], dvec4(2.8533333333333335lf, 1.8433333333333333lf, 3.2333333333333334lf, 0.45333333333333325lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[2], dvec4(2.8533333333333335lf, 1.8433333333333333lf, 3.2333333333333334lf, 0.45333333333333325lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[3], dvec4(-0.62666666666666671lf, -0.50666666666666682lf, 0.61333333333333329lf, 1.7233333333333332lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - -1.3333333333333333lf)[3], dvec4(-0.62666666666666671lf, -0.50666666666666682lf, 0.61333333333333329lf, 1.7233333333333332lf))) <= 5.9165577777777794e-09lf ? 1 : -1] array4;
  double[(distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[0], dvec4(-0.79000000000000004lf, 0.75000000000000011lf, 0.40000000000000002lf, -1.01lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[0], dvec4(-0.79000000000000004lf, 0.75000000000000011lf, 0.40000000000000002lf, -1.01lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[1], dvec4(0.46000000000000008lf, -1.1699999999999999lf, -0.39999999999999997lf, -0.39999999999999997lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[1], dvec4(0.46000000000000008lf, -1.1699999999999999lf, -0.39999999999999997lf, -0.39999999999999997lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[2], dvec4(0.67000000000000004lf, -0.33999999999999997lf, 1.0499999999999998lf, -1.73lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[2], dvec4(0.67000000000000004lf, -0.33999999999999997lf, 1.0499999999999998lf, -1.73lf))) + (distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[3], dvec4(-2.8100000000000001lf, -2.6899999999999999lf, -1.5699999999999998lf, -0.45999999999999996lf)) * distance((dmat4(0.059999999999999998lf, 1.6000000000000001lf, 1.25lf, -0.16lf, 1.3100000000000001lf, -0.32000000000000001lf, 0.45000000000000001lf, 0.45000000000000001lf, 1.52lf, 0.51000000000000001lf, 1.8999999999999999lf, -0.88lf, -1.96lf, -1.8400000000000001lf, -0.71999999999999997lf, 0.39000000000000001lf) - 0.84999999999999998lf)[3], dvec4(-2.8100000000000001lf, -2.6899999999999999lf, -1.5699999999999998lf, -0.45999999999999996lf))) <= 2.6735800000000006e-09lf ? 1 : -1] array5;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
