/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sqrt(0.0lf) => 0.0lf
 * sqrt(0.66666666666666663lf) => 0.81649658092772603lf
 * sqrt(1.3333333333333333lf) => 1.1547005383792515lf
 * sqrt(2.0lf) => 1.4142135623730951lf
 */
#version 400

void main()
{
  double[distance(sqrt(0.0lf), 0.0lf) <= 0.0lf ? 1 : -1] array0;
  double[distance(sqrt(0.66666666666666663lf), 0.81649658092772603lf) <= 8.1649658092772615e-06lf ? 1 : -1] array1;
  double[distance(sqrt(1.3333333333333333lf), 1.1547005383792515lf) <= 1.1547005383792516e-05lf ? 1 : -1] array2;
  double[distance(sqrt(2.0lf), 1.4142135623730951lf) <= 1.4142135623730953e-05lf ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
