/*	$OpenBSD: impactreg.h,v 1.1 2012/04/18 17:28:24 miod Exp $	*/
/*
 * Copyright (c) 2010 Miodrag Vallat.
 * Copyright (c) 2009, 2010 Joel Sing <jsing@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Impact and ImpactSR registers
 */

#define	IMPACTSR_STATUS			0x020000
#define	IMPACTSR_FIFOSTATUS		0x020008
#define	IMPACTSR_FIFO_MASK			0x000000ff
#define	IMPACTSR_GIOSTATUS		0x020100
#define	IMPACTSR_DMABUSY		0x020200
#define	IMPACTSR_CFIFO			0x020400

#define	IMPACT_STATUS			0x070000
#define	IMPACT_FIFOSTATUS		0x070004
#define	IMPACT_GIOSTATUS		0x070100
#define	IMPACT_DMABUSY			0x070104
#define	IMPACT_CFIFO			0x070080

#define	IMPACTSR_CFIFO_HW		0x040000
#define	IMPACTSR_CFIFO_LW		0x040008
#define	IMPACTSR_CFIFO_DELAY		0x040010
#define	IMPACTSR_DFIFO_HW		0x040020
#define	IMPACTSR_DFIFO_LW		0x040028
#define	IMPACTSR_DFIFO_DELAY		0x040030
#define	IMPACT_CFIFO_HW			0x050020
#define	IMPACT_CFIFO_LW			0x050024
#define	IMPACT_CFIFO_DELAY		0x050028
#define	IMPACT_DFIFO_HW			0x05002c
#define	IMPACT_DFIFO_LW			0x050030
#define	IMPACT_DFIFO_DELAY		0x050034

#define	IMPACTSR_XMAP_BASE		0x071c00
#define	IMPACT_XMAP_BASE		0x061c00

#define	IMPACTSR_XMAP_PP1SELECT		0x000008
#define	IMPACTSR_XMAP_INDEX		0x000088
#define	IMPACTSR_XMAP_CONFIG		0x000100
#define	IMPACTSR_XMAP_CONFIGB		0x000108
#define	IMPACTSR_XMAP_BUF_SELECT	0x000180
#define	IMPACTSR_XMAP_MAIN_MODE		0x000200
#define	IMPACTSR_XMAP_OVERLAY_MODE	0x000280
#define	IMPACTSR_XMAP_DIB		0x000300
#define	IMPACTSR_XMAP_DIB_DW		0x000340
#define	IMPACTSR_XMAP_RE_RAC		0x000380

#define	IMPACTSR_VC3_BASE		0x072000
#define	IMPACT_VC3_BASE			0x062000

#define	IMPACTSR_VC3_INDEX		0x000008
#define	IMPACTSR_VC3_INDEXDATA		0x000038
#define	IMPACTSR_VC3_DATA		0x0000b0
#define	IMPACTSR_VC3_RAM		0x000190

/*
 * Command FIFO instruction encoding
 */

#define	IMPACTSR_CFIFO_WRITE		0x0018000400000000UL
#define	IMPACTSR_CFIFO_EXEC		0x0004000000000000UL
#define	IMPACTSR_CFIFO_REG_SHIFT	40

/*
 * Command FIFO registers
 */

#define	IMPACTSR_CMD_GLINE_XSTARTF	0x0c
#define	IMPACTSR_CMD_IR_ALIAS		0x45
#define	IMPACTSR_CMD_BLOCKXYSTARTI	0x46	/* XY coords */
#define	IMPACTSR_CMD_BLOCKXYENDI	0x47	/* XY coords */
#define	IMPACTSR_CMD_PACKEDCOLOR	0x5b
#define	IMPACTSR_CMD_ALPHA		0x5f
#define	IMPACTSR_CMD_CHAR_H		0x70
#define	IMPACTSR_CMD_CHAR_L		0x71
#define	IMPACTSR_CMD_XFRCONTROL		0x102
#define	IMPACTSR_CMD_FILLMODE		0x110
#define	IMPACTSR_CMD_CONFIG		0x112
#define	IMPACTSR_CMD_XYWIN		0x115	/* YX coords */
#define	IMPACTSR_CMD_BKGRD_RG		0x140
#define	IMPACTSR_CMD_BKGRD_BA		0x141
#define	IMPACTSR_CMD_XFRSIZE		0x153	/* YX coords */
#define	IMPACTSR_CMD_XFRMASKLO		0x156
#define	IMPACTSR_CMD_XFRMASKHI		0x157
#define	IMPACTSR_CMD_XFRCOUNTERS	0x158	/* YX coords */
#define	IMPACTSR_CMD_XFRMODE		0x159
#define	IMPACTSR_CMD_RE_TOGGLECNTX	0x15f
#define	IMPACTSR_CMD_PP1FILLMODE	0x161
#define	IMPACTSR_CMD_COLORMASKMSBS	0x162
#define	IMPACTSR_CMD_COLORMASKLSBSA	0x163
#define	IMPACTSR_CMD_COLORMASKLSBSB	0x164
#define	IMPACTSR_CMD_DRBPOINTERS	0x16d

#define	IMPACTSR_XYCOORDS(x,y)		(((x) << 16) | (y))
#define	IMPACTSR_YXCOORDS(x,y)		(((y) << 16) | (x))

#define	IMPACTSR_PP1FILLMODE(mode,op)	((mode) | ((op) << 26))
