/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.panels;

import com.intellij.ui.KeyStrokeAdapter;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.IpnbUtils;
import org.jetbrains.plugins.ipnb.editor.IpnbEditorUtil;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbMarkdownCell;

public class IpnbMarkdownPanel
extends IpnbEditablePanel<JComponent, IpnbMarkdownCell> {
    private final IpnbFilePanel myParent;

    public IpnbMarkdownPanel(@NotNull IpnbMarkdownCell cell, @NotNull IpnbFilePanel parent) {
        if (cell == null) {
            IpnbMarkdownPanel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            IpnbMarkdownPanel.$$$reportNull$$$0(1);
        }
        super(cell);
        this.myParent = parent;
        this.initPanel();
        this.addKeyListener((KeyListener)new KeyStrokeAdapter(){

            public void keyPressed(KeyEvent event) {
                IpnbMarkdownPanel.this.myParent.processKeyPressed(event);
            }
        });
    }

    @Override
    protected String getRawCellText() {
        return ((IpnbMarkdownCell)this.myCell).getSourceAsString();
    }

    @Override
    protected JComponent createViewPanel() {
        int width = this.myParent.getWidth();
        return IpnbUtils.createLatexPane(((IpnbMarkdownCell)this.myCell).getSourceAsString(), this.myParent.getProject(), width);
    }

    @Override
    public void updateCellView() {
        int width = this.myParent.getWidth();
        this.myViewPanel = IpnbUtils.createLatexPane(((IpnbMarkdownCell)this.myCell).getSourceAsString(), this.myParent.getProject(), width);
        this.myViewPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Container parent = IpnbMarkdownPanel.this.getParent();
                MouseEvent parentEvent = SwingUtilities.convertMouseEvent(IpnbMarkdownPanel.this.myViewPanel, e, parent);
                parent.dispatchEvent(parentEvent);
                if (e.getClickCount() == 2) {
                    IpnbMarkdownPanel.this.switchToEditing();
                }
            }
        });
        this.myViewPanel.setName("View panel");
        this.myViewPrompt = new JPanel(new GridBagLayout());
        this.addPromptPanel(this.myViewPrompt, null, IpnbEditorUtil.PromptType.None, this.myViewPanel);
        this.myViewPrompt.setBackground(IpnbEditorUtil.getBackground());
        this.mySplitter.setFirstComponent((JComponent)this.myViewPrompt);
        this.mySplitter.setSecondComponent(null);
    }

    @Override
    protected Object clone() {
        return new IpnbMarkdownPanel((IpnbMarkdownCell)((IpnbMarkdownCell)this.myCell).clone(), this.myParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cell";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/ipnb/editor/panels/IpnbMarkdownPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

