/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.rebase.GitCommitEditingAction$WhenMappings;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\b\u0010\u0015\u001a\u00020\u0004H$J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\t\u001a\u00020\nH\u0004J\"\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00042\b\b\u0002\u0010#\u001a\u00020 H\u0004J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lgit4idea/rebase/GitCommitEditingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "COMMIT_NOT_IN_HEAD", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "commitPushedToProtectedBranchError", "protectedBranch", "findContainingBranches", "", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "getFailureTitle", "getLog", "Lcom/intellij/vcs/log/VcsLog;", "getLogData", "getRepository", "Lgit4idea/repo/GitRepository;", "getSelectedCommit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "getUi", "Lcom/intellij/vcs/log/VcsLogUi;", "isHeadCommit", "", "prohibitRebaseDuringRebase", "operation", "allowRebaseIfHeadCommit", "update", "intellij.vcs.git"})
public abstract class GitCommitEditingAction
extends DumbAwareAction {
    private final Logger LOG;
    private final String COMMIT_NOT_IN_HEAD = "The commit is not in the current branch";

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        super.update(e);
        Project project = e.getProject();
        VcsLog log = (VcsLog)e.getData(VcsLogDataKeys.VCS_LOG);
        VcsLogData data = (VcsLogData)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || log == null || data == null || ui == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        int selectedCommits = log.getSelectedShortDetails().size();
        if (selectedCommits != 1) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        VcsShortCommitDetails commit2 = (VcsShortCommitDetails)log.getSelectedShortDetails().get(0);
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        VcsShortCommitDetails vcsShortCommitDetails = commit2;
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsShortCommitDetails, (String)"commit");
        GitRepository repository = (GitRepository)gitRepositoryManager.getRepositoryForRoot(vcsShortCommitDetails.getRoot());
        if (repository == null) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabledAndVisible(false);
            return;
        }
        int parents = commit2.getParents().size();
        if (parents != 1) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
            presentation.setEnabled(false);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setDescription("Selected commit has " + parents + " parents");
            return;
        }
        Collection branches2 = log.getContainingBranches((Hash)commit2.getId(), commit2.getRoot());
        if (branches2 != null) {
            if (!branches2.contains("HEAD")) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                Presentation presentation3 = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
                presentation3.setDescription(this.COMMIT_NOT_IN_HEAD);
                return;
            }
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository, branches2);
            if (protectedBranch != null) {
                Presentation presentation = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(false);
                Presentation presentation4 = e.getPresentation();
                Intrinsics.checkExpressionValueIsNotNull((Object)presentation4, (String)"e.presentation");
                presentation4.setDescription(this.commitPushedToProtectedBranchError(protectedBranch));
                return;
            }
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        Object object2 = e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.data.VcsLogData");
        }
        VcsLogData data = (VcsLogData)object2;
        Object object3 = e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"e.getRequiredData(VcsLogDataKeys.VCS_LOG)");
        VcsLog log = (VcsLog)object3;
        VcsShortCommitDetails commit2 = (VcsShortCommitDetails)log.getSelectedShortDetails().get(0);
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        VcsShortCommitDetails vcsShortCommitDetails = commit2;
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsShortCommitDetails, (String)"commit");
        Repository repository = gitRepositoryManager.getRepositoryForRoot(vcsShortCommitDetails.getRoot());
        if (repository == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)repository, (String)"getRepositoryManager(pro\u2026oryForRoot(commit.root)!!");
        GitRepository repository2 = (GitRepository)repository;
        VirtualFile virtualFile = commit2.getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"commit.root");
        Hash hash = (Hash)commit2.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"commit.id");
        List<String> branches2 = this.findContainingBranches(data, virtualFile, hash);
        if (!branches2.contains("HEAD")) {
            Messages.showErrorDialog((Project)project, (String)this.COMMIT_NOT_IN_HEAD, (String)this.getFailureTitle());
            return;
        }
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository2, (Collection<String>)branches2);
        if (protectedBranch != null) {
            Messages.showErrorDialog((Project)project, (String)this.commitPushedToProtectedBranchError(protectedBranch), (String)this.getFailureTitle());
            return;
        }
    }

    @NotNull
    protected final VcsLog getLog(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(VcsLogDataKeys.VCS_LOG)");
        return (VcsLog)object;
    }

    @NotNull
    protected final VcsLogData getLogData(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.vcs.log.data.VcsLogData");
        }
        return (VcsLogData)object;
    }

    @NotNull
    protected final VcsLogUi getUi(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(VcsLogDataKeys.VCS_LOG_UI)");
        return (VcsLogUi)object;
    }

    @NotNull
    protected final VcsShortCommitDetails getSelectedCommit(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object e2 = this.getLog(e).getSelectedShortDetails().get(0);
        if (e2 == null) {
            Intrinsics.throwNpe();
        }
        return (VcsShortCommitDetails)e2;
    }

    @NotNull
    protected final GitRepository getRepository(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Intrinsics.throwNpe();
        }
        Repository repository = GitUtil.getRepositoryManager(project).getRepositoryForRoot(this.getSelectedCommit(e).getRoot());
        if (repository == null) {
            Intrinsics.throwNpe();
        }
        return (GitRepository)repository;
    }

    @NotNull
    protected abstract String getFailureTitle();

    @NotNull
    protected final List<String> findContainingBranches(@NotNull VcsLogData data, @NotNull VirtualFile root, @NotNull Hash hash) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        ContainingBranchesGetter containingBranchesGetter = data.getContainingBranchesGetter();
        Intrinsics.checkExpressionValueIsNotNull((Object)containingBranchesGetter, (String)"data.containingBranchesGetter");
        ContainingBranchesGetter branchesGetter = containingBranchesGetter;
        List list = branchesGetter.getContainingBranchesQuickly(root, hash);
        if (list == null) {
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<List<? extends String>, RuntimeException>(branchesGetter, root, hash){
                final /* synthetic */ ContainingBranchesGetter $branchesGetter;
                final /* synthetic */ VirtualFile $root;
                final /* synthetic */ Hash $hash;

                @NotNull
                public final List<String> compute() {
                    return this.$branchesGetter.getContainingBranchesSynchronously(this.$root, this.$hash);
                }
                {
                    this.$branchesGetter = containingBranchesGetter;
                    this.$root = virtualFile;
                    this.$hash = hash;
                }
            }, "Searching for branches containing the selected commit", true, data.getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ProgressManager.getInsta\u2026mit\", true, data.project)");
            list = (List)object;
        }
        return list;
    }

    private final String commitPushedToProtectedBranchError(String protectedBranch) {
        return "The commit is already pushed to protected branch '" + protectedBranch + '\'';
    }

    protected final void prohibitRebaseDuringRebase(@NotNull AnActionEvent e, @NotNull String operation, boolean allowRebaseIfHeadCommit) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        if (presentation.isEnabledAndVisible()) {
            String string;
            Repository.State state = this.getRepository(e).getState();
            Intrinsics.checkExpressionValueIsNotNull((Object)state, (String)"getRepository(e).state");
            Repository.State state2 = state;
            if (state2 == Repository.State.NORMAL || state2 == Repository.State.DETACHED) {
                return;
            }
            if (state2 == Repository.State.REBASING && allowRebaseIfHeadCommit && this.isHeadCommit(e)) {
                return;
            }
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
            presentation2.setEnabled(false);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)presentation3, (String)"e.presentation");
            switch (GitCommitEditingAction$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
                case 1: {
                    string = "Can't " + operation + " during rebase";
                    break;
                }
                case 2: {
                    string = "Can't " + operation + " during merge";
                    break;
                }
                default: {
                    this.LOG.error((Throwable)new IllegalStateException("Unexpected state: " + state2));
                    string = "Can't " + operation + " during " + state2;
                }
            }
            presentation3.setDescription(string);
        }
    }

    public static /* bridge */ /* synthetic */ void prohibitRebaseDuringRebase$default(GitCommitEditingAction gitCommitEditingAction, AnActionEvent anActionEvent, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: prohibitRebaseDuringRebase");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        gitCommitEditingAction.prohibitRebaseDuringRebase(anActionEvent, string, bl);
    }

    protected final boolean isHeadCommit(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return Intrinsics.areEqual((Object)((Hash)this.getSelectedCommit(e).getId()).asString(), (Object)this.getRepository(e).getCurrentRevision());
    }

    public GitCommitEditingAction() {
        Logger logger;
        GitCommitEditingAction gitCommitEditingAction = this;
        Logger logger2 = Logger.getInstance(GitCommitEditingAction.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        gitCommitEditingAction.LOG = logger = logger2;
        this.COMMIT_NOT_IN_HEAD = "The commit is not in the current branch";
    }
}

