/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.Progress;
import org.jetbrains.annotations.NonNls;

public class ReadWriteStatistics {
    private final Progress myProgress;
    private long myReadBytes = 0L;
    private long myReadFromLastUpdateBytes = 0L;
    private long myShownReadKBytes = 0L;
    private long mySentBytes = 0L;
    private long mySentFromLastUpdateBytes = 0L;
    private long myShownSentKBytes = 0L;
    public static final int KB = 1024;
    @NonNls
    private static final String READ_PROGRESS_MESSAGE = CvsBundle.message("progress.text.kb.read", new Object[0]);
    @NonNls
    private static final String SENT_PROGRESS_MESSAGE = CvsBundle.message("progress.text.kb.sent", new Object[0]);
    @NonNls
    private static final String PROGRESS_SENDING = CvsBundle.message("progress.text.sending.data.to.server", new Object[0]);
    @NonNls
    private static final String PROGRESS_READING = CvsBundle.message("progress.text.reading.data.from.server", new Object[0]);

    public ReadWriteStatistics() {
        this.myProgress = Progress.create();
    }

    public ReadWriteStatistics(Progress progress) {
        this.myProgress = progress;
    }

    public void read(long bytes) {
        this.myReadBytes += bytes;
        this.myReadFromLastUpdateBytes += bytes;
        if (this.myReadFromLastUpdateBytes > 1024L) {
            this.myReadFromLastUpdateBytes = 0L;
            this.myShownReadKBytes = this.myReadBytes / 1024L;
        }
        this.showProgress(PROGRESS_READING);
    }

    public void send(long bytes) {
        this.mySentBytes += bytes;
        this.mySentFromLastUpdateBytes += bytes;
        if (this.mySentFromLastUpdateBytes > 1024L) {
            this.mySentFromLastUpdateBytes = 0L;
            this.myShownSentKBytes = this.mySentBytes / 1024L;
        }
        this.showProgress(PROGRESS_SENDING);
    }

    private void showProgress(String mesasge) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(mesasge);
        if (this.myShownReadKBytes > 0L || this.myShownSentKBytes > 0L) {
            buffer.append(": ");
        }
        if (this.myShownReadKBytes > 0L) {
            buffer.append(String.valueOf(this.myShownReadKBytes));
            buffer.append(READ_PROGRESS_MESSAGE);
            if (this.myShownSentKBytes > 0L) {
                buffer.append("; ");
            }
        }
        if (this.myShownSentKBytes > 0L) {
            buffer.append(String.valueOf(this.myShownSentKBytes));
            buffer.append(SENT_PROGRESS_MESSAGE);
        }
        this.myProgress.setText(buffer.toString());
    }
}

