/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configuration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.configuration.RunConfigurationExtensionBase;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationExtensionsManager<U extends RunConfigurationBase, T extends RunConfigurationExtensionBase<U>> {
    private static final Key<List<Element>> RUN_EXTENSIONS = Key.create((String)"run.extension.elements");
    private static final String EXT_ID_ATTR = "ID";
    private static final String EXTENSION_ROOT_ATTR = "EXTENSION";
    private final ExtensionPointName<T> myExtensionPointName;

    public RunConfigurationExtensionsManager(ExtensionPointName<T> extensionPointName) {
        this.myExtensionPointName = extensionPointName;
    }

    public void readExternal(@NotNull U configuration, @NotNull Element parentNode) {
        List children;
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(1);
        }
        if ((children = parentNode.getChildren(this.getExtensionRootAttr())).isEmpty()) {
            return;
        }
        THashMap extensions = new THashMap();
        for (Object extension : this.getApplicableExtensions(configuration)) {
            extensions.put(((RunConfigurationExtensionBase)extension).getSerializationId(), extension);
        }
        boolean hasUnknownExtension = false;
        for (Element element : children) {
            RunConfigurationExtensionBase extension = (RunConfigurationExtensionBase)extensions.remove(element.getAttributeValue(this.getIdAttrName()));
            if (extension == null) {
                hasUnknownExtension = true;
                continue;
            }
            extension.readExternal(configuration, element);
        }
        if (hasUnknownExtension) {
            List copy = children.stream().map(JDOMUtil::internElement).collect(Collectors.toList());
            configuration.putCopyableUserData(RUN_EXTENSIONS, copy);
        }
    }

    @NotNull
    protected String getIdAttrName() {
        if (EXT_ID_ATTR == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(2);
        }
        return EXT_ID_ATTR;
    }

    @NotNull
    protected String getExtensionRootAttr() {
        if (EXTENSION_ROOT_ATTR == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(3);
        }
        return EXTENSION_ROOT_ATTR;
    }

    public void writeExternal(@NotNull U configuration, @NotNull Element parentNode) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(5);
        }
        TreeMap<String, Element> map = new TreeMap<String, Element>();
        List elements = (List)configuration.getCopyableUserData(RUN_EXTENSIONS);
        if (elements != null) {
            for (Element element : elements) {
                map.put(element.getAttributeValue(this.getIdAttrName()), element.clone());
            }
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            Element element = new Element(this.getExtensionRootAttr());
            element.setAttribute(this.getIdAttrName(), extension.getSerializationId());
            try {
                extension.writeExternal(configuration, element);
            }
            catch (WriteExternalException ignored) {
                continue;
            }
            if (element.getContent().isEmpty() && element.getAttributes().size() <= 1) continue;
            map.put(extension.getSerializationId(), element);
        }
        for (Element values : map.values()) {
            parentNode.addContent(values);
        }
    }

    public <V extends U> void appendEditors(@NotNull U configuration, @NotNull SettingsEditorGroup<V> group) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(6);
        }
        if (group == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(7);
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            SettingsEditor<U> editor = extension.createEditor(configuration);
            if (editor == null) continue;
            group.addEditor(extension.getEditorTitle(), editor);
        }
    }

    public void validateConfiguration(@NotNull U configuration, boolean isExecution) throws Exception {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(8);
        }
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, null)) {
            extension.validateConfiguration(configuration, isExecution);
        }
    }

    public void extendCreatedConfiguration(@NotNull U configuration, @NotNull Location location) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(9);
        }
        if (location == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(10);
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extension.extendCreatedConfiguration(configuration, location);
        }
    }

    public void extendTemplateConfiguration(@NotNull U configuration) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(11);
        }
        for (RunConfigurationExtensionBase extension : this.getApplicableExtensions(configuration)) {
            extension.extendTemplateConfiguration(configuration);
        }
    }

    public void patchCommandLine(@NotNull U configuration, RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId) throws ExecutionException {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(12);
        }
        if (cmdLine == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(13);
        }
        if (runnerId == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(14);
        }
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, runnerSettings)) {
            extension.patchCommandLine(configuration, runnerSettings, cmdLine, runnerId);
        }
    }

    public void attachExtensionsToProcess(@NotNull U configuration, @NotNull ProcessHandler handler, RunnerSettings runnerSettings) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(16);
        }
        for (RunConfigurationExtensionBase extension : this.getEnabledExtensions(configuration, runnerSettings)) {
            extension.attachToProcess(configuration, handler, runnerSettings);
        }
    }

    @NotNull
    protected List<T> getApplicableExtensions(@NotNull U configuration) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(17);
        }
        SmartList extensions = new SmartList();
        for (RunConfigurationExtensionBase extension : (RunConfigurationExtensionBase[])Extensions.getExtensions(this.myExtensionPointName)) {
            if (!extension.isApplicableFor(configuration)) continue;
            extensions.add(extension);
        }
        SmartList smartList = extensions;
        if (smartList == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(18);
        }
        return smartList;
    }

    @NotNull
    protected List<T> getEnabledExtensions(@NotNull U configuration, @Nullable RunnerSettings runnerSettings) {
        if (configuration == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(19);
        }
        SmartList extensions = new SmartList();
        for (RunConfigurationExtensionBase extension : (RunConfigurationExtensionBase[])Extensions.getExtensions(this.myExtensionPointName)) {
            if (!extension.isApplicableFor(configuration) || !extension.isEnabledFor(configuration, runnerSettings)) continue;
            extensions.add(extension);
        }
        SmartList smartList = extensions;
        if (smartList == null) {
            RunConfigurationExtensionsManager.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 2: 
            case 3: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configuration/RunConfigurationExtensionsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configuration/RunConfigurationExtensionsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdAttrName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionRootAttr";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableExtensions";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: 
            case 3: 
            case 18: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendEditors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extendCreatedConfiguration";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extendTemplateConfiguration";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachExtensionsToProcess";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableExtensions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getEnabledExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

