/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingEnvironmentUtil {
    private static final Logger LOG = Logger.getInstance(EncodingEnvironmentUtil.class);
    private static final String LC_ALL = "LC_ALL";
    private static final String LC_CTYPE = "LC_CTYPE";
    private static final String LANG = "LANG";

    public static void setLocaleEnvironmentIfMac(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(0);
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), commandLine.getCharset());
        }
    }

    public static void setLocaleEnvironmentIfMac(@NotNull Map<String, String> env, @NotNull Charset charset) {
        if (env == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(2);
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, charset);
        }
    }

    private static void setLocaleEnvironment(@NotNull Map<String, String> env, @NotNull Charset charset) {
        if (env == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(3);
        }
        if (charset == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(4);
        }
        env.put(LC_CTYPE, EncodingEnvironmentUtil.formatLocaleValue(charset));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fixed mac locale: " + charset.name());
        }
    }

    @NotNull
    private static String formatLocaleValue(@NotNull Charset charset) {
        if (charset == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(5);
        }
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String string = (language.isEmpty() || country.isEmpty() ? "en_US" : language + "_" + country) + "." + charset.name();
        if (string == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isLocaleDefined(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(7);
        }
        return EncodingEnvironmentUtil.isLocaleDefined(commandLine.getEnvironment()) || EncodingEnvironmentUtil.isLocaleDefined(commandLine.getParentEnvironment());
    }

    private static boolean isLocaleDefined(@NotNull Map<String, String> env) {
        if (env == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(8);
        }
        return !env.isEmpty() && (env.containsKey(LC_CTYPE) || env.containsKey(LC_ALL) || env.containsKey(LANG));
    }

    public static void fixDefaultEncodingIfMac(@NotNull GeneralCommandLine commandLine, @Nullable Project project) {
        if (commandLine == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(9);
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(commandLine)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(commandLine.getEnvironment(), EncodingEnvironmentUtil.getCharset(project));
        }
    }

    public static void fixDefaultEncodingIfMac(@NotNull Map<String, String> env, @Nullable Project project) {
        if (env == null) {
            EncodingEnvironmentUtil.$$$reportNull$$$0(10);
        }
        if (SystemInfo.isMac && !EncodingEnvironmentUtil.isLocaleDefined(env)) {
            EncodingEnvironmentUtil.setLocaleEnvironment(env, EncodingEnvironmentUtil.getCharset(project));
        }
    }

    private static Charset getCharset(Project project) {
        return (project != null ? EncodingProjectManager.getInstance(project) : EncodingManager.getInstance()).getDefaultCharset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/configurations/EncodingEnvironmentUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/configurations/EncodingEnvironmentUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLocaleValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnvironmentIfMac";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLocaleEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatLocaleValue";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isLocaleDefined";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "fixDefaultEncodingIfMac";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

