/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.util.log;

import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.log.LogListener;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public abstract class LogPipe
extends LogPipeBase {
    private final String myDeploymentName;
    private final String myLogPipeName;
    private final CloudAgentLogger myLogger;
    private final CloudAgentLoggingHandler myLoggingHandler;
    private boolean myClosed;
    private int myTotalLines;
    private int myLines2Skip;

    public LogPipe(String deploymentName, String logPipeName, CloudAgentLogger logger, CloudAgentLoggingHandler loggingHandler) {
        this.myDeploymentName = deploymentName;
        this.myLogPipeName = logPipeName;
        this.myLogger = logger;
        this.myLoggingHandler = loggingHandler;
        this.myClosed = false;
    }

    public void open() {
        InputStream inputStream = this.createInputStream(this.myDeploymentName);
        if (inputStream == null) {
            return;
        }
        InputStreamReader streamReader = new InputStreamReader(inputStream);
        final BufferedReader bufferedReader = new BufferedReader(streamReader);
        this.myTotalLines = 0;
        this.myLines2Skip = 0;
        new Thread("log pipe"){

            public void run() {
                try {
                    while (true) {
                        String line = bufferedReader.readLine();
                        if (LogPipe.this.myClosed) {
                            LogPipe.this.myLogger.debug("log pipe closed for: " + LogPipe.this.myDeploymentName);
                            break;
                        }
                        if (line == null) {
                            LogPipe.this.myLogger.debug("end of log stream for: " + LogPipe.this.myDeploymentName);
                            break;
                        }
                        if (LogPipe.this.myLines2Skip == 0) {
                            LogPipe.this.getLogListener().lineLogged(line);
                            LogPipe.this.myTotalLines++;
                            continue;
                        }
                        LogPipe.this.myLines2Skip--;
                    }
                }
                catch (IOException e) {
                    LogPipe.this.myLoggingHandler.println(e.toString());
                }
            }
        }.start();
    }

    public void close() {
        this.myClosed = true;
    }

    protected final void cutTail() {
        this.myLines2Skip = this.myTotalLines;
    }

    protected final boolean isClosed() {
        return this.myClosed;
    }

    protected abstract InputStream createInputStream(String var1);

    protected LogListener getLogListener() {
        return this.myLoggingHandler.getOrCreateLogListener(this.myLogPipeName);
    }
}

