/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.highlighting.ReadWriteUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    @NotNull
    public static Usage convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo usageInfo) {
        if (descriptor == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(0);
        }
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(1);
        }
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        Usage usage = UsageInfoToUsageConverter.convert(primaryElements, usageInfo);
        if (usage == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(2);
        }
        return usage;
    }

    @NotNull
    public static Usage convert(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo usageInfo) {
        ReadWriteAccessDetector.Access rwAccess;
        PsiElement usageElement;
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(3);
        }
        if (usageInfo == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(4);
        }
        if ((usageElement = usageInfo.getElement()) != null && primaryElements.length != 0 && (rwAccess = ReadWriteUtil.getReadWriteAccess((PsiElement[])primaryElements, (PsiElement)usageElement)) != null) {
            ReadWriteAccessUsageInfo2UsageAdapter readWriteAccessUsageInfo2UsageAdapter = new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess != ReadWriteAccessDetector.Access.Write, rwAccess != ReadWriteAccessDetector.Access.Read);
            if (readWriteAccessUsageInfo2UsageAdapter == null) {
                UsageInfoToUsageConverter.$$$reportNull$$$0(5);
            }
            return readWriteAccessUsageInfo2UsageAdapter;
        }
        UsageInfo2UsageAdapter usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo);
        if (usageInfo2UsageAdapter == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(6);
        }
        return usageInfo2UsageAdapter;
    }

    @NotNull
    public static Usage[] convert(@NotNull TargetElementsDescriptor descriptor, @NotNull UsageInfo[] usageInfos) {
        if (descriptor == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(7);
        }
        if (usageInfos == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(8);
        }
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        if (usages == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(9);
        }
        return usages;
    }

    @NotNull
    public static Usage[] convert(@NotNull PsiElement[] primaryElements, @NotNull UsageInfo[] usageInfos) {
        if (primaryElements == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(10);
        }
        if (usageInfos == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(11);
        }
        Usage[] usageArray = (Usage[])ContainerUtil.map((Object[])usageInfos, info -> {
            if (primaryElements == null) {
                UsageInfoToUsageConverter.$$$reportNull$$$0(13);
            }
            return UsageInfoToUsageConverter.convert(primaryElements, info);
        }, (Object[])new Usage[usageInfos.length]);
        if (usageArray == null) {
            UsageInfoToUsageConverter.$$$reportNull$$$0(12);
        }
        return usageArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/UsageInfoToUsageConverter";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryElements";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/UsageInfoToUsageConverter";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$convert$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer<PsiElement>> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer<PsiElement>> myAdditionalSearchedElements;

        public TargetElementsDescriptor(@NotNull PsiElement element) {
            if (element == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(0);
            }
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(@NotNull PsiElement[] primarySearchedElements) {
            if (primarySearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(1);
            }
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(@NotNull PsiElement[] primarySearchedElements, @NotNull PsiElement[] additionalSearchedElements) {
            if (primarySearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(2);
            }
            if (additionalSearchedElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(3);
            }
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        @NotNull
        private static PsiElement[] convertToPsiElements(@NotNull List<SmartPsiElementPointer<PsiElement>> primary) {
            if (primary == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(4);
            }
            PsiElement[] psiElementArray = (PsiElement[])ContainerUtil.toArray((Collection)ContainerUtil.mapNotNull(primary, SmartPsiElementPointer::getElement), PsiElement.ARRAY_FACTORY);
            if (psiElementArray == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(5);
            }
            return psiElementArray;
        }

        @NotNull
        private static List<SmartPsiElementPointer<PsiElement>> convertToSmartPointers(@NotNull PsiElement[] primaryElements) {
            if (primaryElements == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(6);
            }
            if (primaryElements.length == 0) {
                List<SmartPsiElementPointer<PsiElement>> list = Collections.emptyList();
                if (list == null) {
                    TargetElementsDescriptor.$$$reportNull$$$0(7);
                }
                return list;
            }
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(primaryElements[0].getProject());
            List list = ContainerUtil.mapNotNull((Object[])primaryElements, smartPointerManager::createSmartPsiElementPointer);
            if (list == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        public PsiElement[] getPrimaryElements() {
            PsiElement[] psiElementArray = TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
            if (psiElementArray == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(9);
            }
            return psiElementArray;
        }

        @NotNull
        public PsiElement[] getAdditionalElements() {
            PsiElement[] psiElementArray = TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
            if (psiElementArray == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(10);
            }
            return psiElementArray;
        }

        @NotNull
        public List<PsiElement> getAllElements() {
            PsiElement element;
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer<PsiElement> pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result2.add(element);
            }
            for (SmartPsiElementPointer<PsiElement> pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result2.add(element);
            }
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        @NotNull
        public List<SmartPsiElementPointer<PsiElement>> getAllElementPointers() {
            List list = ContainerUtil.concat(this.myPrimarySearchedElements, this.myAdditionalSearchedElements);
            if (list == null) {
                TargetElementsDescriptor.$$$reportNull$$$0(12);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primarySearchedElements";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalSearchedElements";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primary";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primaryElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/UsageInfoToUsageConverter$TargetElementsDescriptor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToPsiElements";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertToSmartPointers";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrimaryElements";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalElements";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElements";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAllElementPointers";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToPsiElements";
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "convertToSmartPointers";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

