/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.checkinProject;

import com.intellij.CvsBundle;
import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.actions.AddFileOrDirectoryAction;
import com.intellij.cvsSupport2.actions.RemoveLocallyFileOrDirectoryAction;
import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutor;
import com.intellij.cvsSupport2.cvsExecution.CvsOperationExecutorCallback;
import com.intellij.cvsSupport2.cvshandlers.CommandCvsHandler;
import com.intellij.cvsSupport2.cvshandlers.CvsHandler;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.FunctionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CvsCheckinEnvironment
implements CheckinEnvironment {
    private final Project myProject;

    public CvsCheckinEnvironment(Project project) {
        this.myProject = project;
    }

    public RefreshableOnComponent createAdditionalOptionsPanel(CheckinProjectPanel panel, PairConsumer<Object, Object> additionalDataConsumer) {
        return null;
    }

    public String getDefaultMessageFor(FilePath[] filesToCheckin) {
        if (filesToCheckin == null) {
            return null;
        }
        if (filesToCheckin.length != 1) {
            return null;
        }
        return CvsUtil.getTemplateFor(filesToCheckin[0]);
    }

    public String getHelpId() {
        return "cvs.commitProject";
    }

    public String getCheckinOperationName() {
        return CvsBundle.message((String)"operation.name.checkin.project", (Object[])new Object[0]);
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment, @NotNull NullableFunction<Object, Object> parametersHolder, Set<String> feedback) {
        if (parametersHolder == null) {
            CvsCheckinEnvironment.$$$reportNull$$$0(0);
        }
        List filesList = ChangesUtil.getPaths(changes);
        FilePath[] files = filesList.toArray(new FilePath[0]);
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.setShowErrors(false);
        ArrayList<File> dirsToPrune = new ArrayList<File>();
        for (Change c : changes) {
            if (c.getType() != Change.Type.DELETED) continue;
            ContentRevision contentRevision = c.getBeforeRevision();
            assert (contentRevision != null);
            FilePath path = contentRevision.getFile();
            FilePath parentPath = path.getParentPath();
            if (parentPath == null) continue;
            dirsToPrune.add(parentPath.getIOFile());
        }
        CvsConfiguration cvsConfiguration = CvsConfiguration.getInstance(this.myProject);
        CvsHandler handler = CommandCvsHandler.createCommitHandler(files, preparedComment, CvsBundle.message((String)"operation.name.commit.file", (Object[])new Object[]{files.length}), cvsConfiguration.MAKE_NEW_FILES_READONLY, this.myProject, cvsConfiguration.TAG_AFTER_PROJECT_COMMIT, cvsConfiguration.TAG_AFTER_PROJECT_COMMIT_NAME, dirsToPrune);
        executor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
        return executor.getResult().getErrorsAndWarnings();
    }

    public List<VcsException> commit(List<Change> changes, String preparedComment) {
        return this.commit(changes, preparedComment, (NullableFunction<Object, Object>)FunctionUtil.nullConstant(), null);
    }

    public List<VcsException> scheduleMissingFileForDeletion(List<FilePath> files) {
        for (FilePath file : files) {
            if (!file.isDirectory()) continue;
            VcsBalloonProblemNotifier.showOverChangesView((Project)this.myProject, (String)("Locally deleted directories cannot be removed from CVS. To remove a locally deleted directory from CVS, first invoke Rollback and then use " + ApplicationNamesInfo.getInstance().getFullProductName() + "'s Delete."), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
            break;
        }
        CvsHandler handler = RemoveLocallyFileOrDirectoryAction.getDefaultHandler(this.myProject, ChangesUtil.filePathsToFiles(files));
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
        return Collections.emptyList();
    }

    public List<VcsException> scheduleUnversionedFilesForAddition(List<VirtualFile> files) {
        CvsHandler handler = AddFileOrDirectoryAction.getDefaultHandler(this.myProject, VfsUtil.toVirtualFileArray(files));
        CvsOperationExecutor executor = new CvsOperationExecutor(this.myProject);
        executor.performActionSync(handler, CvsOperationExecutorCallback.EMPTY);
        return Collections.emptyList();
    }

    public boolean keepChangeListAfterCommit(ChangeList changeList) {
        return false;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersHolder", "com/intellij/cvsSupport2/checkinProject/CvsCheckinEnvironment", "commit"));
    }
}

