/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.ConfigurableFactory;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.OptionsContainingConfigurable;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesPanel;
import com.intellij.application.options.codeStyle.CodeStyleSettingsListener;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemesConfigurable
extends SearchableConfigurable.Parent.Abstract
implements OptionsContainingConfigurable,
Configurable.NoMargin,
Configurable.NoScroll,
Configurable.VariableProjectAppLevel {
    private CodeStyleSchemesPanel myRootSchemesPanel;
    private CodeStyleSchemesModel myModel;
    private List<CodeStyleConfigurableWrapper> myPanels;
    private boolean myResetCompleted = false;
    private boolean myInitResetInvoked = false;
    private boolean myRevertCompleted = false;

    public CodeStyleSchemesConfigurable(Project project) {
        this.myModel = new CodeStyleSchemesModel(project);
    }

    public JComponent createComponent() {
        this.initSchemesPanel(this.myModel);
        return this.myPanels == null || this.myPanels.isEmpty() ? null : this.myPanels.get(0).createComponent();
    }

    private void initSchemesPanel(final @NotNull CodeStyleSchemesModel model) {
        if (model == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(0);
        }
        this.myRootSchemesPanel = new CodeStyleSchemesPanel(model, 0);
        model.addListener(new CodeStyleSettingsListener(){

            @Override
            public void currentSchemeChanged(Object source) {
                if (source != CodeStyleSchemesConfigurable.this.myRootSchemesPanel) {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                }
            }

            @Override
            public void schemeListChanged() {
                CodeStyleSchemesConfigurable.this.myRootSchemesPanel.resetSchemesCombo();
            }

            @Override
            public void schemeChanged(CodeStyleScheme scheme2) {
                if (scheme2 == model.getSelectedScheme()) {
                    CodeStyleSchemesConfigurable.this.myRootSchemesPanel.onSelectedSchemeChanged();
                }
            }
        });
    }

    public boolean hasOwnContent() {
        return true;
    }

    public void disposeUIResources() {
        if (this.myPanels != null) {
            try {
                super.disposeUIResources();
                for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                    panel2.disposeUIResources();
                }
            }
            finally {
                this.myPanels = null;
                this.myModel = null;
                this.myRootSchemesPanel = null;
                this.myResetCompleted = false;
                this.myRevertCompleted = false;
                this.myInitResetInvoked = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void reset() {
        if (!this.myInitResetInvoked) {
            try {
                if (this.myResetCompleted) return;
                try {
                    this.resetImpl();
                    return;
                }
                finally {
                    this.myResetCompleted = true;
                }
            }
            finally {
                this.myInitResetInvoked = true;
            }
        } else {
            this.revert();
        }
    }

    private void resetImpl() {
        if (this.myModel != null) {
            this.myModel.reset();
        }
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                panel2.resetPanel();
            }
        }
    }

    public synchronized void resetFromChild() {
        if (!this.myResetCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myResetCompleted = true;
            }
        }
    }

    public void revert() {
        if (this.myModel.isSchemeListModified() || this.isSomeSchemeModified()) {
            this.myRevertCompleted = false;
        }
        if (!this.myRevertCompleted) {
            try {
                this.resetImpl();
            }
            finally {
                this.myRevertCompleted = true;
            }
        }
    }

    private boolean isSomeSchemeModified() {
        if (this.myPanels != null) {
            for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
                if (!panel2.isPanelModified()) continue;
                return true;
            }
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myModel.apply();
        for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
            panel2.applyPanel();
        }
        EditorFactory.getInstance().refreshAllEditors();
    }

    protected Configurable[] buildConfigurables() {
        this.myPanels = new ArrayList<CodeStyleConfigurableWrapper>();
        List<Object> providers = Arrays.asList(Extensions.getExtensions((ExtensionPointName)CodeStyleSettingsProvider.EXTENSION_POINT_NAME));
        providers.sort((p1, p2) -> {
            String name2;
            if (!p1.getPriority().equals((Object)p2.getPriority())) {
                return p1.getPriority().compareTo((Enum)p2.getPriority());
            }
            String name1 = p1.getConfigurableDisplayName();
            if (name1 == null) {
                name1 = "";
            }
            if ((name2 = p2.getConfigurableDisplayName()) == null) {
                name2 = "";
            }
            return name1.compareToIgnoreCase(name2);
        });
        for (CodeStyleSettingsProvider codeStyleSettingsProvider : providers) {
            if (!codeStyleSettingsProvider.hasSettingsPage()) continue;
            CodeStyleConfigurableWrapper e = ConfigurableFactory.Companion.getInstance().createCodeStyleConfigurable(codeStyleSettingsProvider, this.myModel, this);
            this.myPanels.add(e);
        }
        int size = this.myPanels.size();
        Configurable[] configurableArray = new Configurable[size > 0 ? size - 1 : 0];
        for (int i = 0; i < configurableArray.length; ++i) {
            configurableArray[i] = (Configurable)this.myPanels.get(i + 1);
        }
        return configurableArray;
    }

    void resetCompleted() {
        this.myRevertCompleted = false;
    }

    @NotNull
    CodeStyleSchemesModel getModel() {
        CodeStyleSchemesModel codeStyleSchemesModel = this.myModel;
        if (codeStyleSchemesModel == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(1);
        }
        return codeStyleSchemesModel;
    }

    public String getDisplayName() {
        return "Code Style";
    }

    public String getHelpTopic() {
        return "reference.settingsdialog.IDE.globalcodestyle";
    }

    public boolean isModified() {
        if (this.myModel != null) {
            if (this.myModel.containsModifiedCodeStyleSettings()) {
                return true;
            }
            for (Configurable configurable : this.myPanels) {
                if (!configurable.isModified()) continue;
                return true;
            }
            boolean schemeListModified = this.myModel.isSchemeListModified();
            if (schemeListModified) {
                this.myRevertCompleted = false;
            }
            return schemeListModified;
        }
        return false;
    }

    @NotNull
    public String getId() {
        if ("preferences.sourceCode" == null) {
            CodeStyleSchemesConfigurable.$$$reportNull$$$0(2);
        }
        return "preferences.sourceCode";
    }

    @Override
    public Set<String> processListOptions() {
        HashSet<String> result2 = new HashSet<String>();
        for (CodeStyleConfigurableWrapper panel2 : this.myPanels) {
            result2.addAll(panel2.processListOptions());
        }
        return result2;
    }

    public boolean isProjectLevel() {
        return this.myModel != null && this.myModel.isUsePerProjectSettings();
    }

    @Nullable
    public SearchableConfigurable findSubConfigurable(String name) {
        if (this.myPanels == null) {
            this.buildConfigurables();
        }
        return this.myPanels.stream().filter(panel2 -> panel2.getDisplayName().equals(name)).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/CodeStyleSchemesConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/CodeStyleSchemesConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initSchemesPanel";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

