/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OffsetsElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final String TYPE_MARKER = "e";

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        PsiFile psiFile;
        FileViewProvider viewProvider;
        PsiElement element;
        int end;
        int start;
        if (file2 == null) {
            OffsetsElementSignatureProvider.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            OffsetsElementSignatureProvider.$$$reportNull$$$0(1);
        }
        if (type == null) {
            OffsetsElementSignatureProvider.$$$reportNull$$$0(2);
        }
        if (tokenizer == null) {
            OffsetsElementSignatureProvider.$$$reportNull$$$0(3);
        }
        if (!TYPE_MARKER.equals(type)) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because given signature doesn't have expected type - can work with '%s' but got '%s'%n", this.getClass().getName(), TYPE_MARKER, type));
            }
            return null;
        }
        try {
            start = Integer.parseInt(tokenizer.nextToken());
            end = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Parsed target offsets - [%d; %d)%n", start, end));
        }
        int index = 0;
        if (tokenizer.hasMoreTokens()) {
            try {
                index = Integer.parseInt(tokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Language language = file2.getLanguage();
        if (tokenizer.hasMoreTokens()) {
            String languageId = tokenizer.nextToken();
            Language languageFromSignature = Language.findLanguageByID((String)languageId);
            if (languageFromSignature == null) {
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Couldn't find language for id %s", languageId));
                }
            } else {
                language = languageFromSignature;
            }
        }
        if ((element = (viewProvider = file2.getViewProvider()).findElementAt(start, language)) == null) {
            return null;
        }
        PsiElement result2 = this.findElement(start, end, index, element, processingInfoStorage);
        if (result2 != null) {
            return result2;
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Failed to find an element by the given offsets for language %s. Started by the element '%s' (%s)", language, element, element.getText()));
        }
        if ((psiFile = viewProvider.getPsi(language)) == null) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Couldn't find PSI for language %s", language.toString()));
            }
            return null;
        }
        PsiElement injectedStartElement = InjectedLanguageUtil.findElementAtNoCommit(psiFile, start);
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Trying to find injected element starting from the '%s'%s%n", injectedStartElement, injectedStartElement == null ? "" : String.format("(%s)", injectedStartElement.getText())));
        }
        if (injectedStartElement != null && injectedStartElement != element) {
            return this.findElement(start, end, index, injectedStartElement, processingInfoStorage);
        }
        return null;
    }

    @Nullable
    private PsiElement findElement(int start, int end, int index, @NotNull PsiElement element, @Nullable StringBuilder processingInfoStorage) {
        if (element == null) {
            OffsetsElementSignatureProvider.$$$reportNull$$$0(4);
        }
        TextRange range2 = element.getTextRange();
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Starting processing from element '%s'. It's range is %s%n", element, range2));
        }
        while (range2 != null && range2.getStartOffset() == start && range2.getEndOffset() < end) {
            if ((element = element.getParent()) == null) {
                if (processingInfoStorage != null) {
                    processingInfoStorage.append("Reached top of PSI tree");
                }
                return null;
            }
            range2 = element.getTextRange();
            if (processingInfoStorage == null) continue;
            processingInfoStorage.append(String.format("Expanding element to '%s' and range to '%s'%n", element, range2));
        }
        if (range2 == null || range2.getStartOffset() != start || range2.getEndOffset() != end) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping %s because target element's range differs from the target one. Element: '%s', it's range: %s%n", this.getClass(), element, range2));
            }
            return null;
        }
        int indexFromRoot = 0;
        for (PsiElement e = element.getParent(); e != null && range2.equals((Object)e.getTextRange()); e = e.getParent()) {
            ++indexFromRoot;
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Target element index is %d. Current index from root is %d%n", index, indexFromRoot));
        }
        if (index > indexFromRoot) {
            int steps = index - indexFromRoot;
            PsiElement result2 = element;
            for (PsiElement e = result2.getFirstChild(); steps > 0 && e != null && range2.equals((Object)e.getTextRange()); --steps, e = e.getFirstChild()) {
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Clarifying target element to '%s', its range is %s%n", result2, result2.getTextRange()));
                }
                result2 = e;
            }
            return result2;
        }
        int steps = indexFromRoot - index;
        PsiElement result3 = element;
        while (--steps >= 0) {
            result3 = result3.getParent();
            if (processingInfoStorage == null) continue;
            processingInfoStorage.append(String.format("Reducing target element to '%s', its range is %s%n", result3, result3.getTextRange()));
        }
        if (processingInfoStorage != null) {
            processingInfoStorage.append(String.format("Returning element '%s', its range is %s%n", result3, result3.getTextRange()));
        }
        return result3;
    }

    @Override
    public String getSignature(@NotNull PsiElement element) {
        TextRange range2;
        if (element == null) {
            OffsetsElementSignatureProvider.$$$reportNull$$$0(5);
        }
        if ((range2 = element.getTextRange()).isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(TYPE_MARKER).append("#");
        buffer.append(range2.getStartOffset());
        buffer.append("#");
        buffer.append(range2.getEndOffset());
        int index = 0;
        for (PsiElement e = element.getParent(); e != null && range2.equals((Object)e.getTextRange()); e = e.getParent()) {
            ++index;
        }
        buffer.append("#").append(index);
        PsiFile containingFile = element.getContainingFile();
        if (containingFile != null && containingFile.getViewProvider().getLanguages().size() > 1) {
            buffer.append("#").append(containingFile.getLanguage().getID());
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/OffsetsElementSignatureProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "restoreBySignatureTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getSignature";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

