/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider,
IntentionActionDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper");
    private IntentionAction myDelegate;
    private final String[] myCategories;
    private final IntentionActionBean myExtension;
    private String myFullFamilyName;

    IntentionActionWrapper(@NotNull IntentionActionBean extension, String[] categories) {
        if (extension == null) {
            IntentionActionWrapper.$$$reportNull$$$0(0);
        }
        this.myExtension = extension;
        this.myCategories = categories;
    }

    @NotNull
    public String getText() {
        String string = this.getDelegate().getText();
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getDelegate().getFamilyName();
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            IntentionActionWrapper.$$$reportNull$$$0(3);
        }
        return this.getDelegate().isAvailable(project, editor, file2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            IntentionActionWrapper.$$$reportNull$$$0(4);
        }
        this.getDelegate().invoke(project, editor, file2);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        if (file2 == null) {
            IntentionActionWrapper.$$$reportNull$$$0(5);
        }
        return this.getDelegate().getElementToMakeWritable(file2);
    }

    @NotNull
    public String getFullFamilyName() {
        String result2 = this.myFullFamilyName;
        if (result2 == null) {
            result2 = this.myCategories != null ? StringUtil.join((String[])this.myCategories, (String)"/") + "/" + this.getFamilyName() : this.getFamilyName();
            this.myFullFamilyName = result2;
        }
        String string = result2;
        if (string == null) {
            IntentionActionWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public synchronized IntentionAction getDelegate() {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = this.myExtension.instantiate();
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        IntentionAction intentionAction = this.myDelegate;
        if (intentionAction == null) {
            IntentionActionWrapper.$$$reportNull$$$0(7);
        }
        return intentionAction;
    }

    public String getImplementationClassName() {
        return this.myExtension.className;
    }

    @NotNull
    ClassLoader getImplementationClassLoader() {
        ClassLoader classLoader = this.myExtension.getLoaderForClass();
        if (classLoader == null) {
            IntentionActionWrapper.$$$reportNull$$$0(8);
        }
        return classLoader;
    }

    public String toString() {
        String text2;
        try {
            text2 = this.getText();
        }
        catch (PsiInvalidElementAccessException e) {
            text2 = e.getMessage();
        }
        return "Intention: (" + this.getDelegate().getClass() + "): '" + text2 + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        IntentionAction delegate = this.getDelegate();
        return delegate instanceof ShortcutProvider ? ((ShortcutProvider)delegate).getShortcut() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionActionWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFamilyName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementationClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

