/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.util.text.StringSearcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncrementalSearchHandler {
    private static final Key<PerEditorSearchData> SEARCH_DATA_IN_EDITOR_VIEW_KEY = Key.create((String)"IncrementalSearchHandler.SEARCH_DATA_IN_EDITOR_VIEW_KEY");
    private static final Key<PerHintSearchData> SEARCH_DATA_IN_HINT_KEY = Key.create((String)"IncrementalSearchHandler.SEARCH_DATA_IN_HINT_KEY");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.IncrementalSearchHandler");
    private static boolean ourActionsRegistered = false;

    public static boolean isHintVisible(Editor editor) {
        PerEditorSearchData data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
        return data != null && data.hint != null && data.hint.isVisible();
    }

    public void invoke(Project project, final Editor editor) {
        if (!ourActionsRegistered) {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            TypedAction typedAction = actionManager.getTypedAction();
            typedAction.setupRawHandler((TypedActionHandler)new MyTypedHandler(typedAction.getRawHandler()));
            actionManager.setActionHandler("EditorBackSpace", (EditorActionHandler)new BackSpaceHandler(actionManager.getActionHandler("EditorBackSpace")));
            actionManager.setActionHandler("EditorUp", (EditorActionHandler)new UpHandler(actionManager.getActionHandler("EditorUp")));
            actionManager.setActionHandler("EditorDown", (EditorActionHandler)new DownHandler(actionManager.getActionHandler("EditorDown")));
            ourActionsRegistered = true;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.incremental.search");
        String selection = editor.getSelectionModel().getSelectedText();
        MyLabel label2 = new MyLabel(selection == null ? "" : selection);
        PerEditorSearchData data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
        if (data == null) {
            data = new PerEditorSearchData();
        } else if (data.hint != null) {
            if (data.lastSearch != null) {
                PerHintSearchData hintData = (PerHintSearchData)data.hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                if ("".equals(hintData.label.getText())) {
                    label2 = new MyLabel(data.lastSearch);
                }
            }
            data.hint.hide();
        }
        MyLabel label1 = new MyLabel(" " + CodeInsightBundle.message((String)"incremental.search.tooltip.prefix", (Object[])new Object[0]));
        label1.setFont(UIUtil.getLabelFont().deriveFont(1));
        MyPanel panel2 = new MyPanel(label1);
        panel2.add((Component)label1, "West");
        panel2.add((Component)label2, "Center");
        panel2.setBorder(BorderFactory.createLineBorder(Color.black));
        final DocumentListener[] documentListener2 = new DocumentListener[1];
        final CaretListener[] caretListener = new CaretListener[1];
        final Document document = editor.getDocument();
        final LightweightHint hint = new LightweightHint(panel2){

            @Override
            public void hide() {
                PerHintSearchData data = (PerHintSearchData)this.getUserData(SEARCH_DATA_IN_HINT_KEY);
                LOG.assertTrue(data != null);
                String prefix = data.label.getText();
                super.hide();
                if (data.segmentHighlighter != null) {
                    data.segmentHighlighter.dispose();
                }
                PerEditorSearchData editorData = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
                editorData.hint = null;
                editorData.lastSearch = prefix;
                if (documentListener2[0] != null) {
                    document.removeDocumentListener(documentListener2[0]);
                    documentListener2[0] = null;
                }
                if (caretListener[0] != null) {
                    CaretListener listener2 = caretListener[0];
                    editor.getCaretModel().removeCaretListener(listener2);
                }
            }
        };
        documentListener2[0] = new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (!hint.isVisible()) {
                    return;
                }
                hint.hide();
            }
        };
        document.addDocumentListener(documentListener2[0]);
        caretListener[0] = new CaretListener(){

            public void caretPositionChanged(CaretEvent e) {
                PerHintSearchData data = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                if (data != null && data.ignoreCaretMove) {
                    return;
                }
                if (!hint.isVisible()) {
                    return;
                }
                hint.hide();
            }
        };
        CaretListener listener2 = caretListener[0];
        editor.getCaretModel().addCaretListener(listener2);
        JComponent component = editor.getComponent();
        int x = SwingUtilities.convertPoint((Component)component, (int)0, (int)0, (Component)component).x;
        int y = -hint.getComponent().getPreferredSize().height;
        Point p = SwingUtilities.convertPoint(component, x, y, component.getRootPane().getLayeredPane());
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, p, 9, 0, false, new HintHint(editor, p).setAwtTooltip(false));
        PerHintSearchData hintData = new PerHintSearchData(project, label2);
        hintData.searchStart = editor.getCaretModel().getOffset();
        hint.putUserData(SEARCH_DATA_IN_HINT_KEY, hintData);
        data.hint = hint;
        editor.putUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY, (Object)data);
        if (hintData.label.getText().length() > 0) {
            IncrementalSearchHandler.updatePosition(editor, hintData, true, false);
        }
    }

    private static boolean acceptableRegExp(String pattern) {
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            switch (pattern.charAt(i)) {
                case '*': {
                    return true;
                }
            }
        }
        return false;
    }

    private static void updatePosition(Editor editor, PerHintSearchData data, boolean nothingIfFailed, boolean searchBack) {
        int index;
        int matchLength;
        block21: {
            String prefix = data.label.getText();
            matchLength = prefix.length();
            if (matchLength == 0) {
                index = data.searchStart;
            } else {
                Document document = editor.getDocument();
                CharSequence text2 = document.getCharsSequence();
                int length = document.getTextLength();
                boolean caseSensitive = IncrementalSearchHandler.detectSmartCaseSensitive(prefix);
                if (IncrementalSearchHandler.acceptableRegExp(prefix)) {
                    StringBuffer buf = new StringBuffer(prefix.length());
                    int len = prefix.length();
                    for (int i = 0; i < len; ++i) {
                        char ch = prefix.charAt(i);
                        if (ch == '*' && i != 0 && i != len - 1) {
                            buf.append("\\w");
                        } else if ("{}[].+^$*()?".indexOf(ch) != -1) {
                            buf.append('\\');
                        }
                        buf.append(ch);
                    }
                    try {
                        Pattern pattern = Pattern.compile(buf.toString(), caseSensitive ? 0 : 2);
                        Matcher matcher = pattern.matcher(text2);
                        if (searchBack) {
                            int lastStart = -1;
                            int lastEnd = -1;
                            while (matcher.find() && matcher.start() < data.searchStart) {
                                lastStart = matcher.start();
                                lastEnd = matcher.end();
                            }
                            index = lastStart;
                            matchLength = lastEnd - lastStart;
                            break block21;
                        }
                        if (matcher.find(data.searchStart) || !nothingIfFailed && matcher.find(0)) {
                            index = matcher.start();
                            matchLength = matcher.end() - matcher.start();
                            break block21;
                        }
                        index = -1;
                    }
                    catch (PatternSyntaxException ex) {
                        index = -1;
                    }
                } else {
                    StringSearcher searcher = new StringSearcher(prefix, caseSensitive, !searchBack);
                    if (searchBack) {
                        index = searcher.scan(text2, 0, data.searchStart);
                    } else {
                        index = searcher.scan(text2, data.searchStart, length);
                        int n = index = index < 0 ? -1 : index;
                    }
                    if (index < 0 && !nothingIfFailed) {
                        index = searcher.scan(text2);
                    }
                }
            }
        }
        if (nothingIfFailed && index < 0) {
            return;
        }
        if (data.segmentHighlighter != null) {
            data.segmentHighlighter.dispose();
            data.segmentHighlighter = null;
        }
        if (index < 0) {
            data.label.setForeground((Color)JBColor.RED);
        } else {
            data.label.setForeground(JBColor.foreground());
            if (matchLength > 0) {
                TextAttributes attributes = editor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
                data.segmentHighlighter = editor.getMarkupModel().addRangeHighlighter(index, index + matchLength, 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
            }
            data.ignoreCaretMove = true;
            editor.getCaretModel().moveToOffset(index);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            data.ignoreCaretMove = false;
            IdeDocumentHistory.getInstance(data.project).includeCurrentCommandAsNavigation();
        }
    }

    private static boolean detectSmartCaseSensitive(String prefix) {
        boolean hasUpperCase = false;
        for (int i = 0; i < prefix.length(); ++i) {
            char c = prefix.charAt(i);
            if (!Character.isUpperCase(c) || Character.toUpperCase(c) == Character.toLowerCase(c)) continue;
            hasUpperCase = true;
            break;
        }
        return hasUpperCase;
    }

    public static class DownHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public DownHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            PerEditorSearchData data;
            if (editor == null) {
                DownHandler.$$$reportNull$$$0(0);
            }
            if ((data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data.hint == null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            } else {
                LightweightHint hint = data.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String prefix = hintData.label.getText();
                if (prefix == null) {
                    return;
                }
                hintData.searchStart = editor.getCaretModel().getOffset();
                if (hintData.searchStart == editor.getDocument().getTextLength()) {
                    return;
                }
                ++hintData.searchStart;
                IncrementalSearchHandler.updatePosition(editor, hintData, true, false);
                hintData.searchStart = editor.getCaretModel().getOffset();
            }
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            PerEditorSearchData data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
            return data != null && data.hint != null || this.myOriginalHandler.isEnabled(editor, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/IncrementalSearchHandler$DownHandler", "doExecute"));
        }
    }

    public static class UpHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public UpHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            PerEditorSearchData data;
            if (editor == null) {
                UpHandler.$$$reportNull$$$0(0);
            }
            if ((data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data.hint == null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            } else {
                LightweightHint hint = data.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String prefix = hintData.label.getText();
                if (prefix == null) {
                    return;
                }
                hintData.searchStart = editor.getCaretModel().getOffset();
                if (hintData.searchStart == 0) {
                    return;
                }
                --hintData.searchStart;
                IncrementalSearchHandler.updatePosition(editor, hintData, true, true);
                hintData.searchStart = editor.getCaretModel().getOffset();
            }
        }

        public boolean isEnabled(Editor editor, DataContext dataContext) {
            PerEditorSearchData data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY);
            return data != null && data.hint != null || this.myOriginalHandler.isEnabled(editor, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/IncrementalSearchHandler$UpHandler", "doExecute"));
        }
    }

    public static class BackSpaceHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public BackSpaceHandler(EditorActionHandler originalAction) {
            this.myOriginalHandler = originalAction;
        }

        public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
            PerEditorSearchData data;
            if (editor == null) {
                BackSpaceHandler.$$$reportNull$$$0(0);
            }
            if ((data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data.hint == null) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            } else {
                LightweightHint hint = data.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String text2 = hintData.label.getText();
                if (text2.length() > 0) {
                    text2 = text2.substring(0, text2.length() - 1);
                }
                hintData.label.setText(text2);
                IncrementalSearchHandler.updatePosition(editor, hintData, false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/navigation/IncrementalSearchHandler$BackSpaceHandler", "doExecute"));
        }
    }

    public static class MyTypedHandler
    extends TypedActionHandlerBase {
        public MyTypedHandler(@Nullable TypedActionHandler originalHandler) {
            super(originalHandler);
        }

        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            PerEditorSearchData data;
            if (editor == null) {
                MyTypedHandler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                MyTypedHandler.$$$reportNull$$$0(1);
            }
            if ((data = (PerEditorSearchData)editor.getUserData(SEARCH_DATA_IN_EDITOR_VIEW_KEY)) == null || data.hint == null) {
                if (this.myOriginalHandler != null) {
                    this.myOriginalHandler.execute(editor, charTyped, dataContext);
                }
            } else {
                LightweightHint hint = data.hint;
                PerHintSearchData hintData = (PerHintSearchData)hint.getUserData(SEARCH_DATA_IN_HINT_KEY);
                String text2 = hintData.label.getText();
                text2 = text2 + charTyped;
                hintData.label.setText(text2);
                MyPanel comp = (MyPanel)hint.getComponent();
                if (comp.getTruePreferredSize().width > comp.getSize().width) {
                    Rectangle bounds = hint.getBounds();
                    hint.pack();
                    hint.updateLocation(bounds.x, bounds.y);
                }
                IncrementalSearchHandler.updatePosition(editor, hintData, false, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/navigation/IncrementalSearchHandler$MyTypedHandler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPanel
    extends JPanel {
        private final Component myLeft;

        public MyPanel(Component left) {
            super(new BorderLayout());
            this.myLeft = left;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Dimension lSize = this.myLeft.getPreferredSize();
            return new Dimension(size.width + lSize.width, size.height);
        }

        public Dimension getTruePreferredSize() {
            return super.getPreferredSize();
        }
    }

    private static class MyLabel
    extends JLabel {
        public MyLabel(String text2) {
            super(text2);
            this.setBackground(HintUtil.getInformationColor());
            this.setForeground(JBColor.foreground());
            this.setOpaque(true);
        }
    }

    private static class PerEditorSearchData {
        LightweightHint hint;
        String lastSearch;

        private PerEditorSearchData() {
        }
    }

    private static class PerHintSearchData {
        final Project project;
        final JLabel label;
        int searchStart;
        RangeHighlighter segmentHighlighter;
        boolean ignoreCaretMove = false;

        public PerHintSearchData(Project project, JLabel label2) {
            this.project = project;
            this.label = label2;
        }
    }
}

