/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptorUtil {
    public static final int NONE = 0;
    static final int APPEND_LINE_NUMBER = 1;
    public static final int TRIM_AT_TREE_END = 4;
    public static final Couple<String> XML_CODE_MARKER = Couple.of((Object)"<xml-code>", (Object)"</xml-code>");

    @NotNull
    public static String extractHighlightedText(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement psiElement) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(0);
        }
        TextRange range2 = descriptor2 instanceof ProblemDescriptorBase ? ((ProblemDescriptorBase)descriptor2).getTextRange() : null;
        String string = ProblemDescriptorUtil.extractHighlightedText(range2, psiElement);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String extractHighlightedText(@Nullable TextRange range2, @Nullable PsiElement psiElement) {
        TextRange elementRange;
        if (psiElement == null || !psiElement.isValid()) {
            if ("" == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(2);
            }
            return "";
        }
        String ref = psiElement.getText();
        if (range2 != null && (elementRange = psiElement.getTextRange()) != null && (range2 = range2.shiftRight(-elementRange.getStartOffset())).getStartOffset() >= 0 && range2.getEndOffset() <= elementRange.getLength()) {
            ref = range2.substring(ref);
        }
        ref = ref.replace('\n', ' ').trim();
        ref = StringUtil.first((String)ref, (int)100, (boolean)true);
        String string = ref.trim().replaceAll("\\s+", " ");
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element, boolean appendLineNumber) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(4);
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, appendLineNumber ? 1 : 0);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, @Nullable PsiElement element, @FlagConstant int flags) {
        int endIndex;
        int lineNumber;
        String message;
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(6);
        }
        if ((message = descriptor2.getDescriptionTemplate()) == null) {
            if ("" == null) {
                ProblemDescriptorUtil.$$$reportNull$$$0(7);
            }
            return "";
        }
        if ((flags & 1) != 0 && descriptor2 instanceof ProblemDescriptor && !message.contains("#ref") && message.contains("#loc") && (lineNumber = ((ProblemDescriptor)descriptor2).getLineNumber()) >= 0) {
            message = StringUtil.replace((String)message, (String)"#loc", (String)("(" + InspectionsBundle.message((String)"inspection.export.results.at.line", (Object[])new Object[0]) + " " + (lineNumber + 1) + ")"));
        }
        message = ProblemDescriptorUtil.unescapeTags(message);
        message = StringUtil.replace((String)message, (String)"#loc ", (String)"");
        message = StringUtil.replace((String)message, (String)" #loc", (String)"");
        if ((message = StringUtil.replace((String)message, (String)"#loc", (String)"")).contains("#ref")) {
            String ref = ProblemDescriptorUtil.extractHighlightedText(descriptor2, element);
            message = StringUtil.replace((String)message, (String)"#ref", (String)ref);
        }
        int n = endIndex = (flags & 4) != 0 ? message.indexOf("#treeend") : -1;
        if (endIndex > 0) {
            message = message.substring(0, endIndex);
        }
        message = StringUtil.replace((String)message, (String)"#end", (String)"");
        message = StringUtil.replace((String)message, (String)"#treeend", (String)"");
        String string = message.trim();
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static String unescapeTags(String message) {
        message = StringUtil.replace((String)message, (String)"<code>", (String)"'");
        message = (message = StringUtil.replace((String)message, (String)"</code>", (String)"'")).contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.first) ? ProblemDescriptorUtil.unescapeXmlCode(message) : StringUtil.unescapeXml((String)message);
        return message;
    }

    private static String unescapeXmlCode(String message) {
        ArrayList<String> strings = new ArrayList<String>();
        for (String string : StringUtil.split((String)message, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.first))) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                strings.addAll(StringUtil.split((String)string, (String)((String)ProblemDescriptorUtil.XML_CODE_MARKER.second), (boolean)false));
                continue;
            }
            strings.add(string);
        }
        StringBuilder builder2 = new StringBuilder();
        for (String string : strings) {
            if (string.contains((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second)) {
                builder2.append(string.replace((CharSequence)ProblemDescriptorUtil.XML_CODE_MARKER.second, ""));
                continue;
            }
            builder2.append(StringUtil.unescapeXml((String)string));
        }
        return builder2.toString();
    }

    @NotNull
    public static String renderDescriptionMessage(@NotNull CommonProblemDescriptor descriptor2, PsiElement element) {
        if (descriptor2 == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(9);
        }
        String string = ProblemDescriptorUtil.renderDescriptionMessage(descriptor2, element, false);
        if (string == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public static HighlightInfoType highlightTypeFromDescriptor(@NotNull ProblemDescriptor problemDescriptor, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (problemDescriptor == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(11);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(12);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(13);
        }
        HighlightInfoType highlightInfoType = ProblemDescriptorUtil.getHighlightInfoType(problemDescriptor.getHighlightType(), severity, severityRegistrar);
        if (highlightInfoType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(14);
        }
        return highlightInfoType;
    }

    public static HighlightInfoType getHighlightInfoType(@NotNull ProblemHighlightType highlightType, @NotNull HighlightSeverity severity, @NotNull SeverityRegistrar severityRegistrar) {
        if (highlightType == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(15);
        }
        if (severity == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(16);
        }
        if (severityRegistrar == null) {
            ProblemDescriptorUtil.$$$reportNull$$$0(17);
        }
        switch (highlightType) {
            case GENERIC_ERROR_OR_WARNING: {
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_DEPRECATED: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.DEPRECATED.getAttributesKey());
            }
            case LIKE_MARKED_FOR_REMOVAL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.MARKED_FOR_REMOVAL.getAttributesKey());
            }
            case LIKE_UNKNOWN_SYMBOL: {
                if (severity == HighlightSeverity.ERROR) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.WRONG_REF.getAttributesKey());
                }
                if (severity == HighlightSeverity.WARNING) {
                    return new HighlightInfoType.HighlightInfoTypeImpl(severity, CodeInsightColors.WEAK_WARNING_ATTRIBUTES);
                }
                return severityRegistrar.getHighlightInfoTypeBySeverity(severity);
            }
            case LIKE_UNUSED_SYMBOL: {
                return new HighlightInfoType.HighlightInfoTypeImpl(severity, HighlightInfoType.UNUSED_SYMBOL.getAttributesKey());
            }
            case INFO: {
                return HighlightInfoType.INFO;
            }
            case WEAK_WARNING: {
                return HighlightInfoType.WEAK_WARNING;
            }
            case ERROR: {
                return HighlightInfoType.WRONG_REF;
            }
            case GENERIC_ERROR: {
                return HighlightInfoType.ERROR;
            }
            case INFORMATION: {
                return HighlightInfoType.INFORMATION;
            }
        }
        throw new RuntimeException("Cannot map " + highlightType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ProblemDescriptorUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHighlightedText";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "renderDescriptionMessage";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightTypeFromDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractHighlightedText";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderDescriptionMessage";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "highlightTypeFromDescriptor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightInfoType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static @interface FlagConstant {
    }
}

