/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.lang.InspectionExtensionsFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditInspectionToolsSettingsInSuppressedPlaceIntention
implements IntentionAction {
    private String myId;
    private String myDisplayName;

    @NotNull
    public String getFamilyName() {
        String string = InspectionsBundle.message((String)"edit.options.of.reporter.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"edit.inspection.options", (Object[])new Object[]{this.myDisplayName});
        if (string == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static String getSuppressedId(Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        for (PsiElement element = file2.findElementAt(offset); element != null && !(element instanceof PsiFile); element = element.getParent()) {
            for (InspectionExtensionsFactory factory : (InspectionExtensionsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionExtensionsFactory.EP_NAME)) {
                String suppressedIds = factory.getSuppressedInspectionIdsIn(element);
                if (suppressedIds == null) continue;
                for (String id : StringUtil.split((String)suppressedIds, (String)",")) {
                    if (!EditInspectionToolsSettingsInSuppressedPlaceIntention.isCaretOnSuppressedId(file2, offset, id)) continue;
                    return id;
                }
            }
        }
        return null;
    }

    private static boolean isCaretOnSuppressedId(PsiFile file2, int caretOffset, String suppressedId) {
        int end;
        int start;
        CharSequence fileText = file2.getViewProvider().getContents();
        return StringUtil.indexOf((CharSequence)fileText.subSequence(start = Math.max(0, caretOffset - suppressedId.length()), end = Math.min(caretOffset + suppressedId.length(), fileText.length())), (CharSequence)suppressedId) >= 0;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(2);
        }
        this.myId = EditInspectionToolsSettingsInSuppressedPlaceIntention.getSuppressedId(editor, file2);
        if (this.myId != null) {
            InspectionToolWrapper toolWrapper = this.getTool(project, file2);
            if (toolWrapper == null) {
                return false;
            }
            this.myDisplayName = toolWrapper.getDisplayName();
        }
        return this.myId != null;
    }

    @Nullable
    private InspectionToolWrapper getTool(Project project, PsiFile file2) {
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        return inspectionProfile.getToolById(this.myId, (PsiElement)file2);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        InspectionToolWrapper toolWrapper;
        if (project == null) {
            EditInspectionToolsSettingsInSuppressedPlaceIntention.$$$reportNull$$$0(3);
        }
        if ((toolWrapper = this.getTool(project, file2)) == null) {
            return;
        }
        InspectionProjectProfileManager projectProfileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = projectProfileManager.getCurrentProfile();
        EditInspectionToolsSettingsAction.editToolSettings(project, inspectionProfile, toolWrapper.getShortName());
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/EditInspectionToolsSettingsInSuppressedPlaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

