/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfo;
import com.intellij.configurationStore.ComponentInfoImpl;
import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.ComponentStoreImpl$saveApplicationComponent$;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DefaultStateSerializerKt;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.PersistenceStateAdapter;
import com.intellij.configurationStore.StateAnnotation;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.configurationStore.StorageBaseExKt;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageChooserEx;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.ComponentManagerImpl;
import com.intellij.openapi.components.impl.stores.BatchUpdateListener;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.SaveSessionAndFile;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.JDOMXIncluder;
import gnu.trove.THashMap;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\u0016\u0010\u001a\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J\"\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00072\b\u0010\u001f\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J6\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020%2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0(2\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\u0006\u0010,\u001a\u00020'H\u0002J4\u0010-\u001a\u00020\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/2\u000e\b\u0002\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J.\u00103\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u00104\u001a\u00020'2\u0006\u00105\u001a\u00020\u001d2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0014J7\u00106\u001a\u0004\u0018\u0001H7\"\b\b\u0000\u00107*\u00020#2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u00052\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709H\u0002\u00a2\u0006\u0002\u0010:J\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050<2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050<J\n\u0010>\u001a\u0004\u0018\u00010?H\u0014J2\u0010@\u001a\b\u0012\u0004\u0012\u00020A0/\"\u0004\b\u0000\u001072\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H70(2\u0006\u0010$\u001a\u00020%2\u0006\u0010B\u001a\u00020CH\u0014J(\u0010D\u001a\u00020'2\u0006\u0010\u001e\u001a\u00020\u00072\u000e\u0010)\u001a\n\u0012\u0004\u0012\u00020+\u0018\u00010*2\u0006\u0010,\u001a\u00020'H\u0002J\u0018\u0010D\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010E\u001a\u00020'H\u0016J\u001a\u0010F\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020G2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0018\u0010H\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010I\u001a\u00020\u0005H\u0016J$\u0010J\u001a\u00020\u00052\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030(2\u0006\u0010$\u001a\u00020%2\u0006\u0010E\u001a\u00020'H\u0002J\u0010\u0010K\u001a\u00020'2\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0014\u0010L\u001a\u00020'2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050*J\u0010\u0010M\u001a\u00020'2\u0006\u0010N\u001a\u00020+H\u0014J\u0018\u0010O\u001a\u00020'2\u0006\u0010N\u001a\u00020+2\u0006\u0010!\u001a\u00020\u0005H\u0002J4\u0010P\u001a\u00020\u00162\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u000e\b\u0002\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u000e\b\u0002\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u00050<J\u001c\u0010R\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010<2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*J\u001a\u0010S\u001a\u00020\u00162\u0012\u0010T\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030(09J\u001e\u0010S\u001a\u00020'2\u0006\u0010\u001f\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J\u001c\u0010U\u001a\u00020\u00162\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00050*2\u0006\u0010V\u001a\u00020WJ\u000e\u0010X\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0005J\u001c\u0010Y\u001a\u00020\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00182\u0006\u00104\u001a\u00020'J\u0010\u0010Z\u001a\u00020\u00162\u0006\u00104\u001a\u00020'H\u0014J\u0014\u0010[\u001a\u00020\u00162\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030(H\u0016RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\\"}, d2={"Lcom/intellij/configurationStore/ComponentStoreImpl;", "Lcom/intellij/openapi/components/impl/stores/IComponentStore;", "()V", "components", "", "", "kotlin.jvm.PlatformType", "Lcom/intellij/configurationStore/ComponentInfo;", "", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "getProject$intellij_platform_configurationStore_impl", "()Lcom/intellij/openapi/project/Project;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManager;", "afterSaveComponents", "", "errors", "", "", "beforeSaveComponents", "commitComponent", "session", "Lcom/intellij/configurationStore/StateStorageManager$ExternalizationSession;", "info", "componentName", "doAddComponent", "name", "component", "", "stateSpec", "Lcom/intellij/openapi/components/State;", "doInitComponent", "", "Lcom/intellij/openapi/components/PersistentStateComponent;", "changedStorages", "", "Lcom/intellij/openapi/components/StateStorage;", "reloadData", "doSave", "saveSessions", "", "Lcom/intellij/openapi/components/StateStorage$SaveSession;", "readonlyFiles", "Lcom/intellij/openapi/components/impl/stores/SaveSessionAndFile;", "doSaveComponents", "isForce", "externalizationSession", "getDefaultState", "T", "stateClass", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "getNotReloadableComponents", "", "componentNames", "getPathMacroManagerForDefaults", "Lcom/intellij/openapi/components/PathMacroManager;", "getStorageSpecs", "Lcom/intellij/openapi/components/Storage;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "initComponent", "isService", "initJdomExternalizable", "Lcom/intellij/openapi/util/JDOMExternalizable;", "initPersistencePlainComponent", "key", "initPersistenceStateComponent", "isNotReloadable", "isReloadPossible", "isUseLoadedStateAsExisting", "storage", "isUseLoadedStateAsExistingForComponent", "reinitComponents", "notReloadableComponents", "reload", "reloadState", "componentClass", "reloadStates", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "removeComponent", "save", "saveAdditionalComponents", "saveApplicationComponent", "intellij.platform.configurationStore.impl"})
public abstract class ComponentStoreImpl
implements IComponentStore {
    private final Map<String, ComponentInfo> components = Collections.synchronizedMap((Map)new THashMap());

    @Nullable
    public Project getProject$intellij_platform_configurationStore_impl() {
        return null;
    }

    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        return StateLoadPolicy.LOAD;
    }

    @Override
    @NotNull
    public abstract StateStorageManager getStorageManager();

    @Override
    public void initComponent(@NotNull Object component, boolean isService) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        String componentName = "";
        try {
            if (component instanceof PersistentStateComponent) {
                PersistentStateComponent persistentStateComponent = (PersistentStateComponent)component;
                State state2 = StoreUtil.getStateSpec((PersistentStateComponent)component);
                Intrinsics.checkExpressionValueIsNotNull((Object)state2, (String)"StoreUtil.getStateSpec(component)");
                componentName = this.initPersistenceStateComponent(persistentStateComponent, state2, isService);
            } else if (component instanceof JDOMExternalizable) {
                String string = ComponentManagerImpl.getComponentName(component);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ComponentManagerImpl.getComponentName(component)");
                componentName = string;
                this.initJdomExternalizable((JDOMExternalizable)component, componentName);
            }
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)e;
        }
        catch (Exception e) {
            ComponentStoreImplKt.getLOG().error("Cannot init " + componentName + " component state", (Throwable)e);
            return;
        }
    }

    @Override
    public void initPersistencePlainComponent(@NotNull Object component, @NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.initPersistenceStateComponent(new PersistenceStateAdapter(component), new StateAnnotation(key, new FileStorageAnnotation("$WORKSPACE_FILE$", false)), false);
    }

    private final String initPersistenceStateComponent(PersistentStateComponent<?> component, State stateSpec, boolean isService) {
        String componentName;
        block2: {
            componentName = stateSpec.name();
            ComponentInfo info = this.doAddComponent(componentName, component, stateSpec);
            if (!this.initComponent(info, null, false) || !isService) break block2;
            Project project = this.getProject$intellij_platform_configurationStore_impl();
            if (project != null) {
                Application app;
                Project project2;
                Project it = project2 = project;
                Application application = app = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
                if (!application.isHeadlessEnvironment() && !app.isUnitTestMode() && it.isInitialized()) {
                    ComponentStoreImplKt.access$notifyUnknownMacros(this, it, componentName);
                }
            }
        }
        return componentName;
    }

    @Override
    public final void save(@NotNull List<SaveSessionAndFile> readonlyFiles, boolean isForce) {
        StateStorageManager.ExternalizationSession externalizationSession;
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        List errors = (List)new SmartList();
        this.beforeSaveComponents(errors);
        StateStorageManager.ExternalizationSession externalizationSession2 = externalizationSession = this.components.isEmpty() ? null : this.getStorageManager().startExternalization();
        if (externalizationSession != null) {
            this.doSaveComponents(isForce, externalizationSession, errors);
        }
        this.afterSaveComponents(errors);
        try {
            this.saveAdditionalComponents(isForce);
        }
        catch (Throwable e) {
            errors.add(e);
        }
        if (externalizationSession != null) {
            this.doSave(externalizationSession.createSaveSessions(), readonlyFiles, errors);
        }
        CompoundRuntimeException.throwIfNotEmpty((List)errors);
    }

    protected void saveAdditionalComponents(boolean isForce) {
    }

    protected void beforeSaveComponents(@NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
    }

    protected void afterSaveComponents(@NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
    }

    @Nullable
    protected List<Throwable> doSaveComponents(boolean isForce, @NotNull StateStorageManager.ExternalizationSession externalizationSession, @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull((Object)externalizationSession, (String)"externalizationSession");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        boolean isUseModificationCount = Registry.is((String)"store.save.use.modificationCount", (boolean)true);
        Object[] objectArray = ArrayUtilRt.toStringArray((Collection)this.components.keySet());
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtilRt.toStringArray(components.keys)");
        Object[] names = objectArray;
        Arrays.sort(names);
        String timeLogPrefix = "Saving";
        StringBuilder timeLog = ComponentStoreImplKt.getLOG().isDebugEnabled() ? new StringBuilder(timeLogPrefix) : null;
        int nowInSeconds = (int)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        for (Object name : names) {
            StringBuilder stringBuilder;
            long start = timeLog == null ? 0L : System.currentTimeMillis();
            try {
                String string;
                Logger logger;
                Exception e$iv;
                Logger $receiver$iv;
                ComponentInfo info;
                if (this.components.get(name) == null) {
                    Intrinsics.throwNpe();
                }
                long currentModificationCount = -1L;
                if (info.isModificationTrackingSupported() && (currentModificationCount = info.getCurrentModificationCount()) == info.getLastModificationCount()) {
                    $receiver$iv = ComponentStoreImplKt.getLOG();
                    e$iv = null;
                    if ($receiver$iv.isDebugEnabled()) {
                        logger = $receiver$iv;
                        string = (isUseModificationCount ? "Skip " : "") + (String)name + ": modificationCount " + currentModificationCount + " equals to last saved";
                        logger.debug(string, (Throwable)e$iv);
                    }
                    if (isUseModificationCount) continue;
                }
                if (info.getLastSaved() != -1) {
                    if (isForce || nowInSeconds - info.getLastSaved() > ComponentStoreImplKt.access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD$p()) {
                        info.setLastSaved(nowInSeconds);
                    } else {
                        $receiver$iv = ComponentStoreImplKt.getLOG();
                        e$iv = null;
                        if (!$receiver$iv.isDebugEnabled()) continue;
                        logger = $receiver$iv;
                        string = "Skip " + (String)name + ": was already saved in last " + TimeUnit.SECONDS.toMinutes(ComponentStoreImplKt.access$getNOT_ROAMABLE_COMPONENT_SAVE_THRESHOLD_DEFAULT$p()) + " minutes (lastSaved " + info.getLastSaved() + ", now: " + nowInSeconds + ')';
                        logger.debug(string, (Throwable)e$iv);
                        continue;
                    }
                }
                this.commitComponent(externalizationSession, info, (String)name);
                info.updateModificationCount(currentModificationCount);
            }
            catch (Throwable e) {
                errors.add(new Exception("Cannot get " + (String)name + " component state", e));
            }
            if (timeLog == null) continue;
            StringBuilder it = stringBuilder;
            long duration = System.currentTimeMillis() - start;
            if (duration <= (long)10) continue;
            it.append("\n").append((String)name).append(" took ").append(duration).append(" ms: ").append(duration / (long)60000).append(" min ").append(duration % (long)60000 / (long)1000).append("sec");
        }
        if (timeLog != null && timeLog.length() > timeLogPrefix.length()) {
            ComponentStoreImplKt.getLOG().debug(timeLog.toString());
        }
        return errors;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveApplicationComponent(@NotNull PersistentStateComponent<?> component) {
        void result$iv;
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        StateStorageManager.ExternalizationSession externalizationSession = this.getStorageManager().startExternalization();
        if (externalizationSession == null) {
            return;
        }
        StateStorageManager.ExternalizationSession externalizationSession2 = externalizationSession;
        State state2 = StoreUtil.getStateSpec(component);
        Intrinsics.checkExpressionValueIsNotNull((Object)state2, (String)"StoreUtil.getStateSpec(component)");
        State stateSpec = state2;
        this.commitComponent(externalizationSession2, new ComponentInfoImpl(component, stateSpec), null);
        List<StateStorage.SaveSession> sessions = externalizationSession2.createSaveSessions();
        if (sessions.isEmpty()) {
            return;
        }
        String absolutePath = ((Object)Paths.get(this.getStorageManager().expandMacros(StateStorageManagerImplKt.getPath(ComponentStoreImplKt.access$findNonDeprecated(stateSpec.storages()))), new String[0]).toAbsolutePath()).toString();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        CommandProcessor.getInstance().runUndoTransparentAction(new Runnable((Ref.ObjectRef)result$iv, this, absolutePath, sessions){
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ ComponentStoreImpl this$0;
            final /* synthetic */ String $absolutePath$inlined;
            final /* synthetic */ List $sessions$inlined;
            {
                this.$result = objectRef;
                this.this$0 = componentStoreImpl;
                this.$absolutePath$inlined = string;
                this.$sessions$inlined = list2;
            }

            public final void run() {
                this.$result.element = ApplicationManager.getApplication().runWriteAction((Computable)new Computable<T>(this){
                    final /* synthetic */ saveApplicationComponent$$inlined$runUndoTransparentWriteAction$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final T compute() {
                        try {
                            VfsRootAccess.allowRootAccess(this.this$0.$absolutePath$inlined);
                            List errors = (List)new SmartList();
                            ComponentStoreImpl.doSave$default(this.this$0.this$0, this.this$0.$sessions$inlined, null, errors, 2, null);
                            CompoundRuntimeException.throwIfNotEmpty((List)errors);
                        }
                        catch (Throwable throwable) {
                            VfsRootAccess.disallowRootAccess(this.this$0.$absolutePath$inlined);
                            throw throwable;
                        }
                        VfsRootAccess.disallowRootAccess(this.this$0.$absolutePath$inlined);
                        return (T)Unit.INSTANCE;
                    }
                });
            }
        });
        Object cfr_ignored_0 = result$iv.element;
    }

    private final void commitComponent(StateStorageManager.ExternalizationSession session2, ComponentInfo info, String componentName) {
        Object component = info.getComponent();
        if (component instanceof PersistentStateComponent) {
            Object object = ((PersistentStateComponent)component).getState();
            if (object != null) {
                Object object2;
                Object it = object2 = object;
                State state2 = info.getStateSpec();
                if (state2 == null) {
                    Intrinsics.throwNpe();
                }
                State stateSpec = state2;
                List<Storage> list2 = this.getStorageSpecs((PersistentStateComponent)component, stateSpec, StateStorageOperation.WRITE);
                String string = componentName;
                if (string == null) {
                    string = stateSpec.name();
                }
                session2.setState(list2, component, string, it);
            }
        } else if (component instanceof JDOMExternalizable) {
            String string = componentName;
            if (string == null) {
                String string2 = ComponentManagerImpl.getComponentName(component);
                string = string2;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"ComponentManagerImpl.getComponentName(component)");
            }
            session2.setStateInOldStorage(component, string, component);
        }
    }

    protected void doSave(@NotNull List<? extends StateStorage.SaveSession> saveSessions, @NotNull List<SaveSessionAndFile> readonlyFiles, @NotNull List<Throwable> errors) {
        Intrinsics.checkParameterIsNotNull(saveSessions, (String)"saveSessions");
        Intrinsics.checkParameterIsNotNull(readonlyFiles, (String)"readonlyFiles");
        Intrinsics.checkParameterIsNotNull(errors, (String)"errors");
        for (StateStorage.SaveSession saveSession : saveSessions) {
            ComponentStoreImplKt.executeSave(saveSession, readonlyFiles, errors);
        }
    }

    public static /* bridge */ /* synthetic */ void doSave$default(ComponentStoreImpl componentStoreImpl, List list2, List list3, List list4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doSave");
        }
        if ((n & 2) != 0) {
            list3 = new ArrayList();
        }
        componentStoreImpl.doSave(list2, list3, list4);
    }

    private final String initJdomExternalizable(JDOMExternalizable component, String componentName) {
        StateStorage stateStorage;
        this.doAddComponent(componentName, component, null);
        if (this.getLoadPolicy() != StateLoadPolicy.LOAD) {
            return null;
        }
        try {
            Element element = this.getDefaultState(component, componentName, Element.class);
            if (element != null) {
                Element element2;
                Element it = element2 = element;
                component.readExternal(it);
            }
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error(e);
        }
        if ((stateStorage = this.getStorageManager().getOldStorage(component, componentName, StateStorageOperation.READ)) == null || (stateStorage = (Element)stateStorage.getState((Object)component, componentName, Element.class, null, false)) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)stateStorage, (String)"storageManager.getOldSto\u2026    false) ?: return null");
        StateStorage element = stateStorage;
        try {
            component.readExternal((Element)element);
        }
        catch (InvalidDataException e) {
            ComponentStoreImplKt.getLOG().error((Throwable)e);
            return null;
        }
        return componentName;
    }

    private final ComponentInfo doAddComponent(String name, Object component, State stateSpec) {
        ComponentInfo newInfo = ComponentInfoKt.createComponentInfo(component, stateSpec);
        ComponentInfo existing = this.components.put(name, newInfo);
        if (existing != null && existing.getComponent() != component) {
            this.components.put(name, existing);
            ComponentStoreImplKt.getLOG().error("Conflicting component name '" + name + "': " + existing.getComponent().getClass() + " and " + component.getClass());
            return existing;
        }
        return newInfo;
    }

    private final boolean initComponent(ComponentInfo info, Set<? extends StateStorage> changedStorages, boolean reloadData) {
        if (this.getLoadPolicy() == StateLoadPolicy.NOT_LOAD) {
            return false;
        }
        State state2 = info.getStateSpec();
        if (state2 == null) {
            Intrinsics.throwNpe();
        }
        Object object = info.getComponent();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.PersistentStateComponent<kotlin.Any>");
        }
        if (this.doInitComponent(state2, (PersistentStateComponent<Object>)((PersistentStateComponent)object), changedStorages, reloadData)) {
            ComponentInfo.updateModificationCount$default(info, 0L, 1, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean doInitComponent(State stateSpec, PersistentStateComponent<Object> component, Set<? extends StateStorage> changedStorages, boolean reloadData) {
        Object defaultState;
        Class<?> clazz;
        String name = stateSpec.name();
        if (component instanceof PersistenceStateAdapter) {
            clazz = ((PersistenceStateAdapter)component).getComponent().getClass();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<kotlin.Any>");
            }
        } else {
            Class<?> clazz2 = ComponentSerializationUtil.getStateClass(component.getClass());
            clazz = clazz2;
            Intrinsics.checkExpressionValueIsNotNull(clazz2, (String)"ComponentSerializationUt\u2026Any>(component.javaClass)");
        }
        Class<?> stateClass = clazz;
        if (!stateSpec.defaultStateAsResource() && ComponentStoreImplKt.getLOG().isDebugEnabled() && this.getDefaultState(component, name, stateClass) != null) {
            ComponentStoreImplKt.getLOG().error(name + " has default state, but not marked to load it");
        }
        Object s = defaultState = stateSpec.defaultStateAsResource() ? (Object)this.getDefaultState(component, name, stateClass) : null;
        if (this.getLoadPolicy() == StateLoadPolicy.LOAD) {
            PersistentStateComponent<Object> persistentStateComponent = component;
            if (!(persistentStateComponent instanceof StateStorageChooserEx)) {
                persistentStateComponent = null;
            }
            StateStorageChooserEx storageChooser = (StateStorageChooserEx)persistentStateComponent;
            for (Storage storageSpec : this.getStorageSpecs(component, stateSpec, StateStorageOperation.READ)) {
                StateStorageChooserEx stateStorageChooserEx = storageChooser;
                if ((stateStorageChooserEx != null ? stateStorageChooserEx.getResolution(storageSpec, StateStorageOperation.READ) : null) == StateStorageChooserEx.Resolution.SKIP) continue;
                StateStorage storage2 = this.getStorageManager().getStateStorage(storageSpec);
                StateGetter<Object> stateGetter = StorageBaseExKt.createStateGetter(this.isUseLoadedStateAsExistingForComponent(storage2, name), storage2, component, name, stateClass, reloadData);
                Object state2 = stateGetter.getState(defaultState);
                if (state2 == null) {
                    if (changedStorages == null || !changedStorages.contains(storage2)) continue;
                    Object v5 = DefaultStateSerializerKt.deserializeState(new Element("state"), stateClass, null);
                    if (v5 == null) {
                        Intrinsics.throwNpe();
                    }
                    state2 = v5;
                }
                try {
                    component.loadState(state2);
                }
                finally {
                    stateGetter.close();
                }
                return true;
            }
        }
        if (defaultState == null) {
            component.noStateLoaded();
        } else {
            component.loadState(defaultState);
        }
        return true;
    }

    private final boolean isUseLoadedStateAsExistingForComponent(StateStorage storage2, String name) {
        return this.isUseLoadedStateAsExisting(storage2) && Intrinsics.areEqual((Object)name, (Object)"AntConfiguration") ^ true && Intrinsics.areEqual((Object)name, (Object)"ProjectModuleManager") ^ true && Intrinsics.areEqual((Object)name, (Object)"FacetManager") ^ true && Intrinsics.areEqual((Object)name, (Object)"ProjectRunConfigurationManager") ^ true && Intrinsics.areEqual((Object)name, (Object)"NewModuleRootManager") ^ true && Intrinsics.areEqual((Object)name, (Object)"DeprecatedModuleOptionManager") ^ true && SystemProperties.getBooleanProperty((String)"use.loaded.state.as.existing", (boolean)true);
    }

    protected boolean isUseLoadedStateAsExisting(@NotNull StateStorage storage2) {
        Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
        StateStorage stateStorage = storage2;
        if (!(stateStorage instanceof XmlElementStorage)) {
            stateStorage = null;
        }
        XmlElementStorage xmlElementStorage = (XmlElementStorage)stateStorage;
        return (xmlElementStorage != null ? xmlElementStorage.getRoamingType() : null) != RoamingType.DISABLED;
    }

    @Nullable
    protected PathMacroManager getPathMacroManagerForDefaults() {
        return null;
    }

    private final <T> T getDefaultState(Object component, String componentName, Class<T> stateClass) {
        URL uRL = DecodeDefaultsUtil.getDefaults(component, componentName);
        if (uRL == null) {
            return null;
        }
        URL url = uRL;
        try {
            Element documentElement = JDOMXIncluder.resolve((Document)JDOMUtil.loadDocument((URL)url), (String)url.toExternalForm()).detachRootElement();
            PathMacroManager pathMacroManager = this.getPathMacroManagerForDefaults();
            if (pathMacroManager != null) {
                pathMacroManager.expandPaths(documentElement);
            }
            return DefaultStateSerializerKt.deserializeState(documentElement, stateClass, null);
        }
        catch (Throwable e) {
            throw (Throwable)new IOException("Error loading default state from " + url, e);
        }
    }

    @NotNull
    protected <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Intrinsics.checkParameterIsNotNull(component, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull((Object)operation, (String)"operation");
        Object[] storages = stateSpec.storages();
        if (storages.length == 1 || component instanceof StateStorageChooserEx) {
            return ArraysKt.toList((Object[])storages);
        }
        Object[] objectArray = storages;
        if (objectArray.length == 0) {
            if (stateSpec.defaultStateAsResource()) {
                return CollectionsKt.emptyList();
            }
            throw (Throwable)((Object)new AssertionError((Object)"No storage specified"));
        }
        return ComponentStoreImplKt.sortByDeprecated((Storage[])storages);
    }

    @Override
    public final boolean isReloadPossible(@NotNull Set<String> componentNames) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
            Iterable $receiver$iv = componentNames;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String it = (String)element$iv;
                    if (!this.isNotReloadable(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return !bl;
    }

    private final boolean isNotReloadable(String name) {
        Object object = this.components.get(name);
        if (object == null || (object = ((ComponentInfo)object).getComponent()) == null) {
            return false;
        }
        Object component = object;
        return !(component instanceof PersistentStateComponent) || !StoreUtil.getStateSpec((PersistentStateComponent)component).reloadable();
    }

    @NotNull
    public final Collection<String> getNotReloadableComponents(@NotNull Collection<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        Set notReloadableComponents = null;
        for (String componentName : componentNames) {
            if (!this.isNotReloadable(componentName)) continue;
            if (notReloadableComponents == null) {
                notReloadableComponents = new LinkedHashSet();
            }
            notReloadableComponents.add(componentName);
        }
        Set set2 = notReloadableComponents;
        return set2 != null ? (Collection)set2 : (Collection)SetsKt.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reloadStates(@NotNull Set<String> componentNames, @NotNull MessageBus messageBus) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        Intrinsics.checkParameterIsNotNull((Object)messageBus, (String)"messageBus");
        Object object = messageBus.syncPublisher(BatchUpdateListener.TOPIC);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"messageBus.syncPublisher\u2026atchUpdateListener.TOPIC)");
        BatchUpdateListener publisher$iv = (BatchUpdateListener)object;
        publisher$iv.onBatchUpdateStarted();
        try {
            ComponentStoreImpl.reinitComponents$default(this, componentNames, null, null, 6, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            publisher$iv.onBatchUpdateFinished();
        }
    }

    @Override
    public final void reloadState(@NotNull Class<? extends PersistentStateComponent<?>> componentClass) {
        block2: {
            PersistentStateComponent persistentStateComponent;
            Intrinsics.checkParameterIsNotNull(componentClass, (String)"componentClass");
            State state2 = StoreUtil.getStateSpecOrError(componentClass);
            Intrinsics.checkExpressionValueIsNotNull((Object)state2, (String)"StoreUtil.getStateSpecOrError(componentClass)");
            State stateSpec = state2;
            ComponentInfo componentInfo = this.components.get(stateSpec.name());
            if (componentInfo == null) {
                return;
            }
            ComponentInfo info = componentInfo;
            Object object = info.getComponent();
            if (!(object instanceof PersistentStateComponent)) {
                object = null;
            }
            PersistentStateComponent persistentStateComponent2 = (PersistentStateComponent)object;
            if (persistentStateComponent2 == null) break block2;
            PersistentStateComponent it = persistentStateComponent = persistentStateComponent2;
            this.initComponent(info, SetsKt.emptySet(), true);
        }
    }

    private final boolean reloadState(String componentName, Set<? extends StateStorage> changedStorages) {
        ComponentInfo componentInfo = this.components.get(componentName);
        if (componentInfo == null) {
            return false;
        }
        ComponentInfo info = componentInfo;
        if (!(info.getComponent() instanceof PersistentStateComponent)) {
            return false;
        }
        boolean changedStoragesEmpty = changedStorages.isEmpty();
        this.initComponent(info, changedStoragesEmpty ? null : changedStorages, changedStoragesEmpty);
        return true;
    }

    @Nullable
    public final Collection<String> reload(@NotNull Set<? extends StateStorage> changedStorages) {
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        if (changedStorages.isEmpty()) {
            return SetsKt.emptySet();
        }
        SmartHashSet componentNames = new SmartHashSet();
        for (StateStorage stateStorage : changedStorages) {
            try {
                stateStorage.analyzeExternalChangesAndUpdateIfNeed((Set)componentNames);
            }
            catch (Throwable e) {
                ComponentStoreImplKt.getLOG().error(e);
            }
        }
        if (componentNames.isEmpty()) {
            return SetsKt.emptySet();
        }
        Collection<String> collection = this.getNotReloadableComponents((Collection)componentNames);
        this.reinitComponents((Set)componentNames, changedStorages, collection);
        return collection.isEmpty() ? null : collection;
    }

    public final void reinitComponents(@NotNull Set<String> componentNames, @NotNull Set<? extends StateStorage> changedStorages, @NotNull Collection<String> notReloadableComponents) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        Intrinsics.checkParameterIsNotNull(changedStorages, (String)"changedStorages");
        Intrinsics.checkParameterIsNotNull(notReloadableComponents, (String)"notReloadableComponents");
        for (String componentName : componentNames) {
            if (notReloadableComponents.contains(componentName)) continue;
            this.reloadState(componentName, changedStorages);
        }
    }

    public static /* bridge */ /* synthetic */ void reinitComponents$default(ComponentStoreImpl componentStoreImpl, Set set2, Set set3, Collection collection, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reinitComponents");
        }
        if ((n & 2) != 0) {
            set3 = SetsKt.emptySet();
        }
        if ((n & 4) != 0) {
            collection = SetsKt.emptySet();
        }
        componentStoreImpl.reinitComponents(set2, set3, collection);
    }

    public final void removeComponent(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.components.remove(name);
    }
}

